/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the <a>DescribeDirectories</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectoriesResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeDirectoriesResponse.Builder, DescribeDirectoriesResponse> {
    private static final SdkField<List<DirectoryDescription>> DIRECTORY_DESCRIPTIONS_FIELD = SdkField
            .<List<DirectoryDescription>> builder(MarshallingType.LIST)
            .memberName("DirectoryDescriptions")
            .getter(getter(DescribeDirectoriesResponse::directoryDescriptions))
            .setter(setter(Builder::directoryDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectoryDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectoryDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDirectoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_DESCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("DirectoryDescriptions", DIRECTORY_DESCRIPTIONS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<DirectoryDescription> directoryDescriptions;

    private final String nextToken;

    private DescribeDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directoryDescriptions = builder.directoryDescriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DirectoryDescriptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDirectoryDescriptions() {
        return directoryDescriptions != null && !(directoryDescriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a>DirectoryDescription</a> objects that were retrieved.
     * </p>
     * <p>
     * It is possible that this list contains less than the number of items specified in the <code>Limit</code> member
     * of the request. This occurs if there are less than the requested number of items left to retrieve, or if the
     * limitations of the operation have been exceeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDirectoryDescriptions} method.
     * </p>
     * 
     * @return The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
     *         <p>
     *         It is possible that this list contains less than the number of items specified in the <code>Limit</code>
     *         member of the request. This occurs if there are less than the requested number of items left to retrieve,
     *         or if the limitations of the operation have been exceeded.
     */
    public final List<DirectoryDescription> directoryDescriptions() {
        return directoryDescriptions;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent
     * call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
     *         subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDirectoryDescriptions() ? directoryDescriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoriesResponse)) {
            return false;
        }
        DescribeDirectoriesResponse other = (DescribeDirectoriesResponse) obj;
        return hasDirectoryDescriptions() == other.hasDirectoryDescriptions()
                && Objects.equals(directoryDescriptions(), other.directoryDescriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDirectoriesResponse")
                .add("DirectoryDescriptions", hasDirectoryDescriptions() ? directoryDescriptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryDescriptions":
            return Optional.ofNullable(clazz.cast(directoryDescriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoriesResponse, T> g) {
        return obj -> g.apply((DescribeDirectoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDirectoriesResponse> {
        /**
         * <p>
         * The list of <a>DirectoryDescription</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * 
         * @param directoryDescriptions
         *        The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the
         *        <code>Limit</code> member of the request. This occurs if there are less than the requested number of
         *        items left to retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryDescriptions(Collection<DirectoryDescription> directoryDescriptions);

        /**
         * <p>
         * The list of <a>DirectoryDescription</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * 
         * @param directoryDescriptions
         *        The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the
         *        <code>Limit</code> member of the request. This occurs if there are less than the requested number of
         *        items left to retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryDescriptions(DirectoryDescription... directoryDescriptions);

        /**
         * <p>
         * The list of <a>DirectoryDescription</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.DirectoryDescription.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.directory.model.DirectoryDescription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.DirectoryDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #directoryDescriptions(List<DirectoryDescription>)}.
         * 
         * @param directoryDescriptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.DirectoryDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryDescriptions(java.util.Collection<DirectoryDescription>)
         */
        Builder directoryDescriptions(Consumer<DirectoryDescription.Builder>... directoryDescriptions);

        /**
         * <p>
         * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         * subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         *        subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<DirectoryDescription> directoryDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoriesResponse model) {
            super(model);
            directoryDescriptions(model.directoryDescriptions);
            nextToken(model.nextToken);
        }

        public final List<DirectoryDescription.Builder> getDirectoryDescriptions() {
            List<DirectoryDescription.Builder> result = DirectoryDescriptionsCopier.copyToBuilder(this.directoryDescriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectoryDescriptions(Collection<DirectoryDescription.BuilderImpl> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copyFromBuilder(directoryDescriptions);
        }

        @Override
        public final Builder directoryDescriptions(Collection<DirectoryDescription> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copy(directoryDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(DirectoryDescription... directoryDescriptions) {
            directoryDescriptions(Arrays.asList(directoryDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(Consumer<DirectoryDescription.Builder>... directoryDescriptions) {
            directoryDescriptions(Stream.of(directoryDescriptions)
                    .map(c -> DirectoryDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectoriesResponse build() {
            return new DescribeDirectoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
