/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(Certificate::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Certificate::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateReason").getter(getter(Certificate::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommonName").getter(getter(Certificate::commonName)).setter(setter(Builder::commonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()).build();

    private static final SdkField<Instant> REGISTERED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RegisteredDateTime").getter(getter(Certificate::registeredDateTime))
            .setter(setter(Builder::registeredDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDateTime").build())
            .build();

    private static final SdkField<Instant> EXPIRY_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpiryDateTime").getter(getter(Certificate::expiryDateTime)).setter(setter(Builder::expiryDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDateTime").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Certificate::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<ClientCertAuthSettings> CLIENT_CERT_AUTH_SETTINGS_FIELD = SdkField
            .<ClientCertAuthSettings> builder(MarshallingType.SDK_POJO).memberName("ClientCertAuthSettings")
            .getter(getter(Certificate::clientCertAuthSettings)).setter(setter(Builder::clientCertAuthSettings))
            .constructor(ClientCertAuthSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCertAuthSettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            STATE_FIELD, STATE_REASON_FIELD, COMMON_NAME_FIELD, REGISTERED_DATE_TIME_FIELD, EXPIRY_DATE_TIME_FIELD, TYPE_FIELD,
            CLIENT_CERT_AUTH_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateId;

    private final String state;

    private final String stateReason;

    private final String commonName;

    private final Instant registeredDateTime;

    private final Instant expiryDateTime;

    private final String type;

    private final ClientCertAuthSettings clientCertAuthSettings;

    private Certificate(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.commonName = builder.commonName;
        this.registeredDateTime = builder.registeredDateTime;
        this.expiryDateTime = builder.expiryDateTime;
        this.type = builder.type;
        this.clientCertAuthSettings = builder.clientCertAuthSettings;
    }

    /**
     * <p>
     * The identifier of the certificate.
     * </p>
     * 
     * @return The identifier of the certificate.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The state of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CertificateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the certificate.
     * @see CertificateState
     */
    public final CertificateState state() {
        return CertificateState.fromValue(state);
    }

    /**
     * <p>
     * The state of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CertificateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the certificate.
     * @see CertificateState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Describes a state change for the certificate.
     * </p>
     * 
     * @return Describes a state change for the certificate.
     */
    public final String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The common name for the certificate.
     * </p>
     * 
     * @return The common name for the certificate.
     */
    public final String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The date and time that the certificate was registered.
     * </p>
     * 
     * @return The date and time that the certificate was registered.
     */
    public final Instant registeredDateTime() {
        return registeredDateTime;
    }

    /**
     * <p>
     * The date and time when the certificate will expire.
     * </p>
     * 
     * @return The date and time when the certificate will expire.
     */
    public final Instant expiryDateTime() {
        return expiryDateTime;
    }

    /**
     * <p>
     * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     *         <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * @see CertificateType
     */
    public final CertificateType type() {
        return CertificateType.fromValue(type);
    }

    /**
     * <p>
     * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CertificateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
     *         <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
     * @see CertificateType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
     * </p>
     * 
     * @return A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
     */
    public final ClientCertAuthSettings clientCertAuthSettings() {
        return clientCertAuthSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(commonName());
        hashCode = 31 * hashCode + Objects.hashCode(registeredDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(expiryDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientCertAuthSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(certificateId(), other.certificateId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(commonName(), other.commonName())
                && Objects.equals(registeredDateTime(), other.registeredDateTime())
                && Objects.equals(expiryDateTime(), other.expiryDateTime())
                && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(clientCertAuthSettings(), other.clientCertAuthSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Certificate").add("CertificateId", certificateId()).add("State", stateAsString())
                .add("StateReason", stateReason()).add("CommonName", commonName())
                .add("RegisteredDateTime", registeredDateTime()).add("ExpiryDateTime", expiryDateTime())
                .add("Type", typeAsString()).add("ClientCertAuthSettings", clientCertAuthSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "CommonName":
            return Optional.ofNullable(clazz.cast(commonName()));
        case "RegisteredDateTime":
            return Optional.ofNullable(clazz.cast(registeredDateTime()));
        case "ExpiryDateTime":
            return Optional.ofNullable(clazz.cast(expiryDateTime()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ClientCertAuthSettings":
            return Optional.ofNullable(clazz.cast(clientCertAuthSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateReason", STATE_REASON_FIELD);
        map.put("CommonName", COMMON_NAME_FIELD);
        map.put("RegisteredDateTime", REGISTERED_DATE_TIME_FIELD);
        map.put("ExpiryDateTime", EXPIRY_DATE_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("ClientCertAuthSettings", CLIENT_CERT_AUTH_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * The identifier of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The identifier of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The state of the certificate.
         * </p>
         * 
         * @param state
         *        The state of the certificate.
         * @see CertificateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the certificate.
         * </p>
         * 
         * @param state
         *        The state of the certificate.
         * @see CertificateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateState
         */
        Builder state(CertificateState state);

        /**
         * <p>
         * Describes a state change for the certificate.
         * </p>
         * 
         * @param stateReason
         *        Describes a state change for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The common name for the certificate.
         * </p>
         * 
         * @param commonName
         *        The common name for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The date and time that the certificate was registered.
         * </p>
         * 
         * @param registeredDateTime
         *        The date and time that the certificate was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredDateTime(Instant registeredDateTime);

        /**
         * <p>
         * The date and time when the certificate will expire.
         * </p>
         * 
         * @param expiryDateTime
         *        The date and time when the certificate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryDateTime(Instant expiryDateTime);

        /**
         * <p>
         * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
         * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * </p>
         * 
         * @param type
         *        The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code>
         *        or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(String type);

        /**
         * <p>
         * The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code> or
         * <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * </p>
         * 
         * @param type
         *        The function that the registered certificate performs. Valid values include <code>ClientLDAPS</code>
         *        or <code>ClientCertAuth</code>. The default value is <code>ClientLDAPS</code>.
         * @see CertificateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateType
         */
        Builder type(CertificateType type);

        /**
         * <p>
         * A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
         * </p>
         * 
         * @param clientCertAuthSettings
         *        A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCertAuthSettings(ClientCertAuthSettings clientCertAuthSettings);

        /**
         * <p>
         * A <code>ClientCertAuthSettings</code> object that contains client certificate authentication settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClientCertAuthSettings.Builder} avoiding
         * the need to create one manually via {@link ClientCertAuthSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClientCertAuthSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #clientCertAuthSettings(ClientCertAuthSettings)}.
         * 
         * @param clientCertAuthSettings
         *        a consumer that will call methods on {@link ClientCertAuthSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientCertAuthSettings(ClientCertAuthSettings)
         */
        default Builder clientCertAuthSettings(Consumer<ClientCertAuthSettings.Builder> clientCertAuthSettings) {
            return clientCertAuthSettings(ClientCertAuthSettings.builder().applyMutation(clientCertAuthSettings).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String certificateId;

        private String state;

        private String stateReason;

        private String commonName;

        private Instant registeredDateTime;

        private Instant expiryDateTime;

        private String type;

        private ClientCertAuthSettings clientCertAuthSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            certificateId(model.certificateId);
            state(model.state);
            stateReason(model.stateReason);
            commonName(model.commonName);
            registeredDateTime(model.registeredDateTime);
            expiryDateTime(model.expiryDateTime);
            type(model.type);
            clientCertAuthSettings(model.clientCertAuthSettings);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CertificateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateReason() {
            return stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final String getCommonName() {
            return commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final Instant getRegisteredDateTime() {
            return registeredDateTime;
        }

        public final void setRegisteredDateTime(Instant registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
        }

        @Override
        public final Builder registeredDateTime(Instant registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            return this;
        }

        public final Instant getExpiryDateTime() {
            return expiryDateTime;
        }

        public final void setExpiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
        }

        @Override
        public final Builder expiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ClientCertAuthSettings.Builder getClientCertAuthSettings() {
            return clientCertAuthSettings != null ? clientCertAuthSettings.toBuilder() : null;
        }

        public final void setClientCertAuthSettings(ClientCertAuthSettings.BuilderImpl clientCertAuthSettings) {
            this.clientCertAuthSettings = clientCertAuthSettings != null ? clientCertAuthSettings.build() : null;
        }

        @Override
        public final Builder clientCertAuthSettings(ClientCertAuthSettings clientCertAuthSettings) {
            this.clientCertAuthSettings = clientCertAuthSettings;
            return this;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
