/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about Amazon SNS topic and Directory Service directory associations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EventTopic implements SdkPojo, Serializable, ToCopyableBuilder<EventTopic.Builder, EventTopic> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(EventTopic::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicName").getter(getter(EventTopic::topicName)).setter(setter(Builder::topicName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()).build();

    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TopicArn").getter(getter(EventTopic::topicArn)).setter(setter(Builder::topicArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()).build();

    private static final SdkField<Instant> CREATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDateTime").getter(getter(EventTopic::createdDateTime)).setter(setter(Builder::createdDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDateTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(EventTopic::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            TOPIC_NAME_FIELD, TOPIC_ARN_FIELD, CREATED_DATE_TIME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String topicName;

    private final String topicArn;

    private final Instant createdDateTime;

    private final String status;

    private EventTopic(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.topicName = builder.topicName;
        this.topicArn = builder.topicArn;
        this.createdDateTime = builder.createdDateTime;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS topic.
     * </p>
     * 
     * @return The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS
     *         topic.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of an Amazon SNS topic the receives status messages from the directory.
     * </p>
     * 
     * @return The name of an Amazon SNS topic the receives status messages from the directory.
     */
    public final String topicName() {
        return topicName;
    }

    /**
     * <p>
     * The Amazon SNS topic ARN (Amazon Resource Name).
     * </p>
     * 
     * @return The Amazon SNS topic ARN (Amazon Resource Name).
     */
    public final String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The date and time of when you associated your directory with the Amazon SNS topic.
     * </p>
     * 
     * @return The date and time of when you associated your directory with the Amazon SNS topic.
     */
    public final Instant createdDateTime() {
        return createdDateTime;
    }

    /**
     * <p>
     * The topic registration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The topic registration status.
     * @see TopicStatus
     */
    public final TopicStatus status() {
        return TopicStatus.fromValue(status);
    }

    /**
     * <p>
     * The topic registration status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TopicStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The topic registration status.
     * @see TopicStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(topicName());
        hashCode = 31 * hashCode + Objects.hashCode(topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTopic)) {
            return false;
        }
        EventTopic other = (EventTopic) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(topicName(), other.topicName())
                && Objects.equals(topicArn(), other.topicArn()) && Objects.equals(createdDateTime(), other.createdDateTime())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EventTopic").add("DirectoryId", directoryId()).add("TopicName", topicName())
                .add("TopicArn", topicArn()).add("CreatedDateTime", createdDateTime()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "TopicName":
            return Optional.ofNullable(clazz.cast(topicName()));
        case "TopicArn":
            return Optional.ofNullable(clazz.cast(topicArn()));
        case "CreatedDateTime":
            return Optional.ofNullable(clazz.cast(createdDateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("TopicName", TOPIC_NAME_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("CreatedDateTime", CREATED_DATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTopic, T> g) {
        return obj -> g.apply((EventTopic) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EventTopic> {
        /**
         * <p>
         * The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS topic.
         * </p>
         * 
         * @param directoryId
         *        The Directory ID of an Directory Service directory that will publish status messages to an Amazon SNS
         *        topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of an Amazon SNS topic the receives status messages from the directory.
         * </p>
         * 
         * @param topicName
         *        The name of an Amazon SNS topic the receives status messages from the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicName(String topicName);

        /**
         * <p>
         * The Amazon SNS topic ARN (Amazon Resource Name).
         * </p>
         * 
         * @param topicArn
         *        The Amazon SNS topic ARN (Amazon Resource Name).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The date and time of when you associated your directory with the Amazon SNS topic.
         * </p>
         * 
         * @param createdDateTime
         *        The date and time of when you associated your directory with the Amazon SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDateTime(Instant createdDateTime);

        /**
         * <p>
         * The topic registration status.
         * </p>
         * 
         * @param status
         *        The topic registration status.
         * @see TopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The topic registration status.
         * </p>
         * 
         * @param status
         *        The topic registration status.
         * @see TopicStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TopicStatus
         */
        Builder status(TopicStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String topicName;

        private String topicArn;

        private Instant createdDateTime;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTopic model) {
            directoryId(model.directoryId);
            topicName(model.topicName);
            topicArn(model.topicArn);
            createdDateTime(model.createdDateTime);
            status(model.status);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getTopicName() {
            return topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getTopicArn() {
            return topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final Instant getCreatedDateTime() {
            return createdDateTime;
        }

        public final void setCreatedDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
        }

        @Override
        public final Builder createdDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public EventTopic build() {
            return new EventTopic(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
