/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about one or more IP address blocks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpRouteInfo implements SdkPojo, Serializable, ToCopyableBuilder<IpRouteInfo.Builder, IpRouteInfo> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(IpRouteInfo::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> CIDR_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CidrIp")
            .getter(getter(IpRouteInfo::cidrIp)).setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").build()).build();

    private static final SdkField<String> IP_ROUTE_STATUS_MSG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpRouteStatusMsg").getter(getter(IpRouteInfo::ipRouteStatusMsgAsString))
            .setter(setter(Builder::ipRouteStatusMsg))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRouteStatusMsg").build()).build();

    private static final SdkField<Instant> ADDED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("AddedDateTime").getter(getter(IpRouteInfo::addedDateTime)).setter(setter(Builder::addedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddedDateTime").build()).build();

    private static final SdkField<String> IP_ROUTE_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpRouteStatusReason").getter(getter(IpRouteInfo::ipRouteStatusReason))
            .setter(setter(Builder::ipRouteStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRouteStatusReason").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(IpRouteInfo::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            CIDR_IP_FIELD, IP_ROUTE_STATUS_MSG_FIELD, ADDED_DATE_TIME_FIELD, IP_ROUTE_STATUS_REASON_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String cidrIp;

    private final String ipRouteStatusMsg;

    private final Instant addedDateTime;

    private final String ipRouteStatusReason;

    private final String description;

    private IpRouteInfo(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.cidrIp = builder.cidrIp;
        this.ipRouteStatusMsg = builder.ipRouteStatusMsg;
        this.addedDateTime = builder.addedDateTime;
        this.ipRouteStatusReason = builder.ipRouteStatusReason;
        this.description = builder.description;
    }

    /**
     * <p>
     * Identifier (ID) of the directory associated with the IP addresses.
     * </p>
     * 
     * @return Identifier (ID) of the directory associated with the IP addresses.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * IP address block in the <a>IpRoute</a>.
     * </p>
     * 
     * @return IP address block in the <a>IpRoute</a>.
     */
    public final String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * The status of the IP address block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipRouteStatusMsg}
     * will return {@link IpRouteStatusMsg#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipRouteStatusMsgAsString}.
     * </p>
     * 
     * @return The status of the IP address block.
     * @see IpRouteStatusMsg
     */
    public final IpRouteStatusMsg ipRouteStatusMsg() {
        return IpRouteStatusMsg.fromValue(ipRouteStatusMsg);
    }

    /**
     * <p>
     * The status of the IP address block.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ipRouteStatusMsg}
     * will return {@link IpRouteStatusMsg#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ipRouteStatusMsgAsString}.
     * </p>
     * 
     * @return The status of the IP address block.
     * @see IpRouteStatusMsg
     */
    public final String ipRouteStatusMsgAsString() {
        return ipRouteStatusMsg;
    }

    /**
     * <p>
     * The date and time the address block was added to the directory.
     * </p>
     * 
     * @return The date and time the address block was added to the directory.
     */
    public final Instant addedDateTime() {
        return addedDateTime;
    }

    /**
     * <p>
     * The reason for the IpRouteStatusMsg.
     * </p>
     * 
     * @return The reason for the IpRouteStatusMsg.
     */
    public final String ipRouteStatusReason() {
        return ipRouteStatusReason;
    }

    /**
     * <p>
     * Description of the <a>IpRouteInfo</a>.
     * </p>
     * 
     * @return Description of the <a>IpRouteInfo</a>.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(ipRouteStatusMsgAsString());
        hashCode = 31 * hashCode + Objects.hashCode(addedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(ipRouteStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRouteInfo)) {
            return false;
        }
        IpRouteInfo other = (IpRouteInfo) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(cidrIp(), other.cidrIp())
                && Objects.equals(ipRouteStatusMsgAsString(), other.ipRouteStatusMsgAsString())
                && Objects.equals(addedDateTime(), other.addedDateTime())
                && Objects.equals(ipRouteStatusReason(), other.ipRouteStatusReason())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpRouteInfo").add("DirectoryId", directoryId()).add("CidrIp", cidrIp())
                .add("IpRouteStatusMsg", ipRouteStatusMsgAsString()).add("AddedDateTime", addedDateTime())
                .add("IpRouteStatusReason", ipRouteStatusReason()).add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "IpRouteStatusMsg":
            return Optional.ofNullable(clazz.cast(ipRouteStatusMsgAsString()));
        case "AddedDateTime":
            return Optional.ofNullable(clazz.cast(addedDateTime()));
        case "IpRouteStatusReason":
            return Optional.ofNullable(clazz.cast(ipRouteStatusReason()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("CidrIp", CIDR_IP_FIELD);
        map.put("IpRouteStatusMsg", IP_ROUTE_STATUS_MSG_FIELD);
        map.put("AddedDateTime", ADDED_DATE_TIME_FIELD);
        map.put("IpRouteStatusReason", IP_ROUTE_STATUS_REASON_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpRouteInfo, T> g) {
        return obj -> g.apply((IpRouteInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpRouteInfo> {
        /**
         * <p>
         * Identifier (ID) of the directory associated with the IP addresses.
         * </p>
         * 
         * @param directoryId
         *        Identifier (ID) of the directory associated with the IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * IP address block in the <a>IpRoute</a>.
         * </p>
         * 
         * @param cidrIp
         *        IP address block in the <a>IpRoute</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * The status of the IP address block.
         * </p>
         * 
         * @param ipRouteStatusMsg
         *        The status of the IP address block.
         * @see IpRouteStatusMsg
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpRouteStatusMsg
         */
        Builder ipRouteStatusMsg(String ipRouteStatusMsg);

        /**
         * <p>
         * The status of the IP address block.
         * </p>
         * 
         * @param ipRouteStatusMsg
         *        The status of the IP address block.
         * @see IpRouteStatusMsg
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpRouteStatusMsg
         */
        Builder ipRouteStatusMsg(IpRouteStatusMsg ipRouteStatusMsg);

        /**
         * <p>
         * The date and time the address block was added to the directory.
         * </p>
         * 
         * @param addedDateTime
         *        The date and time the address block was added to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addedDateTime(Instant addedDateTime);

        /**
         * <p>
         * The reason for the IpRouteStatusMsg.
         * </p>
         * 
         * @param ipRouteStatusReason
         *        The reason for the IpRouteStatusMsg.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRouteStatusReason(String ipRouteStatusReason);

        /**
         * <p>
         * Description of the <a>IpRouteInfo</a>.
         * </p>
         * 
         * @param description
         *        Description of the <a>IpRouteInfo</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String cidrIp;

        private String ipRouteStatusMsg;

        private Instant addedDateTime;

        private String ipRouteStatusReason;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRouteInfo model) {
            directoryId(model.directoryId);
            cidrIp(model.cidrIp);
            ipRouteStatusMsg(model.ipRouteStatusMsg);
            addedDateTime(model.addedDateTime);
            ipRouteStatusReason(model.ipRouteStatusReason);
            description(model.description);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final String getIpRouteStatusMsg() {
            return ipRouteStatusMsg;
        }

        public final void setIpRouteStatusMsg(String ipRouteStatusMsg) {
            this.ipRouteStatusMsg = ipRouteStatusMsg;
        }

        @Override
        public final Builder ipRouteStatusMsg(String ipRouteStatusMsg) {
            this.ipRouteStatusMsg = ipRouteStatusMsg;
            return this;
        }

        @Override
        public final Builder ipRouteStatusMsg(IpRouteStatusMsg ipRouteStatusMsg) {
            this.ipRouteStatusMsg(ipRouteStatusMsg == null ? null : ipRouteStatusMsg.toString());
            return this;
        }

        public final Instant getAddedDateTime() {
            return addedDateTime;
        }

        public final void setAddedDateTime(Instant addedDateTime) {
            this.addedDateTime = addedDateTime;
        }

        @Override
        public final Builder addedDateTime(Instant addedDateTime) {
            this.addedDateTime = addedDateTime;
            return this;
        }

        public final String getIpRouteStatusReason() {
            return ipRouteStatusReason;
        }

        public final void setIpRouteStatusReason(String ipRouteStatusReason) {
            this.ipRouteStatusReason = ipRouteStatusReason;
        }

        @Override
        public final Builder ipRouteStatusReason(String ipRouteStatusReason) {
            this.ipRouteStatusReason = ipRouteStatusReason;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public IpRouteInfo build() {
            return new IpRouteInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
