/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddIpRoutesRequest extends DirectoryRequest implements
        ToCopyableBuilder<AddIpRoutesRequest.Builder, AddIpRoutesRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AddIpRoutesRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<IpRoute>> IP_ROUTES_FIELD = SdkField
            .<List<IpRoute>> builder(MarshallingType.LIST)
            .getter(getter(AddIpRoutesRequest::ipRoutes))
            .setter(setter(Builder::ipRoutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRoutes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRoute> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRoute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> UPDATE_SECURITY_GROUP_FOR_DIRECTORY_CONTROLLERS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(AddIpRoutesRequest::updateSecurityGroupForDirectoryControllers))
            .setter(setter(Builder::updateSecurityGroupForDirectoryControllers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("UpdateSecurityGroupForDirectoryControllers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            IP_ROUTES_FIELD, UPDATE_SECURITY_GROUP_FOR_DIRECTORY_CONTROLLERS_FIELD));

    private final String directoryId;

    private final List<IpRoute> ipRoutes;

    private final Boolean updateSecurityGroupForDirectoryControllers;

    private AddIpRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.ipRoutes = builder.ipRoutes;
        this.updateSecurityGroupForDirectoryControllers = builder.updateSecurityGroupForDirectoryControllers;
    }

    /**
     * <p>
     * Identifier (ID) of the directory to which to add the address block.
     * </p>
     * 
     * @return Identifier (ID) of the directory to which to add the address block.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS
     * server used for your on-premises domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the
     *         DNS server used for your on-premises domain.
     */
    public List<IpRoute> ipRoutes() {
        return ipRoutes;
    }

    /**
     * <p>
     * If set to true, updates the inbound and outbound rules of the security group that has the description:
     * "AWS created security group for <i>directory ID</i> directory controllers." Following are the new rules:
     * </p>
     * <p>
     * Inbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
     * </p>
     * </li>
     * <li>
     * <p>
     * Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
     * </p>
     * </li>
     * </ul>
     * <p/>
     * <p>
     * Outbound:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
     * </p>
     * </li>
     * </ul>
     * <p>
     * These security rules impact an internal network interface that is not exposed publicly.
     * </p>
     * 
     * @return If set to true, updates the inbound and outbound rules of the security group that has the description:
     *         "AWS created security group for <i>directory ID</i> directory controllers." Following are the new rules:
     *         </p>
     *         <p>
     *         Inbound:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
     *         </p>
     *         </li>
     *         </ul>
     *         <p/>
     *         <p>
     *         Outbound:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         These security rules impact an internal network interface that is not exposed publicly.
     */
    public Boolean updateSecurityGroupForDirectoryControllers() {
        return updateSecurityGroupForDirectoryControllers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(ipRoutes());
        hashCode = 31 * hashCode + Objects.hashCode(updateSecurityGroupForDirectoryControllers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddIpRoutesRequest)) {
            return false;
        }
        AddIpRoutesRequest other = (AddIpRoutesRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(ipRoutes(), other.ipRoutes())
                && Objects.equals(updateSecurityGroupForDirectoryControllers(),
                        other.updateSecurityGroupForDirectoryControllers());
    }

    @Override
    public String toString() {
        return ToString.builder("AddIpRoutesRequest").add("DirectoryId", directoryId()).add("IpRoutes", ipRoutes())
                .add("UpdateSecurityGroupForDirectoryControllers", updateSecurityGroupForDirectoryControllers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "IpRoutes":
            return Optional.ofNullable(clazz.cast(ipRoutes()));
        case "UpdateSecurityGroupForDirectoryControllers":
            return Optional.ofNullable(clazz.cast(updateSecurityGroupForDirectoryControllers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddIpRoutesRequest, T> g) {
        return obj -> g.apply((AddIpRoutesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, AddIpRoutesRequest> {
        /**
         * <p>
         * Identifier (ID) of the directory to which to add the address block.
         * </p>
         * 
         * @param directoryId
         *        Identifier (ID) of the directory to which to add the address block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS
         * server used for your on-premises domain.
         * </p>
         * 
         * @param ipRoutes
         *        IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of
         *        the DNS server used for your on-premises domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRoutes(Collection<IpRoute> ipRoutes);

        /**
         * <p>
         * IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS
         * server used for your on-premises domain.
         * </p>
         * 
         * @param ipRoutes
         *        IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of
         *        the DNS server used for your on-premises domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRoutes(IpRoute... ipRoutes);

        /**
         * <p>
         * IP address blocks, using CIDR format, of the traffic to route. This is often the IP address block of the DNS
         * server used for your on-premises domain.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IpRoute>.Builder} avoiding the need to
         * create one manually via {@link List<IpRoute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IpRoute>.Builder#build()} is called immediately and its
         * result is passed to {@link #ipRoutes(List<IpRoute>)}.
         * 
         * @param ipRoutes
         *        a consumer that will call methods on {@link List<IpRoute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRoutes(List<IpRoute>)
         */
        Builder ipRoutes(Consumer<IpRoute.Builder>... ipRoutes);

        /**
         * <p>
         * If set to true, updates the inbound and outbound rules of the security group that has the description:
         * "AWS created security group for <i>directory ID</i> directory controllers." Following are the new rules:
         * </p>
         * <p>
         * Inbound:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
         * </p>
         * </li>
         * <li>
         * <p>
         * Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
         * </p>
         * </li>
         * </ul>
         * <p/>
         * <p>
         * Outbound:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
         * </p>
         * </li>
         * </ul>
         * <p>
         * These security rules impact an internal network interface that is not exposed publicly.
         * </p>
         * 
         * @param updateSecurityGroupForDirectoryControllers
         *        If set to true, updates the inbound and outbound rules of the security group that has the description:
         *        "AWS created security group for <i>directory ID</i> directory controllers." Following are the new
         *        rules: </p>
         *        <p>
         *        Inbound:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Type: Custom UDP Rule, Protocol: UDP, Range: 88, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom UDP Rule, Protocol: UDP, Range: 123, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom UDP Rule, Protocol: UDP, Range: 138, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom UDP Rule, Protocol: UDP, Range: 389, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom UDP Rule, Protocol: UDP, Range: 464, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom UDP Rule, Protocol: UDP, Range: 445, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 88, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 135, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 445, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 464, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 636, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 1024-65535, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: Custom TCP Rule, Protocol: TCP, Range: 3268-33269, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: DNS (UDP), Protocol: UDP, Range: 53, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: DNS (TCP), Protocol: TCP, Range: 53, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: LDAP, Protocol: TCP, Range: 389, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Type: All ICMP, Protocol: All, Range: N/A, Source: 0.0.0.0/0
         *        </p>
         *        </li>
         *        </ul>
         *        <p/>
         *        <p>
         *        Outbound:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Type: All traffic, Protocol: All, Range: All, Destination: 0.0.0.0/0
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        These security rules impact an internal network interface that is not exposed publicly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateSecurityGroupForDirectoryControllers(Boolean updateSecurityGroupForDirectoryControllers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<IpRoute> ipRoutes = DefaultSdkAutoConstructList.getInstance();

        private Boolean updateSecurityGroupForDirectoryControllers;

        private BuilderImpl() {
        }

        private BuilderImpl(AddIpRoutesRequest model) {
            super(model);
            directoryId(model.directoryId);
            ipRoutes(model.ipRoutes);
            updateSecurityGroupForDirectoryControllers(model.updateSecurityGroupForDirectoryControllers);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<IpRoute.Builder> getIpRoutes() {
            return ipRoutes != null ? ipRoutes.stream().map(IpRoute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ipRoutes(Collection<IpRoute> ipRoutes) {
            this.ipRoutes = IpRoutesCopier.copy(ipRoutes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRoutes(IpRoute... ipRoutes) {
            ipRoutes(Arrays.asList(ipRoutes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRoutes(Consumer<IpRoute.Builder>... ipRoutes) {
            ipRoutes(Stream.of(ipRoutes).map(c -> IpRoute.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIpRoutes(Collection<IpRoute.BuilderImpl> ipRoutes) {
            this.ipRoutes = IpRoutesCopier.copyFromBuilder(ipRoutes);
        }

        public final Boolean getUpdateSecurityGroupForDirectoryControllers() {
            return updateSecurityGroupForDirectoryControllers;
        }

        @Override
        public final Builder updateSecurityGroupForDirectoryControllers(Boolean updateSecurityGroupForDirectoryControllers) {
            this.updateSecurityGroupForDirectoryControllers = updateSecurityGroupForDirectoryControllers;
            return this;
        }

        public final void setUpdateSecurityGroupForDirectoryControllers(Boolean updateSecurityGroupForDirectoryControllers) {
            this.updateSecurityGroupForDirectoryControllers = updateSecurityGroupForDirectoryControllers;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddIpRoutesRequest build() {
            return new AddIpRoutesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
