/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the <a>DescribeDirectories</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectoriesResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeDirectoriesResponse.Builder, DescribeDirectoriesResponse> {
    private static final SdkField<List<DirectoryDescription>> DIRECTORY_DESCRIPTIONS_FIELD = SdkField
            .<List<DirectoryDescription>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDirectoriesResponse::directoryDescriptions))
            .setter(setter(Builder::directoryDescriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryDescriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DirectoryDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(DirectoryDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDirectoriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_DESCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<DirectoryDescription> directoryDescriptions;

    private final String nextToken;

    private DescribeDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directoryDescriptions = builder.directoryDescriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of <a>DirectoryDescription</a> objects that were retrieved.
     * </p>
     * <p>
     * It is possible that this list contains less than the number of items specified in the <code>Limit</code> member
     * of the request. This occurs if there are less than the requested number of items left to retrieve, or if the
     * limitations of the operation have been exceeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
     *         <p>
     *         It is possible that this list contains less than the number of items specified in the <code>Limit</code>
     *         member of the request. This occurs if there are less than the requested number of items left to retrieve,
     *         or if the limitations of the operation have been exceeded.
     */
    public List<DirectoryDescription> directoryDescriptions() {
        return directoryDescriptions;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent
     * call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
     *         subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoriesResponse)) {
            return false;
        }
        DescribeDirectoriesResponse other = (DescribeDirectoriesResponse) obj;
        return Objects.equals(directoryDescriptions(), other.directoryDescriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDirectoriesResponse").add("DirectoryDescriptions", directoryDescriptions())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryDescriptions":
            return Optional.ofNullable(clazz.cast(directoryDescriptions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoriesResponse, T> g) {
        return obj -> g.apply((DescribeDirectoriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDirectoriesResponse> {
        /**
         * <p>
         * The list of <a>DirectoryDescription</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * 
         * @param directoryDescriptions
         *        The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the
         *        <code>Limit</code> member of the request. This occurs if there are less than the requested number of
         *        items left to retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryDescriptions(Collection<DirectoryDescription> directoryDescriptions);

        /**
         * <p>
         * The list of <a>DirectoryDescription</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * 
         * @param directoryDescriptions
         *        The list of <a>DirectoryDescription</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the
         *        <code>Limit</code> member of the request. This occurs if there are less than the requested number of
         *        items left to retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryDescriptions(DirectoryDescription... directoryDescriptions);

        /**
         * <p>
         * The list of <a>DirectoryDescription</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DirectoryDescription>.Builder} avoiding the
         * need to create one manually via {@link List<DirectoryDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DirectoryDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #directoryDescriptions(List<DirectoryDescription>)}.
         * 
         * @param directoryDescriptions
         *        a consumer that will call methods on {@link List<DirectoryDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryDescriptions(List<DirectoryDescription>)
         */
        Builder directoryDescriptions(Consumer<DirectoryDescription.Builder>... directoryDescriptions);

        /**
         * <p>
         * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         * subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         *        subsequent call to <a>DescribeDirectories</a> to retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<DirectoryDescription> directoryDescriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoriesResponse model) {
            super(model);
            directoryDescriptions(model.directoryDescriptions);
            nextToken(model.nextToken);
        }

        public final Collection<DirectoryDescription.Builder> getDirectoryDescriptions() {
            return directoryDescriptions != null ? directoryDescriptions.stream().map(DirectoryDescription::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directoryDescriptions(Collection<DirectoryDescription> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copy(directoryDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(DirectoryDescription... directoryDescriptions) {
            directoryDescriptions(Arrays.asList(directoryDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(Consumer<DirectoryDescription.Builder>... directoryDescriptions) {
            directoryDescriptions(Stream.of(directoryDescriptions)
                    .map(c -> DirectoryDescription.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectoryDescriptions(Collection<DirectoryDescription.BuilderImpl> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copyFromBuilder(directoryDescriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectoriesResponse build() {
            return new DescribeDirectoriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
