/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes event topics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventTopicsRequest extends DirectoryRequest implements
        ToCopyableBuilder<DescribeEventTopicsRequest.Builder, DescribeEventTopicsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeEventTopicsRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> TOPIC_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeEventTopicsRequest::topicNames))
            .setter(setter(Builder::topicNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            TOPIC_NAMES_FIELD));

    private final String directoryId;

    private final List<String> topicNames;

    private DescribeEventTopicsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.topicNames = builder.topicNames;
    }

    /**
     * <p>
     * The Directory ID for which to get the list of associated SNS topics. If this member is null, associations for all
     * Directory IDs are returned.
     * </p>
     * 
     * @return The Directory ID for which to get the list of associated SNS topics. If this member is null, associations
     *         for all Directory IDs are returned.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * A list of SNS topic names for which to obtain the information. If this member is null, all associations for the
     * specified Directory ID are returned.
     * </p>
     * <p>
     * An empty list results in an <code>InvalidParameterException</code> being thrown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of SNS topic names for which to obtain the information. If this member is null, all associations
     *         for the specified Directory ID are returned.</p>
     *         <p>
     *         An empty list results in an <code>InvalidParameterException</code> being thrown.
     */
    public List<String> topicNames() {
        return topicNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(topicNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventTopicsRequest)) {
            return false;
        }
        DescribeEventTopicsRequest other = (DescribeEventTopicsRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(topicNames(), other.topicNames());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeEventTopicsRequest").add("DirectoryId", directoryId()).add("TopicNames", topicNames())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "TopicNames":
            return Optional.ofNullable(clazz.cast(topicNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventTopicsRequest, T> g) {
        return obj -> g.apply((DescribeEventTopicsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventTopicsRequest> {
        /**
         * <p>
         * The Directory ID for which to get the list of associated SNS topics. If this member is null, associations for
         * all Directory IDs are returned.
         * </p>
         * 
         * @param directoryId
         *        The Directory ID for which to get the list of associated SNS topics. If this member is null,
         *        associations for all Directory IDs are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * A list of SNS topic names for which to obtain the information. If this member is null, all associations for
         * the specified Directory ID are returned.
         * </p>
         * <p>
         * An empty list results in an <code>InvalidParameterException</code> being thrown.
         * </p>
         * 
         * @param topicNames
         *        A list of SNS topic names for which to obtain the information. If this member is null, all
         *        associations for the specified Directory ID are returned.</p>
         *        <p>
         *        An empty list results in an <code>InvalidParameterException</code> being thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicNames(Collection<String> topicNames);

        /**
         * <p>
         * A list of SNS topic names for which to obtain the information. If this member is null, all associations for
         * the specified Directory ID are returned.
         * </p>
         * <p>
         * An empty list results in an <code>InvalidParameterException</code> being thrown.
         * </p>
         * 
         * @param topicNames
         *        A list of SNS topic names for which to obtain the information. If this member is null, all
         *        associations for the specified Directory ID are returned.</p>
         *        <p>
         *        An empty list results in an <code>InvalidParameterException</code> being thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicNames(String... topicNames);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> topicNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventTopicsRequest model) {
            super(model);
            directoryId(model.directoryId);
            topicNames(model.topicNames);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getTopicNames() {
            return topicNames;
        }

        @Override
        public final Builder topicNames(Collection<String> topicNames) {
            this.topicNames = TopicNamesCopier.copy(topicNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicNames(String... topicNames) {
            topicNames(Arrays.asList(topicNames));
            return this;
        }

        public final void setTopicNames(Collection<String> topicNames) {
            this.topicNames = TopicNamesCopier.copy(topicNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventTopicsRequest build() {
            return new DescribeEventTopicsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
