/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * IP address block. This is often the address block of the DNS server used for your on-premises domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpRoute implements SdkPojo, Serializable, ToCopyableBuilder<IpRoute.Builder, IpRoute> {
    private static final SdkField<String> CIDR_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IpRoute::cidrIp)).setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IpRoute::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_IP_FIELD,
            DESCRIPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cidrIp;

    private final String description;

    private IpRoute(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
        this.description = builder.description;
    }

    /**
     * <p>
     * IP address block using CIDR format, for example 10.0.0.0/24. This is often the address block of the DNS server
     * used for your on-premises domain. For a single IP address use a CIDR address block with /32. For example
     * 10.0.0.0/32.
     * </p>
     * 
     * @return IP address block using CIDR format, for example 10.0.0.0/24. This is often the address block of the DNS
     *         server used for your on-premises domain. For a single IP address use a CIDR address block with /32. For
     *         example 10.0.0.0/32.
     */
    public String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * Description of the address block.
     * </p>
     * 
     * @return Description of the address block.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRoute)) {
            return false;
        }
        IpRoute other = (IpRoute) obj;
        return Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(description(), other.description());
    }

    @Override
    public String toString() {
        return ToString.builder("IpRoute").add("CidrIp", cidrIp()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpRoute, T> g) {
        return obj -> g.apply((IpRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpRoute> {
        /**
         * <p>
         * IP address block using CIDR format, for example 10.0.0.0/24. This is often the address block of the DNS
         * server used for your on-premises domain. For a single IP address use a CIDR address block with /32. For
         * example 10.0.0.0/32.
         * </p>
         * 
         * @param cidrIp
         *        IP address block using CIDR format, for example 10.0.0.0/24. This is often the address block of the
         *        DNS server used for your on-premises domain. For a single IP address use a CIDR address block with
         *        /32. For example 10.0.0.0/32.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * Description of the address block.
         * </p>
         * 
         * @param description
         *        Description of the address block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIp;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRoute model) {
            cidrIp(model.cidrIp);
            description(model.description);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public IpRoute build() {
            return new IpRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
