/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RejectSharedDirectoryRequest extends DirectoryRequest implements
        ToCopyableBuilder<RejectSharedDirectoryRequest.Builder, RejectSharedDirectoryRequest> {
    private static final SdkField<String> SHARED_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RejectSharedDirectoryRequest::sharedDirectoryId)).setter(setter(Builder::sharedDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectoryId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_DIRECTORY_ID_FIELD));

    private final String sharedDirectoryId;

    private RejectSharedDirectoryRequest(BuilderImpl builder) {
        super(builder);
        this.sharedDirectoryId = builder.sharedDirectoryId;
    }

    /**
     * <p>
     * Identifier of the shared directory in the directory consumer account. This identifier is different for each
     * directory owner account.
     * </p>
     * 
     * @return Identifier of the shared directory in the directory consumer account. This identifier is different for
     *         each directory owner account.
     */
    public String sharedDirectoryId() {
        return sharedDirectoryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sharedDirectoryId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectSharedDirectoryRequest)) {
            return false;
        }
        RejectSharedDirectoryRequest other = (RejectSharedDirectoryRequest) obj;
        return Objects.equals(sharedDirectoryId(), other.sharedDirectoryId());
    }

    @Override
    public String toString() {
        return ToString.builder("RejectSharedDirectoryRequest").add("SharedDirectoryId", sharedDirectoryId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedDirectoryId":
            return Optional.ofNullable(clazz.cast(sharedDirectoryId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RejectSharedDirectoryRequest, T> g) {
        return obj -> g.apply((RejectSharedDirectoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, RejectSharedDirectoryRequest> {
        /**
         * <p>
         * Identifier of the shared directory in the directory consumer account. This identifier is different for each
         * directory owner account.
         * </p>
         * 
         * @param sharedDirectoryId
         *        Identifier of the shared directory in the directory consumer account. This identifier is different for
         *        each directory owner account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDirectoryId(String sharedDirectoryId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String sharedDirectoryId;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectSharedDirectoryRequest model) {
            super(model);
            sharedDirectoryId(model.sharedDirectoryId);
        }

        public final String getSharedDirectoryId() {
            return sharedDirectoryId;
        }

        @Override
        public final Builder sharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
            return this;
        }

        public final void setSharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RejectSharedDirectoryRequest build() {
            return new RejectSharedDirectoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
