/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a trust relationship between an AWS Managed Microsoft AD directory and an external domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trust implements SdkPojo, Serializable, ToCopyableBuilder<Trust.Builder, Trust> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> TRUST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::trustId)).setter(setter(Builder::trustId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustId").build()).build();

    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::remoteDomainName)).setter(setter(Builder::remoteDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()).build();

    private static final SdkField<String> TRUST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::trustTypeAsString)).setter(setter(Builder::trustType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustType").build()).build();

    private static final SdkField<String> TRUST_DIRECTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::trustDirectionAsString)).setter(setter(Builder::trustDirection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustDirection").build()).build();

    private static final SdkField<String> TRUST_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::trustStateAsString)).setter(setter(Builder::trustState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustState").build()).build();

    private static final SdkField<Instant> CREATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Trust::createdDateTime)).setter(setter(Builder::createdDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Trust::lastUpdatedDateTime)).setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final SdkField<Instant> STATE_LAST_UPDATED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).getter(getter(Trust::stateLastUpdatedDateTime))
            .setter(setter(Builder::stateLastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateLastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> TRUST_STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::trustStateReason)).setter(setter(Builder::trustStateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustStateReason").build()).build();

    private static final SdkField<String> SELECTIVE_AUTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Trust::selectiveAuthAsString)).setter(setter(Builder::selectiveAuth))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectiveAuth").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            TRUST_ID_FIELD, REMOTE_DOMAIN_NAME_FIELD, TRUST_TYPE_FIELD, TRUST_DIRECTION_FIELD, TRUST_STATE_FIELD,
            CREATED_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, STATE_LAST_UPDATED_DATE_TIME_FIELD, TRUST_STATE_REASON_FIELD,
            SELECTIVE_AUTH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String trustId;

    private final String remoteDomainName;

    private final String trustType;

    private final String trustDirection;

    private final String trustState;

    private final Instant createdDateTime;

    private final Instant lastUpdatedDateTime;

    private final Instant stateLastUpdatedDateTime;

    private final String trustStateReason;

    private final String selectiveAuth;

    private Trust(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.trustId = builder.trustId;
        this.remoteDomainName = builder.remoteDomainName;
        this.trustType = builder.trustType;
        this.trustDirection = builder.trustDirection;
        this.trustState = builder.trustState;
        this.createdDateTime = builder.createdDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.stateLastUpdatedDateTime = builder.stateLastUpdatedDateTime;
        this.trustStateReason = builder.trustStateReason;
        this.selectiveAuth = builder.selectiveAuth;
    }

    /**
     * <p>
     * The Directory ID of the AWS directory involved in the trust relationship.
     * </p>
     * 
     * @return The Directory ID of the AWS directory involved in the trust relationship.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The unique ID of the trust relationship.
     * </p>
     * 
     * @return The unique ID of the trust relationship.
     */
    public String trustId() {
        return trustId;
    }

    /**
     * <p>
     * The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust relationship.
     * </p>
     * 
     * @return The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust relationship.
     */
    public String remoteDomainName() {
        return remoteDomainName;
    }

    /**
     * <p>
     * The trust relationship type. <code>Forest</code> is the default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustType} will
     * return {@link TrustType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trustTypeAsString}.
     * </p>
     * 
     * @return The trust relationship type. <code>Forest</code> is the default.
     * @see TrustType
     */
    public TrustType trustType() {
        return TrustType.fromValue(trustType);
    }

    /**
     * <p>
     * The trust relationship type. <code>Forest</code> is the default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustType} will
     * return {@link TrustType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trustTypeAsString}.
     * </p>
     * 
     * @return The trust relationship type. <code>Forest</code> is the default.
     * @see TrustType
     */
    public String trustTypeAsString() {
        return trustType;
    }

    /**
     * <p>
     * The trust relationship direction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustDirection}
     * will return {@link TrustDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustDirectionAsString}.
     * </p>
     * 
     * @return The trust relationship direction.
     * @see TrustDirection
     */
    public TrustDirection trustDirection() {
        return TrustDirection.fromValue(trustDirection);
    }

    /**
     * <p>
     * The trust relationship direction.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustDirection}
     * will return {@link TrustDirection#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #trustDirectionAsString}.
     * </p>
     * 
     * @return The trust relationship direction.
     * @see TrustDirection
     */
    public String trustDirectionAsString() {
        return trustDirection;
    }

    /**
     * <p>
     * The trust relationship state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustState} will
     * return {@link TrustState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trustStateAsString}.
     * </p>
     * 
     * @return The trust relationship state.
     * @see TrustState
     */
    public TrustState trustState() {
        return TrustState.fromValue(trustState);
    }

    /**
     * <p>
     * The trust relationship state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #trustState} will
     * return {@link TrustState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #trustStateAsString}.
     * </p>
     * 
     * @return The trust relationship state.
     * @see TrustState
     */
    public String trustStateAsString() {
        return trustState;
    }

    /**
     * <p>
     * The date and time that the trust relationship was created.
     * </p>
     * 
     * @return The date and time that the trust relationship was created.
     */
    public Instant createdDateTime() {
        return createdDateTime;
    }

    /**
     * <p>
     * The date and time that the trust relationship was last updated.
     * </p>
     * 
     * @return The date and time that the trust relationship was last updated.
     */
    public Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The date and time that the TrustState was last updated.
     * </p>
     * 
     * @return The date and time that the TrustState was last updated.
     */
    public Instant stateLastUpdatedDateTime() {
        return stateLastUpdatedDateTime;
    }

    /**
     * <p>
     * The reason for the TrustState.
     * </p>
     * 
     * @return The reason for the TrustState.
     */
    public String trustStateReason() {
        return trustStateReason;
    }

    /**
     * <p>
     * Current state of selective authentication for the trust.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectiveAuth}
     * will return {@link SelectiveAuth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectiveAuthAsString}.
     * </p>
     * 
     * @return Current state of selective authentication for the trust.
     * @see SelectiveAuth
     */
    public SelectiveAuth selectiveAuth() {
        return SelectiveAuth.fromValue(selectiveAuth);
    }

    /**
     * <p>
     * Current state of selective authentication for the trust.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectiveAuth}
     * will return {@link SelectiveAuth#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #selectiveAuthAsString}.
     * </p>
     * 
     * @return Current state of selective authentication for the trust.
     * @see SelectiveAuth
     */
    public String selectiveAuthAsString() {
        return selectiveAuth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(trustId());
        hashCode = 31 * hashCode + Objects.hashCode(remoteDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(trustTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(stateLastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(trustStateReason());
        hashCode = 31 * hashCode + Objects.hashCode(selectiveAuthAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trust)) {
            return false;
        }
        Trust other = (Trust) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(trustId(), other.trustId())
                && Objects.equals(remoteDomainName(), other.remoteDomainName())
                && Objects.equals(trustTypeAsString(), other.trustTypeAsString())
                && Objects.equals(trustDirectionAsString(), other.trustDirectionAsString())
                && Objects.equals(trustStateAsString(), other.trustStateAsString())
                && Objects.equals(createdDateTime(), other.createdDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(stateLastUpdatedDateTime(), other.stateLastUpdatedDateTime())
                && Objects.equals(trustStateReason(), other.trustStateReason())
                && Objects.equals(selectiveAuthAsString(), other.selectiveAuthAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("Trust").add("DirectoryId", directoryId()).add("TrustId", trustId())
                .add("RemoteDomainName", remoteDomainName()).add("TrustType", trustTypeAsString())
                .add("TrustDirection", trustDirectionAsString()).add("TrustState", trustStateAsString())
                .add("CreatedDateTime", createdDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("StateLastUpdatedDateTime", stateLastUpdatedDateTime()).add("TrustStateReason", trustStateReason())
                .add("SelectiveAuth", selectiveAuthAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "TrustId":
            return Optional.ofNullable(clazz.cast(trustId()));
        case "RemoteDomainName":
            return Optional.ofNullable(clazz.cast(remoteDomainName()));
        case "TrustType":
            return Optional.ofNullable(clazz.cast(trustTypeAsString()));
        case "TrustDirection":
            return Optional.ofNullable(clazz.cast(trustDirectionAsString()));
        case "TrustState":
            return Optional.ofNullable(clazz.cast(trustStateAsString()));
        case "CreatedDateTime":
            return Optional.ofNullable(clazz.cast(createdDateTime()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "StateLastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(stateLastUpdatedDateTime()));
        case "TrustStateReason":
            return Optional.ofNullable(clazz.cast(trustStateReason()));
        case "SelectiveAuth":
            return Optional.ofNullable(clazz.cast(selectiveAuthAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Trust, T> g) {
        return obj -> g.apply((Trust) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trust> {
        /**
         * <p>
         * The Directory ID of the AWS directory involved in the trust relationship.
         * </p>
         * 
         * @param directoryId
         *        The Directory ID of the AWS directory involved in the trust relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The unique ID of the trust relationship.
         * </p>
         * 
         * @param trustId
         *        The unique ID of the trust relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustId(String trustId);

        /**
         * <p>
         * The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust relationship.
         * </p>
         * 
         * @param remoteDomainName
         *        The Fully Qualified Domain Name (FQDN) of the external domain involved in the trust relationship.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteDomainName(String remoteDomainName);

        /**
         * <p>
         * The trust relationship type. <code>Forest</code> is the default.
         * </p>
         * 
         * @param trustType
         *        The trust relationship type. <code>Forest</code> is the default.
         * @see TrustType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustType
         */
        Builder trustType(String trustType);

        /**
         * <p>
         * The trust relationship type. <code>Forest</code> is the default.
         * </p>
         * 
         * @param trustType
         *        The trust relationship type. <code>Forest</code> is the default.
         * @see TrustType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustType
         */
        Builder trustType(TrustType trustType);

        /**
         * <p>
         * The trust relationship direction.
         * </p>
         * 
         * @param trustDirection
         *        The trust relationship direction.
         * @see TrustDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustDirection
         */
        Builder trustDirection(String trustDirection);

        /**
         * <p>
         * The trust relationship direction.
         * </p>
         * 
         * @param trustDirection
         *        The trust relationship direction.
         * @see TrustDirection
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustDirection
         */
        Builder trustDirection(TrustDirection trustDirection);

        /**
         * <p>
         * The trust relationship state.
         * </p>
         * 
         * @param trustState
         *        The trust relationship state.
         * @see TrustState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustState
         */
        Builder trustState(String trustState);

        /**
         * <p>
         * The trust relationship state.
         * </p>
         * 
         * @param trustState
         *        The trust relationship state.
         * @see TrustState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrustState
         */
        Builder trustState(TrustState trustState);

        /**
         * <p>
         * The date and time that the trust relationship was created.
         * </p>
         * 
         * @param createdDateTime
         *        The date and time that the trust relationship was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDateTime(Instant createdDateTime);

        /**
         * <p>
         * The date and time that the trust relationship was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the trust relationship was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The date and time that the TrustState was last updated.
         * </p>
         * 
         * @param stateLastUpdatedDateTime
         *        The date and time that the TrustState was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateLastUpdatedDateTime(Instant stateLastUpdatedDateTime);

        /**
         * <p>
         * The reason for the TrustState.
         * </p>
         * 
         * @param trustStateReason
         *        The reason for the TrustState.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStateReason(String trustStateReason);

        /**
         * <p>
         * Current state of selective authentication for the trust.
         * </p>
         * 
         * @param selectiveAuth
         *        Current state of selective authentication for the trust.
         * @see SelectiveAuth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectiveAuth
         */
        Builder selectiveAuth(String selectiveAuth);

        /**
         * <p>
         * Current state of selective authentication for the trust.
         * </p>
         * 
         * @param selectiveAuth
         *        Current state of selective authentication for the trust.
         * @see SelectiveAuth
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectiveAuth
         */
        Builder selectiveAuth(SelectiveAuth selectiveAuth);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String trustId;

        private String remoteDomainName;

        private String trustType;

        private String trustDirection;

        private String trustState;

        private Instant createdDateTime;

        private Instant lastUpdatedDateTime;

        private Instant stateLastUpdatedDateTime;

        private String trustStateReason;

        private String selectiveAuth;

        private BuilderImpl() {
        }

        private BuilderImpl(Trust model) {
            directoryId(model.directoryId);
            trustId(model.trustId);
            remoteDomainName(model.remoteDomainName);
            trustType(model.trustType);
            trustDirection(model.trustDirection);
            trustState(model.trustState);
            createdDateTime(model.createdDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            stateLastUpdatedDateTime(model.stateLastUpdatedDateTime);
            trustStateReason(model.trustStateReason);
            selectiveAuth(model.selectiveAuth);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getTrustId() {
            return trustId;
        }

        @Override
        public final Builder trustId(String trustId) {
            this.trustId = trustId;
            return this;
        }

        public final void setTrustId(String trustId) {
            this.trustId = trustId;
        }

        public final String getRemoteDomainName() {
            return remoteDomainName;
        }

        @Override
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        public final String getTrustTypeAsString() {
            return trustType;
        }

        @Override
        public final Builder trustType(String trustType) {
            this.trustType = trustType;
            return this;
        }

        @Override
        public final Builder trustType(TrustType trustType) {
            this.trustType(trustType.toString());
            return this;
        }

        public final void setTrustType(String trustType) {
            this.trustType = trustType;
        }

        public final String getTrustDirectionAsString() {
            return trustDirection;
        }

        @Override
        public final Builder trustDirection(String trustDirection) {
            this.trustDirection = trustDirection;
            return this;
        }

        @Override
        public final Builder trustDirection(TrustDirection trustDirection) {
            this.trustDirection(trustDirection.toString());
            return this;
        }

        public final void setTrustDirection(String trustDirection) {
            this.trustDirection = trustDirection;
        }

        public final String getTrustStateAsString() {
            return trustState;
        }

        @Override
        public final Builder trustState(String trustState) {
            this.trustState = trustState;
            return this;
        }

        @Override
        public final Builder trustState(TrustState trustState) {
            this.trustState(trustState.toString());
            return this;
        }

        public final void setTrustState(String trustState) {
            this.trustState = trustState;
        }

        public final Instant getCreatedDateTime() {
            return createdDateTime;
        }

        @Override
        public final Builder createdDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
            return this;
        }

        public final void setCreatedDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        public final Instant getStateLastUpdatedDateTime() {
            return stateLastUpdatedDateTime;
        }

        @Override
        public final Builder stateLastUpdatedDateTime(Instant stateLastUpdatedDateTime) {
            this.stateLastUpdatedDateTime = stateLastUpdatedDateTime;
            return this;
        }

        public final void setStateLastUpdatedDateTime(Instant stateLastUpdatedDateTime) {
            this.stateLastUpdatedDateTime = stateLastUpdatedDateTime;
        }

        public final String getTrustStateReason() {
            return trustStateReason;
        }

        @Override
        public final Builder trustStateReason(String trustStateReason) {
            this.trustStateReason = trustStateReason;
            return this;
        }

        public final void setTrustStateReason(String trustStateReason) {
            this.trustStateReason = trustStateReason;
        }

        public final String getSelectiveAuthAsString() {
            return selectiveAuth;
        }

        @Override
        public final Builder selectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
            return this;
        }

        @Override
        public final Builder selectiveAuth(SelectiveAuth selectiveAuth) {
            this.selectiveAuth(selectiveAuth.toString());
            return this;
        }

        public final void setSelectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
        }

        @Override
        public Trust build() {
            return new Trust(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
