/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelSchemaExtensionRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, CancelSchemaExtensionRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelSchemaExtensionRequest.getter(CancelSchemaExtensionRequest::directoryId)).setter(CancelSchemaExtensionRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> SCHEMA_EXTENSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CancelSchemaExtensionRequest.getter(CancelSchemaExtensionRequest::schemaExtensionId)).setter(CancelSchemaExtensionRequest.setter(Builder::schemaExtensionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, SCHEMA_EXTENSION_ID_FIELD));
    private final String directoryId;
    private final String schemaExtensionId;

    private CancelSchemaExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.schemaExtensionId = builder.schemaExtensionId;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String schemaExtensionId() {
        return this.schemaExtensionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaExtensionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSchemaExtensionRequest)) {
            return false;
        }
        CancelSchemaExtensionRequest other = (CancelSchemaExtensionRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.schemaExtensionId(), other.schemaExtensionId());
    }

    public String toString() {
        return ToString.builder((String)"CancelSchemaExtensionRequest").add("DirectoryId", (Object)this.directoryId()).add("SchemaExtensionId", (Object)this.schemaExtensionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "SchemaExtensionId": {
                return Optional.ofNullable(clazz.cast(this.schemaExtensionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelSchemaExtensionRequest, T> g) {
        return obj -> g.apply((CancelSchemaExtensionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String schemaExtensionId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelSchemaExtensionRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.schemaExtensionId(model.schemaExtensionId);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getSchemaExtensionId() {
            return this.schemaExtensionId;
        }

        @Override
        public final Builder schemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
            return this;
        }

        public final void setSchemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelSchemaExtensionRequest build() {
            return new CancelSchemaExtensionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelSchemaExtensionRequest> {
        public Builder directoryId(String var1);

        public Builder schemaExtensionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

