/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.Attribute;
import software.amazon.awssdk.services.directory.model.AttributesCopier;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputerRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, CreateComputerRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComputerRequest.getter(CreateComputerRequest::directoryId)).setter(CreateComputerRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComputerRequest.getter(CreateComputerRequest::computerName)).setter(CreateComputerRequest.setter(Builder::computerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()}).build();
    private static final SdkField<String> PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComputerRequest.getter(CreateComputerRequest::password)).setter(CreateComputerRequest.setter(Builder::password)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()}).build();
    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateComputerRequest.getter(CreateComputerRequest::organizationalUnitDistinguishedName)).setter(CreateComputerRequest.setter(Builder::organizationalUnitDistinguishedName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnitDistinguishedName").build()}).build();
    private static final SdkField<List<Attribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateComputerRequest.getter(CreateComputerRequest::computerAttributes)).setter(CreateComputerRequest.setter(Builder::computerAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Attribute::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, COMPUTER_NAME_FIELD, PASSWORD_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD, COMPUTER_ATTRIBUTES_FIELD));
    private final String directoryId;
    private final String computerName;
    private final String password;
    private final String organizationalUnitDistinguishedName;
    private final List<Attribute> computerAttributes;

    private CreateComputerRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.computerName = builder.computerName;
        this.password = builder.password;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.computerAttributes = builder.computerAttributes;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String computerName() {
        return this.computerName;
    }

    public String password() {
        return this.password;
    }

    public String organizationalUnitDistinguishedName() {
        return this.organizationalUnitDistinguishedName;
    }

    public List<Attribute> computerAttributes() {
        return this.computerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.password());
        hashCode = 31 * hashCode + Objects.hashCode(this.organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computerAttributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputerRequest)) {
            return false;
        }
        CreateComputerRequest other = (CreateComputerRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.computerName(), other.computerName()) && Objects.equals(this.password(), other.password()) && Objects.equals(this.organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName()) && Objects.equals(this.computerAttributes(), other.computerAttributes());
    }

    public String toString() {
        return ToString.builder((String)"CreateComputerRequest").add("DirectoryId", (Object)this.directoryId()).add("ComputerName", (Object)this.computerName()).add("Password", (Object)this.password()).add("OrganizationalUnitDistinguishedName", (Object)this.organizationalUnitDistinguishedName()).add("ComputerAttributes", this.computerAttributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "ComputerName": {
                return Optional.ofNullable(clazz.cast(this.computerName()));
            }
            case "Password": {
                return Optional.ofNullable(clazz.cast(this.password()));
            }
            case "OrganizationalUnitDistinguishedName": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitDistinguishedName()));
            }
            case "ComputerAttributes": {
                return Optional.ofNullable(clazz.cast(this.computerAttributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComputerRequest, T> g) {
        return obj -> g.apply((CreateComputerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String computerName;
        private String password;
        private String organizationalUnitDistinguishedName;
        private List<Attribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputerRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.computerName(model.computerName);
            this.password(model.password);
            this.organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            this.computerAttributes(model.computerAttributes);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getComputerName() {
            return this.computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        public final String getPassword() {
            return this.password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return this.organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        public final Collection<Attribute.Builder> getComputerAttributes() {
            return this.computerAttributes != null ? (Collection)this.computerAttributes.stream().map(Attribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder computerAttributes(Collection<Attribute> computerAttributes) {
            this.computerAttributes = AttributesCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Attribute ... computerAttributes) {
            this.computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<Attribute.Builder> ... computerAttributes) {
            this.computerAttributes(Stream.of(computerAttributes).map(c -> (Attribute)((Attribute.Builder)Attribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComputerAttributes(Collection<Attribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = AttributesCopier.copyFromBuilder(computerAttributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputerRequest build() {
            return new CreateComputerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputerRequest> {
        public Builder directoryId(String var1);

        public Builder computerName(String var1);

        public Builder password(String var1);

        public Builder organizationalUnitDistinguishedName(String var1);

        public Builder computerAttributes(Collection<Attribute> var1);

        public Builder computerAttributes(Attribute ... var1);

        public Builder computerAttributes(Consumer<Attribute.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

