/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.RemoteDomainNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConditionalForwardersRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, DescribeConditionalForwardersRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeConditionalForwardersRequest.getter(DescribeConditionalForwardersRequest::directoryId)).setter(DescribeConditionalForwardersRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> REMOTE_DOMAIN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConditionalForwardersRequest.getter(DescribeConditionalForwardersRequest::remoteDomainNames)).setter(DescribeConditionalForwardersRequest.setter(Builder::remoteDomainNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, REMOTE_DOMAIN_NAMES_FIELD));
    private final String directoryId;
    private final List<String> remoteDomainNames;

    private DescribeConditionalForwardersRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.remoteDomainNames = builder.remoteDomainNames;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public List<String> remoteDomainNames() {
        return this.remoteDomainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConditionalForwardersRequest)) {
            return false;
        }
        DescribeConditionalForwardersRequest other = (DescribeConditionalForwardersRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.remoteDomainNames(), other.remoteDomainNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConditionalForwardersRequest").add("DirectoryId", (Object)this.directoryId()).add("RemoteDomainNames", this.remoteDomainNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "RemoteDomainNames": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainNames()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConditionalForwardersRequest, T> g) {
        return obj -> g.apply((DescribeConditionalForwardersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> remoteDomainNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConditionalForwardersRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.remoteDomainNames(model.remoteDomainNames);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Collection<String> getRemoteDomainNames() {
            return this.remoteDomainNames;
        }

        @Override
        public final Builder remoteDomainNames(Collection<String> remoteDomainNames) {
            this.remoteDomainNames = RemoteDomainNamesCopier.copy(remoteDomainNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder remoteDomainNames(String ... remoteDomainNames) {
            this.remoteDomainNames(Arrays.asList(remoteDomainNames));
            return this;
        }

        public final void setRemoteDomainNames(Collection<String> remoteDomainNames) {
            this.remoteDomainNames = RemoteDomainNamesCopier.copy(remoteDomainNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeConditionalForwardersRequest build() {
            return new DescribeConditionalForwardersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConditionalForwardersRequest> {
        public Builder directoryId(String var1);

        public Builder remoteDomainNames(Collection<String> var1);

        public Builder remoteDomainNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

