/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryDescription;
import software.amazon.awssdk.services.directory.model.DirectoryDescriptionsCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectoriesResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeDirectoriesResponse> {
    private static final SdkField<List<DirectoryDescription>> DIRECTORY_DESCRIPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDirectoriesResponse.getter(DescribeDirectoriesResponse::directoryDescriptions)).setter(DescribeDirectoriesResponse.setter(Builder::directoryDescriptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryDescriptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectoryDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDirectoriesResponse.getter(DescribeDirectoriesResponse::nextToken)).setter(DescribeDirectoriesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_DESCRIPTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DirectoryDescription> directoryDescriptions;
    private final String nextToken;

    private DescribeDirectoriesResponse(BuilderImpl builder) {
        super(builder);
        this.directoryDescriptions = builder.directoryDescriptions;
        this.nextToken = builder.nextToken;
    }

    public List<DirectoryDescription> directoryDescriptions() {
        return this.directoryDescriptions;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryDescriptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoriesResponse)) {
            return false;
        }
        DescribeDirectoriesResponse other = (DescribeDirectoriesResponse)((Object)obj);
        return Objects.equals(this.directoryDescriptions(), other.directoryDescriptions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDirectoriesResponse").add("DirectoryDescriptions", this.directoryDescriptions()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryDescriptions": {
                return Optional.ofNullable(clazz.cast(this.directoryDescriptions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoriesResponse, T> g) {
        return obj -> g.apply((DescribeDirectoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<DirectoryDescription> directoryDescriptions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoriesResponse model) {
            super(model);
            this.directoryDescriptions(model.directoryDescriptions);
            this.nextToken(model.nextToken);
        }

        public final Collection<DirectoryDescription.Builder> getDirectoryDescriptions() {
            return this.directoryDescriptions != null ? (Collection)this.directoryDescriptions.stream().map(DirectoryDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder directoryDescriptions(Collection<DirectoryDescription> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copy(directoryDescriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(DirectoryDescription ... directoryDescriptions) {
            this.directoryDescriptions(Arrays.asList(directoryDescriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directoryDescriptions(Consumer<DirectoryDescription.Builder> ... directoryDescriptions) {
            this.directoryDescriptions(Stream.of(directoryDescriptions).map(c -> (DirectoryDescription)((DirectoryDescription.Builder)DirectoryDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDirectoryDescriptions(Collection<DirectoryDescription.BuilderImpl> directoryDescriptions) {
            this.directoryDescriptions = DirectoryDescriptionsCopier.copyFromBuilder(directoryDescriptions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDirectoriesResponse build() {
            return new DescribeDirectoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectoriesResponse> {
        public Builder directoryDescriptions(Collection<DirectoryDescription> var1);

        public Builder directoryDescriptions(DirectoryDescription ... var1);

        public Builder directoryDescriptions(Consumer<DirectoryDescription.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

