/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.DomainController;
import software.amazon.awssdk.services.directory.model.DomainControllersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainControllersResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeDomainControllersResponse> {
    private static final SdkField<List<DomainController>> DOMAIN_CONTROLLERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDomainControllersResponse.getter(DescribeDomainControllersResponse::domainControllers)).setter(DescribeDomainControllersResponse.setter(Builder::domainControllers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainController::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDomainControllersResponse.getter(DescribeDomainControllersResponse::nextToken)).setter(DescribeDomainControllersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONTROLLERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DomainController> domainControllers;
    private final String nextToken;

    private DescribeDomainControllersResponse(BuilderImpl builder) {
        super(builder);
        this.domainControllers = builder.domainControllers;
        this.nextToken = builder.nextToken;
    }

    public List<DomainController> domainControllers() {
        return this.domainControllers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainControllers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainControllersResponse)) {
            return false;
        }
        DescribeDomainControllersResponse other = (DescribeDomainControllersResponse)((Object)obj);
        return Objects.equals(this.domainControllers(), other.domainControllers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDomainControllersResponse").add("DomainControllers", this.domainControllers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainControllers": {
                return Optional.ofNullable(clazz.cast(this.domainControllers()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainControllersResponse, T> g) {
        return obj -> g.apply((DescribeDomainControllersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<DomainController> domainControllers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainControllersResponse model) {
            super(model);
            this.domainControllers(model.domainControllers);
            this.nextToken(model.nextToken);
        }

        public final Collection<DomainController.Builder> getDomainControllers() {
            return this.domainControllers != null ? (Collection)this.domainControllers.stream().map(DomainController::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainControllers(Collection<DomainController> domainControllers) {
            this.domainControllers = DomainControllersCopier.copy(domainControllers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(DomainController ... domainControllers) {
            this.domainControllers(Arrays.asList(domainControllers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(Consumer<DomainController.Builder> ... domainControllers) {
            this.domainControllers(Stream.of(domainControllers).map(c -> (DomainController)((DomainController.Builder)DomainController.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDomainControllers(Collection<DomainController.BuilderImpl> domainControllers) {
            this.domainControllers = DomainControllersCopier.copyFromBuilder(domainControllers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeDomainControllersResponse build() {
            return new DescribeDomainControllersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainControllersResponse> {
        public Builder domainControllers(Collection<DomainController> var1);

        public Builder domainControllers(DomainController ... var1);

        public Builder domainControllers(Consumer<DomainController.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

