/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterEventTopicRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, RegisterEventTopicRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterEventTopicRequest.getter(RegisterEventTopicRequest::directoryId)).setter(RegisterEventTopicRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RegisterEventTopicRequest.getter(RegisterEventTopicRequest::topicName)).setter(RegisterEventTopicRequest.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, TOPIC_NAME_FIELD));
    private final String directoryId;
    private final String topicName;

    private RegisterEventTopicRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.topicName = builder.topicName;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String topicName() {
        return this.topicName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterEventTopicRequest)) {
            return false;
        }
        RegisterEventTopicRequest other = (RegisterEventTopicRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.topicName(), other.topicName());
    }

    public String toString() {
        return ToString.builder((String)"RegisterEventTopicRequest").add("DirectoryId", (Object)this.directoryId()).add("TopicName", (Object)this.topicName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterEventTopicRequest, T> g) {
        return obj -> g.apply((RegisterEventTopicRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String topicName;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterEventTopicRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.topicName(model.topicName);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterEventTopicRequest build() {
            return new RegisterEventTopicRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterEventTopicRequest> {
        public Builder directoryId(String var1);

        public Builder topicName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

