/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResetUserPasswordRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, ResetUserPasswordRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResetUserPasswordRequest.getter(ResetUserPasswordRequest::directoryId)).setter(ResetUserPasswordRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResetUserPasswordRequest.getter(ResetUserPasswordRequest::userName)).setter(ResetUserPasswordRequest.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> NEW_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResetUserPasswordRequest.getter(ResetUserPasswordRequest::newPassword)).setter(ResetUserPasswordRequest.setter(Builder::newPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewPassword").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, USER_NAME_FIELD, NEW_PASSWORD_FIELD));
    private final String directoryId;
    private final String userName;
    private final String newPassword;

    private ResetUserPasswordRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.userName = builder.userName;
        this.newPassword = builder.newPassword;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String userName() {
        return this.userName;
    }

    public String newPassword() {
        return this.newPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPassword());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetUserPasswordRequest)) {
            return false;
        }
        ResetUserPasswordRequest other = (ResetUserPasswordRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.newPassword(), other.newPassword());
    }

    public String toString() {
        return ToString.builder((String)"ResetUserPasswordRequest").add("DirectoryId", (Object)this.directoryId()).add("UserName", (Object)this.userName()).add("NewPassword", (Object)this.newPassword()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "NewPassword": {
                return Optional.ofNullable(clazz.cast(this.newPassword()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResetUserPasswordRequest, T> g) {
        return obj -> g.apply((ResetUserPasswordRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String userName;
        private String newPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ResetUserPasswordRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.userName(model.userName);
            this.newPassword(model.newPassword);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getNewPassword() {
            return this.newPassword;
        }

        @Override
        public final Builder newPassword(String newPassword) {
            this.newPassword = newPassword;
            return this;
        }

        public final void setNewPassword(String newPassword) {
            this.newPassword = newPassword;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ResetUserPasswordRequest build() {
            return new ResetUserPasswordRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ResetUserPasswordRequest> {
        public Builder directoryId(String var1);

        public Builder userName(String var1);

        public Builder newPassword(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

