/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;

public class DescribeDomainControllersIterable
implements SdkIterable<DescribeDomainControllersResponse> {
    private final DirectoryClient client;
    private final DescribeDomainControllersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDomainControllersIterable(DirectoryClient client, DescribeDomainControllersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeDomainControllersResponseFetcher();
    }

    public Iterator<DescribeDomainControllersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private final DescribeDomainControllersIterable resume(DescribeDomainControllersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeDomainControllersIterable(this.client, (DescribeDomainControllersRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeDomainControllersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeDomainControllersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeDomainControllersResponseFetcher
    implements SyncPageFetcher<DescribeDomainControllersResponse> {
        private DescribeDomainControllersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDomainControllersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeDomainControllersResponse nextPage(DescribeDomainControllersResponse previousPage) {
            if (previousPage == null) {
                return DescribeDomainControllersIterable.this.client.describeDomainControllers(DescribeDomainControllersIterable.this.firstRequest);
            }
            return DescribeDomainControllersIterable.this.client.describeDomainControllers((DescribeDomainControllersRequest)((Object)DescribeDomainControllersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

