/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a client authentication method for a directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClientAuthenticationSettingInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<ClientAuthenticationSettingInfo.Builder, ClientAuthenticationSettingInfo> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ClientAuthenticationSettingInfo::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ClientAuthenticationSettingInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDateTime").getter(getter(ClientAuthenticationSettingInfo::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, STATUS_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String status;

    private final Instant lastUpdatedDateTime;

    private ClientAuthenticationSettingInfo(BuilderImpl builder) {
        this.type = builder.type;
        this.status = builder.status;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The type of client authentication for the specified directory. If no type is specified, a list of all client
     * authentication types that are supported for the directory is retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of client authentication for the specified directory. If no type is specified, a list of all
     *         client authentication types that are supported for the directory is retrieved.
     * @see ClientAuthenticationType
     */
    public final ClientAuthenticationType type() {
        return ClientAuthenticationType.fromValue(type);
    }

    /**
     * <p>
     * The type of client authentication for the specified directory. If no type is specified, a list of all client
     * authentication types that are supported for the directory is retrieved.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ClientAuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of client authentication for the specified directory. If no type is specified, a list of all
     *         client authentication types that are supported for the directory is retrieved.
     * @see ClientAuthenticationType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Whether the client authentication type is enabled or disabled for the specified directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClientAuthenticationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the client authentication type is enabled or disabled for the specified directory.
     * @see ClientAuthenticationStatus
     */
    public final ClientAuthenticationStatus status() {
        return ClientAuthenticationStatus.fromValue(status);
    }

    /**
     * <p>
     * Whether the client authentication type is enabled or disabled for the specified directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ClientAuthenticationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Whether the client authentication type is enabled or disabled for the specified directory.
     * @see ClientAuthenticationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the status of the client authentication type was last updated.
     * </p>
     * 
     * @return The date and time when the status of the client authentication type was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientAuthenticationSettingInfo)) {
            return false;
        }
        ClientAuthenticationSettingInfo other = (ClientAuthenticationSettingInfo) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClientAuthenticationSettingInfo").add("Type", typeAsString()).add("Status", statusAsString())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientAuthenticationSettingInfo, T> g) {
        return obj -> g.apply((ClientAuthenticationSettingInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClientAuthenticationSettingInfo> {
        /**
         * <p>
         * The type of client authentication for the specified directory. If no type is specified, a list of all client
         * authentication types that are supported for the directory is retrieved.
         * </p>
         * 
         * @param type
         *        The type of client authentication for the specified directory. If no type is specified, a list of all
         *        client authentication types that are supported for the directory is retrieved.
         * @see ClientAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientAuthenticationType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of client authentication for the specified directory. If no type is specified, a list of all client
         * authentication types that are supported for the directory is retrieved.
         * </p>
         * 
         * @param type
         *        The type of client authentication for the specified directory. If no type is specified, a list of all
         *        client authentication types that are supported for the directory is retrieved.
         * @see ClientAuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientAuthenticationType
         */
        Builder type(ClientAuthenticationType type);

        /**
         * <p>
         * Whether the client authentication type is enabled or disabled for the specified directory.
         * </p>
         * 
         * @param status
         *        Whether the client authentication type is enabled or disabled for the specified directory.
         * @see ClientAuthenticationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientAuthenticationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Whether the client authentication type is enabled or disabled for the specified directory.
         * </p>
         * 
         * @param status
         *        Whether the client authentication type is enabled or disabled for the specified directory.
         * @see ClientAuthenticationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClientAuthenticationStatus
         */
        Builder status(ClientAuthenticationStatus status);

        /**
         * <p>
         * The date and time when the status of the client authentication type was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time when the status of the client authentication type was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String status;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientAuthenticationSettingInfo model) {
            type(model.type);
            status(model.status);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ClientAuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ClientAuthenticationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public ClientAuthenticationSettingInfo build() {
            return new ClientAuthenticationSettingInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
