/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The replicated Region information for a directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<RegionDescription.Builder, RegionDescription> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(RegionDescription::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> REGION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionName").getter(getter(RegionDescription::regionName)).setter(setter(Builder::regionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionName").build()).build();

    private static final SdkField<String> REGION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegionType").getter(getter(RegionDescription::regionTypeAsString)).setter(setter(Builder::regionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionType").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RegionDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField
            .<DirectoryVpcSettings> builder(MarshallingType.SDK_POJO).memberName("VpcSettings")
            .getter(getter(RegionDescription::vpcSettings)).setter(setter(Builder::vpcSettings))
            .constructor(DirectoryVpcSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()).build();

    private static final SdkField<Integer> DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredNumberOfDomainControllers")
            .getter(getter(RegionDescription::desiredNumberOfDomainControllers))
            .setter(setter(Builder::desiredNumberOfDomainControllers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredNumberOfDomainControllers")
                    .build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime").getter(getter(RegionDescription::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()).build();

    private static final SdkField<Instant> STATUS_LAST_UPDATED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("StatusLastUpdatedDateTime")
            .getter(getter(RegionDescription::statusLastUpdatedDateTime)).setter(setter(Builder::statusLastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusLastUpdatedDateTime").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDateTime").getter(getter(RegionDescription::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            REGION_NAME_FIELD, REGION_TYPE_FIELD, STATUS_FIELD, VPC_SETTINGS_FIELD, DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD,
            LAUNCH_TIME_FIELD, STATUS_LAST_UPDATED_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String regionName;

    private final String regionType;

    private final String status;

    private final DirectoryVpcSettings vpcSettings;

    private final Integer desiredNumberOfDomainControllers;

    private final Instant launchTime;

    private final Instant statusLastUpdatedDateTime;

    private final Instant lastUpdatedDateTime;

    private RegionDescription(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.regionName = builder.regionName;
        this.regionType = builder.regionType;
        this.status = builder.status;
        this.vpcSettings = builder.vpcSettings;
        this.desiredNumberOfDomainControllers = builder.desiredNumberOfDomainControllers;
        this.launchTime = builder.launchTime;
        this.statusLastUpdatedDateTime = builder.statusLastUpdatedDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the Region. For example, <code>us-east-1</code>.
     * </p>
     * 
     * @return The name of the Region. For example, <code>us-east-1</code>.
     */
    public final String regionName() {
        return regionName;
    }

    /**
     * <p>
     * Specifies whether the Region is the primary Region or an additional Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionType} will
     * return {@link RegionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the Region is the primary Region or an additional Region.
     * @see RegionType
     */
    public final RegionType regionType() {
        return RegionType.fromValue(regionType);
    }

    /**
     * <p>
     * Specifies whether the Region is the primary Region or an additional Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #regionType} will
     * return {@link RegionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #regionTypeAsString}.
     * </p>
     * 
     * @return Specifies whether the Region is the primary Region or an additional Region.
     * @see RegionType
     */
    public final String regionTypeAsString() {
        return regionType;
    }

    /**
     * <p>
     * The status of the replication process for the specified Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DirectoryStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the replication process for the specified Region.
     * @see DirectoryStage
     */
    public final DirectoryStage status() {
        return DirectoryStage.fromValue(status);
    }

    /**
     * <p>
     * The status of the replication process for the specified Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DirectoryStage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the replication process for the specified Region.
     * @see DirectoryStage
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the VpcSettings property for this object.
     * 
     * @return The value of the VpcSettings property for this object.
     */
    public final DirectoryVpcSettings vpcSettings() {
        return vpcSettings;
    }

    /**
     * <p>
     * The desired number of domain controllers in the specified Region for the specified directory.
     * </p>
     * 
     * @return The desired number of domain controllers in the specified Region for the specified directory.
     */
    public final Integer desiredNumberOfDomainControllers() {
        return desiredNumberOfDomainControllers;
    }

    /**
     * <p>
     * Specifies when the Region replication began.
     * </p>
     * 
     * @return Specifies when the Region replication began.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The date and time that the Region status was last updated.
     * </p>
     * 
     * @return The date and time that the Region status was last updated.
     */
    public final Instant statusLastUpdatedDateTime() {
        return statusLastUpdatedDateTime;
    }

    /**
     * <p>
     * The date and time that the Region description was last updated.
     * </p>
     * 
     * @return The date and time that the Region description was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(regionName());
        hashCode = 31 * hashCode + Objects.hashCode(regionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(desiredNumberOfDomainControllers());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusLastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionDescription)) {
            return false;
        }
        RegionDescription other = (RegionDescription) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(regionName(), other.regionName())
                && Objects.equals(regionTypeAsString(), other.regionTypeAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(vpcSettings(), other.vpcSettings())
                && Objects.equals(desiredNumberOfDomainControllers(), other.desiredNumberOfDomainControllers())
                && Objects.equals(launchTime(), other.launchTime())
                && Objects.equals(statusLastUpdatedDateTime(), other.statusLastUpdatedDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionDescription").add("DirectoryId", directoryId()).add("RegionName", regionName())
                .add("RegionType", regionTypeAsString()).add("Status", statusAsString()).add("VpcSettings", vpcSettings())
                .add("DesiredNumberOfDomainControllers", desiredNumberOfDomainControllers()).add("LaunchTime", launchTime())
                .add("StatusLastUpdatedDateTime", statusLastUpdatedDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "RegionName":
            return Optional.ofNullable(clazz.cast(regionName()));
        case "RegionType":
            return Optional.ofNullable(clazz.cast(regionTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "VpcSettings":
            return Optional.ofNullable(clazz.cast(vpcSettings()));
        case "DesiredNumberOfDomainControllers":
            return Optional.ofNullable(clazz.cast(desiredNumberOfDomainControllers()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "StatusLastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(statusLastUpdatedDateTime()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("RegionName", REGION_NAME_FIELD);
        map.put("RegionType", REGION_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("VpcSettings", VPC_SETTINGS_FIELD);
        map.put("DesiredNumberOfDomainControllers", DESIRED_NUMBER_OF_DOMAIN_CONTROLLERS_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("StatusLastUpdatedDateTime", STATUS_LAST_UPDATED_DATE_TIME_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegionDescription, T> g) {
        return obj -> g.apply((RegionDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionDescription> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the Region. For example, <code>us-east-1</code>.
         * </p>
         * 
         * @param regionName
         *        The name of the Region. For example, <code>us-east-1</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * Specifies whether the Region is the primary Region or an additional Region.
         * </p>
         * 
         * @param regionType
         *        Specifies whether the Region is the primary Region or an additional Region.
         * @see RegionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionType
         */
        Builder regionType(String regionType);

        /**
         * <p>
         * Specifies whether the Region is the primary Region or an additional Region.
         * </p>
         * 
         * @param regionType
         *        Specifies whether the Region is the primary Region or an additional Region.
         * @see RegionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionType
         */
        Builder regionType(RegionType regionType);

        /**
         * <p>
         * The status of the replication process for the specified Region.
         * </p>
         * 
         * @param status
         *        The status of the replication process for the specified Region.
         * @see DirectoryStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryStage
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the replication process for the specified Region.
         * </p>
         * 
         * @param status
         *        The status of the replication process for the specified Region.
         * @see DirectoryStage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryStage
         */
        Builder status(DirectoryStage status);

        /**
         * Sets the value of the VpcSettings property for this object.
         *
         * @param vpcSettings
         *        The new value for the VpcSettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSettings(DirectoryVpcSettings vpcSettings);

        /**
         * Sets the value of the VpcSettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DirectoryVpcSettings.Builder} avoiding
         * the need to create one manually via {@link DirectoryVpcSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectoryVpcSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcSettings(DirectoryVpcSettings)}.
         * 
         * @param vpcSettings
         *        a consumer that will call methods on {@link DirectoryVpcSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSettings(DirectoryVpcSettings)
         */
        default Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return vpcSettings(DirectoryVpcSettings.builder().applyMutation(vpcSettings).build());
        }

        /**
         * <p>
         * The desired number of domain controllers in the specified Region for the specified directory.
         * </p>
         * 
         * @param desiredNumberOfDomainControllers
         *        The desired number of domain controllers in the specified Region for the specified directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers);

        /**
         * <p>
         * Specifies when the Region replication began.
         * </p>
         * 
         * @param launchTime
         *        Specifies when the Region replication began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The date and time that the Region status was last updated.
         * </p>
         * 
         * @param statusLastUpdatedDateTime
         *        The date and time that the Region status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusLastUpdatedDateTime(Instant statusLastUpdatedDateTime);

        /**
         * <p>
         * The date and time that the Region description was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the Region description was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String regionName;

        private String regionType;

        private String status;

        private DirectoryVpcSettings vpcSettings;

        private Integer desiredNumberOfDomainControllers;

        private Instant launchTime;

        private Instant statusLastUpdatedDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(RegionDescription model) {
            directoryId(model.directoryId);
            regionName(model.regionName);
            regionType(model.regionType);
            status(model.status);
            vpcSettings(model.vpcSettings);
            desiredNumberOfDomainControllers(model.desiredNumberOfDomainControllers);
            launchTime(model.launchTime);
            statusLastUpdatedDateTime(model.statusLastUpdatedDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getRegionName() {
            return regionName;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final String getRegionType() {
            return regionType;
        }

        public final void setRegionType(String regionType) {
            this.regionType = regionType;
        }

        @Override
        public final Builder regionType(String regionType) {
            this.regionType = regionType;
            return this;
        }

        @Override
        public final Builder regionType(RegionType regionType) {
            this.regionType(regionType == null ? null : regionType.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DirectoryStage status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return vpcSettings != null ? vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final Integer getDesiredNumberOfDomainControllers() {
            return desiredNumberOfDomainControllers;
        }

        public final void setDesiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
        }

        @Override
        public final Builder desiredNumberOfDomainControllers(Integer desiredNumberOfDomainControllers) {
            this.desiredNumberOfDomainControllers = desiredNumberOfDomainControllers;
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final Instant getStatusLastUpdatedDateTime() {
            return statusLastUpdatedDateTime;
        }

        public final void setStatusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
        }

        @Override
        public final Builder statusLastUpdatedDateTime(Instant statusLastUpdatedDateTime) {
            this.statusLastUpdatedDateTime = statusLastUpdatedDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public RegionDescription build() {
            return new RegionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
