/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.LogSubscription;

public class ListLogSubscriptionsPublisher
implements SdkPublisher<ListLogSubscriptionsResponse> {
    private final DirectoryAsyncClient client;
    private final ListLogSubscriptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLogSubscriptionsPublisher(DirectoryAsyncClient client, ListLogSubscriptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLogSubscriptionsPublisher(DirectoryAsyncClient client, ListLogSubscriptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLogSubscriptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLogSubscriptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LogSubscription> logSubscriptions() {
        Function<ListLogSubscriptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.logSubscriptions() != null) {
                return response.logSubscriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLogSubscriptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLogSubscriptionsResponseFetcher
    implements AsyncPageFetcher<ListLogSubscriptionsResponse> {
        private ListLogSubscriptionsResponseFetcher() {
        }

        public boolean hasNextPage(ListLogSubscriptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLogSubscriptionsResponse> nextPage(ListLogSubscriptionsResponse previousPage) {
            if (previousPage == null) {
                return ListLogSubscriptionsPublisher.this.client.listLogSubscriptions(ListLogSubscriptionsPublisher.this.firstRequest);
            }
            return ListLogSubscriptionsPublisher.this.client.listLogSubscriptions((ListLogSubscriptionsRequest)((Object)ListLogSubscriptionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

