/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates an Managed Microsoft AD directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMicrosoftAdRequest extends DirectoryRequest implements
        ToCopyableBuilder<CreateMicrosoftAdRequest.Builder, CreateMicrosoftAdRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateMicrosoftAdRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SHORT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShortName").getter(getter(CreateMicrosoftAdRequest::shortName)).setter(setter(Builder::shortName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShortName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(CreateMicrosoftAdRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMicrosoftAdRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<DirectoryVpcSettings> VPC_SETTINGS_FIELD = SdkField
            .<DirectoryVpcSettings> builder(MarshallingType.SDK_POJO).memberName("VpcSettings")
            .getter(getter(CreateMicrosoftAdRequest::vpcSettings)).setter(setter(Builder::vpcSettings))
            .constructor(DirectoryVpcSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSettings").build()).build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(CreateMicrosoftAdRequest::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMicrosoftAdRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, SHORT_NAME_FIELD,
            PASSWORD_FIELD, DESCRIPTION_FIELD, VPC_SETTINGS_FIELD, EDITION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String shortName;

    private final String password;

    private final String description;

    private final DirectoryVpcSettings vpcSettings;

    private final String edition;

    private final List<Tag> tags;

    private CreateMicrosoftAdRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.shortName = builder.shortName;
        this.password = builder.password;
        this.description = builder.description;
        this.vpcSettings = builder.vpcSettings;
        this.edition = builder.edition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The fully qualified domain name for the Managed Microsoft AD directory, such as <code>corp.example.com</code>.
     * This name will resolve inside your VPC only. It does not need to be publicly resolvable.
     * </p>
     * 
     * @return The fully qualified domain name for the Managed Microsoft AD directory, such as
     *         <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need to be
     *         publicly resolvable.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it will default
     * to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS
     * <code>corp.example.com</code>.
     * </p>
     * 
     * @return The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it will
     *         default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS
     *         <code>corp.example.com</code>.
     */
    public final String shortName() {
        return shortName;
    }

    /**
     * <p>
     * The password for the default administrative user named <code>Admin</code>.
     * </p>
     * <p>
     * If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a> API
     * call.
     * </p>
     * 
     * @return The password for the default administrative user named <code>Admin</code>.</p>
     *         <p>
     *         If you need to change the password for the administrator account, you can use the
     *         <a>ResetUserPassword</a> API call.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * A description for the directory. This label will appear on the Amazon Web Services console
     * <code>Directory Details</code> page after the directory is created.
     * </p>
     * 
     * @return A description for the directory. This label will appear on the Amazon Web Services console
     *         <code>Directory Details</code> page after the directory is created.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.
     * </p>
     * 
     * @return Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.
     */
    public final DirectoryVpcSettings vpcSettings() {
        return vpcSettings;
    }

    /**
     * <p>
     * Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
     * <code>Enterprise</code> is the default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link DirectoryEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
     *         <code>Enterprise</code> is the default.
     * @see DirectoryEdition
     */
    public final DirectoryEdition edition() {
        return DirectoryEdition.fromValue(edition);
    }

    /**
     * <p>
     * Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
     * <code>Enterprise</code> is the default.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link DirectoryEdition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
     *         <code>Enterprise</code> is the default.
     * @see DirectoryEdition
     */
    public final String editionAsString() {
        return edition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to be assigned to the Managed Microsoft AD directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to be assigned to the Managed Microsoft AD directory.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSettings());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMicrosoftAdRequest)) {
            return false;
        }
        CreateMicrosoftAdRequest other = (CreateMicrosoftAdRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(shortName(), other.shortName())
                && Objects.equals(password(), other.password()) && Objects.equals(description(), other.description())
                && Objects.equals(vpcSettings(), other.vpcSettings())
                && Objects.equals(editionAsString(), other.editionAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMicrosoftAdRequest").add("Name", name()).add("ShortName", shortName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("Description", description())
                .add("VpcSettings", vpcSettings()).add("Edition", editionAsString()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ShortName":
            return Optional.ofNullable(clazz.cast(shortName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "VpcSettings":
            return Optional.ofNullable(clazz.cast(vpcSettings()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("ShortName", SHORT_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VpcSettings", VPC_SETTINGS_FIELD);
        map.put("Edition", EDITION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMicrosoftAdRequest, T> g) {
        return obj -> g.apply((CreateMicrosoftAdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMicrosoftAdRequest> {
        /**
         * <p>
         * The fully qualified domain name for the Managed Microsoft AD directory, such as <code>corp.example.com</code>
         * . This name will resolve inside your VPC only. It does not need to be publicly resolvable.
         * </p>
         * 
         * @param name
         *        The fully qualified domain name for the Managed Microsoft AD directory, such as
         *        <code>corp.example.com</code>. This name will resolve inside your VPC only. It does not need to be
         *        publicly resolvable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it will
         * default to the first part of your directory DNS. For example, <code>CORP</code> for the directory DNS
         * <code>corp.example.com</code>.
         * </p>
         * 
         * @param shortName
         *        The NetBIOS name for your domain, such as <code>CORP</code>. If you don't specify a NetBIOS name, it
         *        will default to the first part of your directory DNS. For example, <code>CORP</code> for the directory
         *        DNS <code>corp.example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortName(String shortName);

        /**
         * <p>
         * The password for the default administrative user named <code>Admin</code>.
         * </p>
         * <p>
         * If you need to change the password for the administrator account, you can use the <a>ResetUserPassword</a>
         * API call.
         * </p>
         * 
         * @param password
         *        The password for the default administrative user named <code>Admin</code>.</p>
         *        <p>
         *        If you need to change the password for the administrator account, you can use the
         *        <a>ResetUserPassword</a> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * A description for the directory. This label will appear on the Amazon Web Services console
         * <code>Directory Details</code> page after the directory is created.
         * </p>
         * 
         * @param description
         *        A description for the directory. This label will appear on the Amazon Web Services console
         *        <code>Directory Details</code> page after the directory is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.
         * </p>
         * 
         * @param vpcSettings
         *        Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSettings(DirectoryVpcSettings vpcSettings);

        /**
         * <p>
         * Contains VPC information for the <a>CreateDirectory</a> or <a>CreateMicrosoftAD</a> operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectoryVpcSettings.Builder} avoiding
         * the need to create one manually via {@link DirectoryVpcSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectoryVpcSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #vpcSettings(DirectoryVpcSettings)}.
         * 
         * @param vpcSettings
         *        a consumer that will call methods on {@link DirectoryVpcSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSettings(DirectoryVpcSettings)
         */
        default Builder vpcSettings(Consumer<DirectoryVpcSettings.Builder> vpcSettings) {
            return vpcSettings(DirectoryVpcSettings.builder().applyMutation(vpcSettings).build());
        }

        /**
         * <p>
         * Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
         * <code>Enterprise</code> is the default.
         * </p>
         * 
         * @param edition
         *        Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
         *        <code>Enterprise</code> is the default.
         * @see DirectoryEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryEdition
         */
        Builder edition(String edition);

        /**
         * <p>
         * Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
         * <code>Enterprise</code> is the default.
         * </p>
         * 
         * @param edition
         *        Managed Microsoft AD is available in two editions: <code>Standard</code> and <code>Enterprise</code>.
         *        <code>Enterprise</code> is the default.
         * @see DirectoryEdition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryEdition
         */
        Builder edition(DirectoryEdition edition);

        /**
         * <p>
         * The tags to be assigned to the Managed Microsoft AD directory.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the Managed Microsoft AD directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to be assigned to the Managed Microsoft AD directory.
         * </p>
         * 
         * @param tags
         *        The tags to be assigned to the Managed Microsoft AD directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to be assigned to the Managed Microsoft AD directory.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.directory.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String name;

        private String shortName;

        private String password;

        private String description;

        private DirectoryVpcSettings vpcSettings;

        private String edition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMicrosoftAdRequest model) {
            super(model);
            name(model.name);
            shortName(model.shortName);
            password(model.password);
            description(model.description);
            vpcSettings(model.vpcSettings);
            edition(model.edition);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortName() {
            return shortName;
        }

        public final void setShortName(String shortName) {
            this.shortName = shortName;
        }

        @Override
        public final Builder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final DirectoryVpcSettings.Builder getVpcSettings() {
            return vpcSettings != null ? vpcSettings.toBuilder() : null;
        }

        public final void setVpcSettings(DirectoryVpcSettings.BuilderImpl vpcSettings) {
            this.vpcSettings = vpcSettings != null ? vpcSettings.build() : null;
        }

        @Override
        public final Builder vpcSettings(DirectoryVpcSettings vpcSettings) {
            this.vpcSettings = vpcSettings;
            return this;
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(DirectoryEdition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMicrosoftAdRequest build() {
            return new CreateMicrosoftAdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
