/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainControllersResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeDomainControllersResponse.Builder, DescribeDomainControllersResponse> {
    private static final SdkField<List<DomainController>> DOMAIN_CONTROLLERS_FIELD = SdkField
            .<List<DomainController>> builder(MarshallingType.LIST)
            .memberName("DomainControllers")
            .getter(getter(DescribeDomainControllersResponse::domainControllers))
            .setter(setter(Builder::domainControllers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainControllers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainController> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainController::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeDomainControllersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_CONTROLLERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DomainController> domainControllers;

    private final String nextToken;

    private DescribeDomainControllersResponse(BuilderImpl builder) {
        super(builder);
        this.domainControllers = builder.domainControllers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainControllers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainControllers() {
        return domainControllers != null && !(domainControllers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the <a>DomainController</a> objects that were retrieved.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainControllers} method.
     * </p>
     * 
     * @return List of the <a>DomainController</a> objects that were retrieved.
     */
    public final List<DomainController> domainControllers() {
        return domainControllers;
    }

    /**
     * <p>
     * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a subsequent
     * call to <a>DescribeDomainControllers</a> retrieve the next set of items.
     * </p>
     * 
     * @return If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
     *         subsequent call to <a>DescribeDomainControllers</a> retrieve the next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainControllers() ? domainControllers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainControllersResponse)) {
            return false;
        }
        DescribeDomainControllersResponse other = (DescribeDomainControllersResponse) obj;
        return hasDomainControllers() == other.hasDomainControllers()
                && Objects.equals(domainControllers(), other.domainControllers())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainControllersResponse")
                .add("DomainControllers", hasDomainControllers() ? domainControllers() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainControllers":
            return Optional.ofNullable(clazz.cast(domainControllers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainControllers", DOMAIN_CONTROLLERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainControllersResponse, T> g) {
        return obj -> g.apply((DescribeDomainControllersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDomainControllersResponse> {
        /**
         * <p>
         * List of the <a>DomainController</a> objects that were retrieved.
         * </p>
         * 
         * @param domainControllers
         *        List of the <a>DomainController</a> objects that were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllers(Collection<DomainController> domainControllers);

        /**
         * <p>
         * List of the <a>DomainController</a> objects that were retrieved.
         * </p>
         * 
         * @param domainControllers
         *        List of the <a>DomainController</a> objects that were retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainControllers(DomainController... domainControllers);

        /**
         * <p>
         * List of the <a>DomainController</a> objects that were retrieved.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.DomainController.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.directory.model.DomainController#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.DomainController.Builder#build()} is called
         * immediately and its result is passed to {@link #domainControllers(List<DomainController>)}.
         * 
         * @param domainControllers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.DomainController.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainControllers(java.util.Collection<DomainController>)
         */
        Builder domainControllers(Consumer<DomainController.Builder>... domainControllers);

        /**
         * <p>
         * If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         * subsequent call to <a>DescribeDomainControllers</a> retrieve the next set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, more results are available. Pass this value for the <code>NextToken</code> parameter in a
         *        subsequent call to <a>DescribeDomainControllers</a> retrieve the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private List<DomainController> domainControllers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainControllersResponse model) {
            super(model);
            domainControllers(model.domainControllers);
            nextToken(model.nextToken);
        }

        public final List<DomainController.Builder> getDomainControllers() {
            List<DomainController.Builder> result = DomainControllersCopier.copyToBuilder(this.domainControllers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainControllers(Collection<DomainController.BuilderImpl> domainControllers) {
            this.domainControllers = DomainControllersCopier.copyFromBuilder(domainControllers);
        }

        @Override
        public final Builder domainControllers(Collection<DomainController> domainControllers) {
            this.domainControllers = DomainControllersCopier.copy(domainControllers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(DomainController... domainControllers) {
            domainControllers(Arrays.asList(domainControllers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainControllers(Consumer<DomainController.Builder>... domainControllers) {
            domainControllers(Stream.of(domainControllers).map(c -> DomainController.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDomainControllersResponse build() {
            return new DescribeDomainControllersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
