/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>DescribeSnapshots</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotsRequest extends DirectoryRequest implements
        ToCopyableBuilder<DescribeSnapshotsRequest.Builder, DescribeSnapshotsRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeSnapshotsRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> SNAPSHOT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SnapshotIds")
            .getter(getter(DescribeSnapshotsRequest::snapshotIds))
            .setter(setter(Builder::snapshotIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSnapshotsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Limit")
            .getter(getter(DescribeSnapshotsRequest::limit)).setter(setter(Builder::limit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Limit").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SNAPSHOT_IDS_FIELD, NEXT_TOKEN_FIELD, LIMIT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final List<String> snapshotIds;

    private final String nextToken;

    private final Integer limit;

    private DescribeSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.snapshotIds = builder.snapshotIds;
        this.nextToken = builder.nextToken;
        this.limit = builder.limit;
    }

    /**
     * <p>
     * The identifier of the directory for which to retrieve snapshot information.
     * </p>
     * 
     * @return The identifier of the directory for which to retrieve snapshot information.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SnapshotIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSnapshotIds() {
        return snapshotIds != null && !(snapshotIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all
     * snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSnapshotIds} method.
     * </p>
     * 
     * @return A list of identifiers of the snapshots to obtain the information for. If this member is null or empty,
     *         all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.
     */
    public final List<String> snapshotIds() {
        return snapshotIds;
    }

    /**
     * <p>
     * The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <a>DescribeSnapshots</a>. Pass null if
     * this is the first call.
     * </p>
     * 
     * @return The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <a>DescribeSnapshots</a>. Pass
     *         null if this is the first call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of objects to return.
     * </p>
     * 
     * @return The maximum number of objects to return.
     */
    public final Integer limit() {
        return limit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotIds() ? snapshotIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(limit());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotsRequest)) {
            return false;
        }
        DescribeSnapshotsRequest other = (DescribeSnapshotsRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasSnapshotIds() == other.hasSnapshotIds()
                && Objects.equals(snapshotIds(), other.snapshotIds()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(limit(), other.limit());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotsRequest").add("DirectoryId", directoryId())
                .add("SnapshotIds", hasSnapshotIds() ? snapshotIds() : null).add("NextToken", nextToken()).add("Limit", limit())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SnapshotIds":
            return Optional.ofNullable(clazz.cast(snapshotIds()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Limit":
            return Optional.ofNullable(clazz.cast(limit()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("SnapshotIds", SNAPSHOT_IDS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Limit", LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotsRequest, T> g) {
        return obj -> g.apply((DescribeSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSnapshotsRequest> {
        /**
         * <p>
         * The identifier of the directory for which to retrieve snapshot information.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for which to retrieve snapshot information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all
         * snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.
         * </p>
         * 
         * @param snapshotIds
         *        A list of identifiers of the snapshots to obtain the information for. If this member is null or empty,
         *        all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(Collection<String> snapshotIds);

        /**
         * <p>
         * A list of identifiers of the snapshots to obtain the information for. If this member is null or empty, all
         * snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.
         * </p>
         * 
         * @param snapshotIds
         *        A list of identifiers of the snapshots to obtain the information for. If this member is null or empty,
         *        all snapshots are returned using the <i>Limit</i> and <i>NextToken</i> members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIds(String... snapshotIds);

        /**
         * <p>
         * The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <a>DescribeSnapshots</a>. Pass
         * null if this is the first call.
         * </p>
         * 
         * @param nextToken
         *        The <i>DescribeSnapshotsResult.NextToken</i> value from a previous call to <a>DescribeSnapshots</a>.
         *        Pass null if this is the first call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of objects to return.
         * </p>
         * 
         * @param limit
         *        The maximum number of objects to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limit(Integer limit);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private List<String> snapshotIds = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer limit;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotsRequest model) {
            super(model);
            directoryId(model.directoryId);
            snapshotIds(model.snapshotIds);
            nextToken(model.nextToken);
            limit(model.limit);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getSnapshotIds() {
            if (snapshotIds instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotIds;
        }

        public final void setSnapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdsCopier.copy(snapshotIds);
        }

        @Override
        public final Builder snapshotIds(Collection<String> snapshotIds) {
            this.snapshotIds = SnapshotIdsCopier.copy(snapshotIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotIds(String... snapshotIds) {
            snapshotIds(Arrays.asList(snapshotIds));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getLimit() {
            return limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSnapshotsRequest build() {
            return new DescribeSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
