/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.CertificateState;
import software.amazon.awssdk.services.directory.model.CertificateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CertificateInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CertificateInfo> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CertificateId").getter(CertificateInfo.getter(CertificateInfo::certificateId)).setter(CertificateInfo.setter(Builder::certificateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()}).build();
    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CommonName").getter(CertificateInfo.getter(CertificateInfo::commonName)).setter(CertificateInfo.setter(Builder::commonName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(CertificateInfo.getter(CertificateInfo::stateAsString)).setter(CertificateInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> EXPIRY_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpiryDateTime").getter(CertificateInfo.getter(CertificateInfo::expiryDateTime)).setter(CertificateInfo.setter(Builder::expiryDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDateTime").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CertificateInfo.getter(CertificateInfo::typeAsString)).setter(CertificateInfo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD, COMMON_NAME_FIELD, STATE_FIELD, EXPIRY_DATE_TIME_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CertificateInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String certificateId;
    private final String commonName;
    private final String state;
    private final Instant expiryDateTime;
    private final String type;

    private CertificateInfo(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.commonName = builder.commonName;
        this.state = builder.state;
        this.expiryDateTime = builder.expiryDateTime;
        this.type = builder.type;
    }

    public final String certificateId() {
        return this.certificateId;
    }

    public final String commonName() {
        return this.commonName;
    }

    public final CertificateState state() {
        return CertificateState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant expiryDateTime() {
        return this.expiryDateTime;
    }

    public final CertificateType type() {
        return CertificateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commonName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiryDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CertificateInfo)) {
            return false;
        }
        CertificateInfo other = (CertificateInfo)obj;
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.commonName(), other.commonName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.expiryDateTime(), other.expiryDateTime()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CertificateInfo").add("CertificateId", (Object)this.certificateId()).add("CommonName", (Object)this.commonName()).add("State", (Object)this.stateAsString()).add("ExpiryDateTime", (Object)this.expiryDateTime()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateId": {
                return Optional.ofNullable(clazz.cast(this.certificateId()));
            }
            case "CommonName": {
                return Optional.ofNullable(clazz.cast(this.commonName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ExpiryDateTime": {
                return Optional.ofNullable(clazz.cast(this.expiryDateTime()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CertificateId", CERTIFICATE_ID_FIELD);
        map.put("CommonName", COMMON_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ExpiryDateTime", EXPIRY_DATE_TIME_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CertificateInfo, T> g) {
        return obj -> g.apply((CertificateInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateId;
        private String commonName;
        private String state;
        private Instant expiryDateTime;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CertificateInfo model) {
            this.certificateId(model.certificateId);
            this.commonName(model.commonName);
            this.state(model.state);
            this.expiryDateTime(model.expiryDateTime);
            this.type(model.type);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final String getCommonName() {
            return this.commonName;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CertificateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getExpiryDateTime() {
            return this.expiryDateTime;
        }

        public final void setExpiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
        }

        @Override
        public final Builder expiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CertificateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public CertificateInfo build() {
            return new CertificateInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CertificateInfo> {
        public Builder certificateId(String var1);

        public Builder commonName(String var1);

        public Builder state(String var1);

        public Builder state(CertificateState var1);

        public Builder expiryDateTime(Instant var1);

        public Builder type(String var1);

        public Builder type(CertificateType var1);
    }
}

