/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.OSVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OSUpdateSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OSUpdateSettings> {
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OSVersion").getter(OSUpdateSettings.getter(OSUpdateSettings::osVersionAsString)).setter(OSUpdateSettings.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OS_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OSUpdateSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String osVersion;

    private OSUpdateSettings(BuilderImpl builder) {
        this.osVersion = builder.osVersion;
    }

    public final OSVersion osVersion() {
        return OSVersion.fromValue(this.osVersion);
    }

    public final String osVersionAsString() {
        return this.osVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OSUpdateSettings)) {
            return false;
        }
        OSUpdateSettings other = (OSUpdateSettings)obj;
        return Objects.equals(this.osVersionAsString(), other.osVersionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OSUpdateSettings").add("OSVersion", (Object)this.osVersionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OSVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("OSVersion", OS_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OSUpdateSettings, T> g) {
        return obj -> g.apply((OSUpdateSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String osVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(OSUpdateSettings model) {
            this.osVersion(model.osVersion);
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        @Override
        public final Builder osVersion(OSVersion osVersion) {
            this.osVersion(osVersion == null ? null : osVersion.toString());
            return this;
        }

        public OSUpdateSettings build() {
            return new OSUpdateSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OSUpdateSettings> {
        public Builder osVersion(String var1);

        public Builder osVersion(OSVersion var1);
    }
}

