/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.IpRouteInfo;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;

public class ListIpRoutesPublisher
implements SdkPublisher<ListIpRoutesResponse> {
    private final DirectoryAsyncClient client;
    private final ListIpRoutesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListIpRoutesPublisher(DirectoryAsyncClient client, ListIpRoutesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListIpRoutesPublisher(DirectoryAsyncClient client, ListIpRoutesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListIpRoutesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListIpRoutesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<IpRouteInfo> ipRoutesInfo() {
        Function<ListIpRoutesResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipRoutesInfo() != null) {
                return response.ipRoutesInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListIpRoutesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListIpRoutesResponseFetcher
    implements AsyncPageFetcher<ListIpRoutesResponse> {
        private ListIpRoutesResponseFetcher() {
        }

        public boolean hasNextPage(ListIpRoutesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListIpRoutesResponse> nextPage(ListIpRoutesResponse previousPage) {
            if (previousPage == null) {
                return ListIpRoutesPublisher.this.client.listIpRoutes(ListIpRoutesPublisher.this.firstRequest);
            }
            return ListIpRoutesPublisher.this.client.listIpRoutes((ListIpRoutesRequest)((Object)ListIpRoutesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

