/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.directory.model.IpAddrsCopier;
import software.amazon.awssdk.services.directory.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DirectoryConnectSettingsDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DirectoryConnectSettingsDescription> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(DirectoryConnectSettingsDescription.getter(DirectoryConnectSettingsDescription::vpcId)).setter(DirectoryConnectSettingsDescription.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(DirectoryConnectSettingsDescription.getter(DirectoryConnectSettingsDescription::subnetIds)).setter(DirectoryConnectSettingsDescription.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CUSTOMER_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerUserName").getter(DirectoryConnectSettingsDescription.getter(DirectoryConnectSettingsDescription::customerUserName)).setter(DirectoryConnectSettingsDescription.setter(Builder::customerUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUserName").build()}).build();
    private static final SdkField<String> SECURITY_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityGroupId").getter(DirectoryConnectSettingsDescription.getter(DirectoryConnectSettingsDescription::securityGroupId)).setter(DirectoryConnectSettingsDescription.setter(Builder::securityGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupId").build()}).build();
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(DirectoryConnectSettingsDescription.getter(DirectoryConnectSettingsDescription::availabilityZones)).setter(DirectoryConnectSettingsDescription.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONNECT_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConnectIps").getter(DirectoryConnectSettingsDescription.getter(DirectoryConnectSettingsDescription::connectIps)).setter(DirectoryConnectSettingsDescription.setter(Builder::connectIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD, SUBNET_IDS_FIELD, CUSTOMER_USER_NAME_FIELD, SECURITY_GROUP_ID_FIELD, AVAILABILITY_ZONES_FIELD, CONNECT_IPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DirectoryConnectSettingsDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String vpcId;
    private final List<String> subnetIds;
    private final String customerUserName;
    private final String securityGroupId;
    private final List<String> availabilityZones;
    private final List<String> connectIps;

    private DirectoryConnectSettingsDescription(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.customerUserName = builder.customerUserName;
        this.securityGroupId = builder.securityGroupId;
        this.availabilityZones = builder.availabilityZones;
        this.connectIps = builder.connectIps;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final String customerUserName() {
        return this.customerUserName;
    }

    public final String securityGroupId() {
        return this.securityGroupId;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final boolean hasConnectIps() {
        return this.connectIps != null && !(this.connectIps instanceof SdkAutoConstructList);
    }

    public final List<String> connectIps() {
        return this.connectIps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.customerUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectIps() ? this.connectIps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConnectSettingsDescription)) {
            return false;
        }
        DirectoryConnectSettingsDescription other = (DirectoryConnectSettingsDescription)obj;
        return Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && Objects.equals(this.customerUserName(), other.customerUserName()) && Objects.equals(this.securityGroupId(), other.securityGroupId()) && this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && this.hasConnectIps() == other.hasConnectIps() && Objects.equals(this.connectIps(), other.connectIps());
    }

    public final String toString() {
        return ToString.builder((String)"DirectoryConnectSettingsDescription").add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("CustomerUserName", (Object)this.customerUserName()).add("SecurityGroupId", (Object)this.securityGroupId()).add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("ConnectIps", this.hasConnectIps() ? this.connectIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "CustomerUserName": {
                return Optional.ofNullable(clazz.cast(this.customerUserName()));
            }
            case "SecurityGroupId": {
                return Optional.ofNullable(clazz.cast(this.securityGroupId()));
            }
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "ConnectIps": {
                return Optional.ofNullable(clazz.cast(this.connectIps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("CustomerUserName", CUSTOMER_USER_NAME_FIELD);
        map.put("SecurityGroupId", SECURITY_GROUP_ID_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("ConnectIps", CONNECT_IPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectoryConnectSettingsDescription, T> g) {
        return obj -> g.apply((DirectoryConnectSettingsDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private String customerUserName;
        private String securityGroupId;
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private List<String> connectIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConnectSettingsDescription model) {
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.customerUserName(model.customerUserName);
            this.securityGroupId(model.securityGroupId);
            this.availabilityZones(model.availabilityZones);
            this.connectIps(model.connectIps);
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final String getCustomerUserName() {
            return this.customerUserName;
        }

        public final void setCustomerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
        }

        @Override
        public final Builder customerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
            return this;
        }

        public final String getSecurityGroupId() {
            return this.securityGroupId;
        }

        public final void setSecurityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
        }

        @Override
        public final Builder securityGroupId(String securityGroupId) {
            this.securityGroupId = securityGroupId;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getConnectIps() {
            if (this.connectIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.connectIps;
        }

        public final void setConnectIps(Collection<String> connectIps) {
            this.connectIps = IpAddrsCopier.copy(connectIps);
        }

        @Override
        public final Builder connectIps(Collection<String> connectIps) {
            this.connectIps = IpAddrsCopier.copy(connectIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectIps(String ... connectIps) {
            this.connectIps(Arrays.asList(connectIps));
            return this;
        }

        public DirectoryConnectSettingsDescription build() {
            return new DirectoryConnectSettingsDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DirectoryConnectSettingsDescription> {
        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder customerUserName(String var1);

        public Builder securityGroupId(String var1);

        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder connectIps(Collection<String> var1);

        public Builder connectIps(String ... var1);
    }
}

