/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.UpdateStatus;
import software.amazon.awssdk.services.directory.model.UpdateValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInfoEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UpdateInfoEntry> {
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(UpdateInfoEntry.getter(UpdateInfoEntry::region)).setter(UpdateInfoEntry.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(UpdateInfoEntry.getter(UpdateInfoEntry::statusAsString)).setter(UpdateInfoEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(UpdateInfoEntry.getter(UpdateInfoEntry::statusReason)).setter(UpdateInfoEntry.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiatedBy").getter(UpdateInfoEntry.getter(UpdateInfoEntry::initiatedBy)).setter(UpdateInfoEntry.setter(Builder::initiatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()}).build();
    private static final SdkField<UpdateValue> NEW_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewValue").getter(UpdateInfoEntry.getter(UpdateInfoEntry::newValue)).setter(UpdateInfoEntry.setter(Builder::newValue)).constructor(UpdateValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()}).build();
    private static final SdkField<UpdateValue> PREVIOUS_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreviousValue").getter(UpdateInfoEntry.getter(UpdateInfoEntry::previousValue)).setter(UpdateInfoEntry.setter(Builder::previousValue)).constructor(UpdateValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValue").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(UpdateInfoEntry.getter(UpdateInfoEntry::startTime)).setter(UpdateInfoEntry.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(UpdateInfoEntry.getter(UpdateInfoEntry::lastUpdatedDateTime)).setter(UpdateInfoEntry.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, INITIATED_BY_FIELD, NEW_VALUE_FIELD, PREVIOUS_VALUE_FIELD, START_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInfoEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String region;
    private final String status;
    private final String statusReason;
    private final String initiatedBy;
    private final UpdateValue newValue;
    private final UpdateValue previousValue;
    private final Instant startTime;
    private final Instant lastUpdatedDateTime;

    private UpdateInfoEntry(BuilderImpl builder) {
        this.region = builder.region;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.initiatedBy = builder.initiatedBy;
        this.newValue = builder.newValue;
        this.previousValue = builder.previousValue;
        this.startTime = builder.startTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String region() {
        return this.region;
    }

    public final UpdateStatus status() {
        return UpdateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String initiatedBy() {
        return this.initiatedBy;
    }

    public final UpdateValue newValue() {
        return this.newValue;
    }

    public final UpdateValue previousValue() {
        return this.previousValue;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.newValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInfoEntry)) {
            return false;
        }
        UpdateInfoEntry other = (UpdateInfoEntry)obj;
        return Objects.equals(this.region(), other.region()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.initiatedBy(), other.initiatedBy()) && Objects.equals(this.newValue(), other.newValue()) && Objects.equals(this.previousValue(), other.previousValue()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInfoEntry").add("Region", (Object)this.region()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("InitiatedBy", (Object)this.initiatedBy()).add("NewValue", (Object)this.newValue()).add("PreviousValue", (Object)this.previousValue()).add("StartTime", (Object)this.startTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "InitiatedBy": {
                return Optional.ofNullable(clazz.cast(this.initiatedBy()));
            }
            case "NewValue": {
                return Optional.ofNullable(clazz.cast(this.newValue()));
            }
            case "PreviousValue": {
                return Optional.ofNullable(clazz.cast(this.previousValue()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Region", REGION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("InitiatedBy", INITIATED_BY_FIELD);
        map.put("NewValue", NEW_VALUE_FIELD);
        map.put("PreviousValue", PREVIOUS_VALUE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInfoEntry, T> g) {
        return obj -> g.apply((UpdateInfoEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String region;
        private String status;
        private String statusReason;
        private String initiatedBy;
        private UpdateValue newValue;
        private UpdateValue previousValue;
        private Instant startTime;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInfoEntry model) {
            this.region(model.region);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.initiatedBy(model.initiatedBy);
            this.newValue(model.newValue);
            this.previousValue(model.previousValue);
            this.startTime(model.startTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getInitiatedBy() {
            return this.initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        public final UpdateValue.Builder getNewValue() {
            return this.newValue != null ? this.newValue.toBuilder() : null;
        }

        public final void setNewValue(UpdateValue.BuilderImpl newValue) {
            this.newValue = newValue != null ? newValue.build() : null;
        }

        @Override
        public final Builder newValue(UpdateValue newValue) {
            this.newValue = newValue;
            return this;
        }

        public final UpdateValue.Builder getPreviousValue() {
            return this.previousValue != null ? this.previousValue.toBuilder() : null;
        }

        public final void setPreviousValue(UpdateValue.BuilderImpl previousValue) {
            this.previousValue = previousValue != null ? previousValue.build() : null;
        }

        @Override
        public final Builder previousValue(UpdateValue previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public UpdateInfoEntry build() {
            return new UpdateInfoEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UpdateInfoEntry> {
        public Builder region(String var1);

        public Builder status(String var1);

        public Builder status(UpdateStatus var1);

        public Builder statusReason(String var1);

        public Builder initiatedBy(String var1);

        public Builder newValue(UpdateValue var1);

        default public Builder newValue(Consumer<UpdateValue.Builder> newValue) {
            return this.newValue((UpdateValue)((UpdateValue.Builder)UpdateValue.builder().applyMutation(newValue)).build());
        }

        public Builder previousValue(UpdateValue var1);

        default public Builder previousValue(Consumer<UpdateValue.Builder> previousValue) {
            return this.previousValue((UpdateValue)((UpdateValue.Builder)UpdateValue.builder().applyMutation(previousValue)).build());
        }

        public Builder startTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

