/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.directory.internal.DirectoryServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.directory.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.AcceptSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.AccessDeniedException;
import software.amazon.awssdk.services.directory.model.AdAssessmentLimitExceededException;
import software.amazon.awssdk.services.directory.model.AddIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.AddIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.AddRegionRequest;
import software.amazon.awssdk.services.directory.model.AddRegionResponse;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.directory.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.directory.model.AuthenticationFailedException;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.CancelSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.CertificateAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.CertificateDoesNotExistException;
import software.amazon.awssdk.services.directory.model.CertificateInUseException;
import software.amazon.awssdk.services.directory.model.CertificateLimitExceededException;
import software.amazon.awssdk.services.directory.model.ClientException;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ConnectDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateAliasRequest;
import software.amazon.awssdk.services.directory.model.CreateAliasResponse;
import software.amazon.awssdk.services.directory.model.CreateComputerRequest;
import software.amazon.awssdk.services.directory.model.CreateComputerResponse;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.CreateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.CreateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.CreateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.CreateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.CreateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.CreateLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdRequest;
import software.amazon.awssdk.services.directory.model.CreateMicrosoftAdResponse;
import software.amazon.awssdk.services.directory.model.CreateSnapshotRequest;
import software.amazon.awssdk.services.directory.model.CreateSnapshotResponse;
import software.amazon.awssdk.services.directory.model.CreateTrustRequest;
import software.amazon.awssdk.services.directory.model.CreateTrustResponse;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DeleteAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.DeleteConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DeleteDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionRequest;
import software.amazon.awssdk.services.directory.model.DeleteLogSubscriptionResponse;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotRequest;
import software.amazon.awssdk.services.directory.model.DeleteSnapshotResponse;
import software.amazon.awssdk.services.directory.model.DeleteTrustRequest;
import software.amazon.awssdk.services.directory.model.DeleteTrustResponse;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.DeregisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.DeregisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.DescribeAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DescribeCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DescribeCertificateRequest;
import software.amazon.awssdk.services.directory.model.DescribeCertificateResponse;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersRequest;
import software.amazon.awssdk.services.directory.model.DescribeConditionalForwardersResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.DescribeDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsRequest;
import software.amazon.awssdk.services.directory.model.DescribeEventTopicsResponse;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeRegionsRequest;
import software.amazon.awssdk.services.directory.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSettingsResponse;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeSharedDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.directory.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.directory.model.DescribeTrustsRequest;
import software.amazon.awssdk.services.directory.model.DescribeTrustsResponse;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryRequest;
import software.amazon.awssdk.services.directory.model.DescribeUpdateDirectoryResponse;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadyInRegionException;
import software.amazon.awssdk.services.directory.model.DirectoryAlreadySharedException;
import software.amazon.awssdk.services.directory.model.DirectoryDoesNotExistException;
import software.amazon.awssdk.services.directory.model.DirectoryException;
import software.amazon.awssdk.services.directory.model.DirectoryInDesiredStateException;
import software.amazon.awssdk.services.directory.model.DirectoryLimitExceededException;
import software.amazon.awssdk.services.directory.model.DirectoryNotSharedException;
import software.amazon.awssdk.services.directory.model.DirectoryUnavailableException;
import software.amazon.awssdk.services.directory.model.DisableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.DisableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.DisableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.DisableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.DisableLdapsRequest;
import software.amazon.awssdk.services.directory.model.DisableLdapsResponse;
import software.amazon.awssdk.services.directory.model.DisableRadiusRequest;
import software.amazon.awssdk.services.directory.model.DisableRadiusResponse;
import software.amazon.awssdk.services.directory.model.DisableSsoRequest;
import software.amazon.awssdk.services.directory.model.DisableSsoResponse;
import software.amazon.awssdk.services.directory.model.DomainControllerLimitExceededException;
import software.amazon.awssdk.services.directory.model.EnableAlreadyInProgressException;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyRequest;
import software.amazon.awssdk.services.directory.model.EnableCaEnrollmentPolicyResponse;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationRequest;
import software.amazon.awssdk.services.directory.model.EnableClientAuthenticationResponse;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessRequest;
import software.amazon.awssdk.services.directory.model.EnableDirectoryDataAccessResponse;
import software.amazon.awssdk.services.directory.model.EnableLdapsRequest;
import software.amazon.awssdk.services.directory.model.EnableLdapsResponse;
import software.amazon.awssdk.services.directory.model.EnableRadiusRequest;
import software.amazon.awssdk.services.directory.model.EnableRadiusResponse;
import software.amazon.awssdk.services.directory.model.EnableSsoRequest;
import software.amazon.awssdk.services.directory.model.EnableSsoResponse;
import software.amazon.awssdk.services.directory.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.directory.model.EntityDoesNotExistException;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetDirectoryLimitsResponse;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsRequest;
import software.amazon.awssdk.services.directory.model.GetSnapshotLimitsResponse;
import software.amazon.awssdk.services.directory.model.IncompatibleSettingsException;
import software.amazon.awssdk.services.directory.model.InsufficientPermissionsException;
import software.amazon.awssdk.services.directory.model.InvalidCertificateException;
import software.amazon.awssdk.services.directory.model.InvalidClientAuthStatusException;
import software.amazon.awssdk.services.directory.model.InvalidLdapsStatusException;
import software.amazon.awssdk.services.directory.model.InvalidNextTokenException;
import software.amazon.awssdk.services.directory.model.InvalidParameterException;
import software.amazon.awssdk.services.directory.model.InvalidPasswordException;
import software.amazon.awssdk.services.directory.model.InvalidTargetException;
import software.amazon.awssdk.services.directory.model.IpRouteLimitExceededException;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsRequest;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsResponse;
import software.amazon.awssdk.services.directory.model.ListCertificatesRequest;
import software.amazon.awssdk.services.directory.model.ListCertificatesResponse;
import software.amazon.awssdk.services.directory.model.ListIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.ListIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsRequest;
import software.amazon.awssdk.services.directory.model.ListLogSubscriptionsResponse;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsRequest;
import software.amazon.awssdk.services.directory.model.ListSchemaExtensionsResponse;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.directory.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.directory.model.NoAvailableCertificateException;
import software.amazon.awssdk.services.directory.model.OrganizationsException;
import software.amazon.awssdk.services.directory.model.RegionLimitExceededException;
import software.amazon.awssdk.services.directory.model.RegisterCertificateRequest;
import software.amazon.awssdk.services.directory.model.RegisterCertificateResponse;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicRequest;
import software.amazon.awssdk.services.directory.model.RegisterEventTopicResponse;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryRequest;
import software.amazon.awssdk.services.directory.model.RejectSharedDirectoryResponse;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesRequest;
import software.amazon.awssdk.services.directory.model.RemoveIpRoutesResponse;
import software.amazon.awssdk.services.directory.model.RemoveRegionRequest;
import software.amazon.awssdk.services.directory.model.RemoveRegionResponse;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.directory.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordRequest;
import software.amazon.awssdk.services.directory.model.ResetUserPasswordResponse;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotRequest;
import software.amazon.awssdk.services.directory.model.RestoreFromSnapshotResponse;
import software.amazon.awssdk.services.directory.model.ServiceException;
import software.amazon.awssdk.services.directory.model.ShareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.ShareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.ShareLimitExceededException;
import software.amazon.awssdk.services.directory.model.SnapshotLimitExceededException;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentRequest;
import software.amazon.awssdk.services.directory.model.StartAdAssessmentResponse;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionRequest;
import software.amazon.awssdk.services.directory.model.StartSchemaExtensionResponse;
import software.amazon.awssdk.services.directory.model.TagLimitExceededException;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryRequest;
import software.amazon.awssdk.services.directory.model.UnshareDirectoryResponse;
import software.amazon.awssdk.services.directory.model.UnsupportedOperationException;
import software.amazon.awssdk.services.directory.model.UnsupportedSettingsException;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderRequest;
import software.amazon.awssdk.services.directory.model.UpdateConditionalForwarderResponse;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupRequest;
import software.amazon.awssdk.services.directory.model.UpdateDirectorySetupResponse;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdRequest;
import software.amazon.awssdk.services.directory.model.UpdateHybridAdResponse;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersRequest;
import software.amazon.awssdk.services.directory.model.UpdateNumberOfDomainControllersResponse;
import software.amazon.awssdk.services.directory.model.UpdateRadiusRequest;
import software.amazon.awssdk.services.directory.model.UpdateRadiusResponse;
import software.amazon.awssdk.services.directory.model.UpdateSettingsRequest;
import software.amazon.awssdk.services.directory.model.UpdateSettingsResponse;
import software.amazon.awssdk.services.directory.model.UpdateTrustRequest;
import software.amazon.awssdk.services.directory.model.UpdateTrustResponse;
import software.amazon.awssdk.services.directory.model.UserDoesNotExistException;
import software.amazon.awssdk.services.directory.model.VerifyTrustRequest;
import software.amazon.awssdk.services.directory.model.VerifyTrustResponse;
import software.amazon.awssdk.services.directory.transform.AcceptSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CancelSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ConnectDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateAliasRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateComputerRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateMicrosoftAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.CreateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteLogSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeleteTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DeregisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeClientAuthenticationSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeConditionalForwardersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeEventTopicsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeHybridAdUpdateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeLdapsSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeRegionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSharedDirectoriesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeTrustsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DescribeUpdateDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.DisableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableCaEnrollmentPolicyRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableClientAuthenticationRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableDirectoryDataAccessRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableLdapsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.EnableSsoRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetDirectoryLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.GetSnapshotLimitsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListAdAssessmentsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListCertificatesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListLogSubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListSchemaExtensionsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterCertificateRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RegisterEventTopicRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RejectSharedDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveIpRoutesRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveRegionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ResetUserPasswordRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.RestoreFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.ShareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartAdAssessmentRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.StartSchemaExtensionRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UnshareDirectoryRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateConditionalForwarderRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateDirectorySetupRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateHybridAdRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateNumberOfDomainControllersRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateRadiusRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateSettingsRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.UpdateTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.transform.VerifyTrustRequestMarshaller;
import software.amazon.awssdk.services.directory.waiters.DirectoryWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link DirectoryClient}.
 *
 * @see DirectoryClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultDirectoryClient implements DirectoryClient {
    private static final Logger log = Logger.loggerFor(DefaultDirectoryClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultDirectoryClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Directory_Service" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accepts a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param acceptSharedDirectoryRequest
     * @return Result of the AcceptSharedDirectory operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws DirectoryAlreadySharedException
     *         The specified directory has already been shared with this Amazon Web Services account.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.AcceptSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AcceptSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AcceptSharedDirectoryResponse acceptSharedDirectory(AcceptSharedDirectoryRequest acceptSharedDirectoryRequest)
            throws InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadySharedException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptSharedDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptSharedDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptSharedDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptSharedDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptSharedDirectory");

            return clientHandler.execute(new ClientExecutionParams<AcceptSharedDirectoryRequest, AcceptSharedDirectoryResponse>()
                    .withOperationName("AcceptSharedDirectory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(acceptSharedDirectoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AcceptSharedDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * If the DNS server for your self-managed domain uses a publicly addressable IP address, you must add a CIDR
     * address block to correctly route traffic to and from your Microsoft AD on Amazon Web Services. <i>AddIpRoutes</i>
     * adds this address block. You can also use <i>AddIpRoutes</i> to facilitate routing traffic that uses public IP
     * ranges from your Microsoft AD on Amazon Web Services to a peer VPC.
     * </p>
     * <p>
     * Before you call <i>AddIpRoutes</i>, ensure that all of the required permissions have been explicitly granted
     * through a policy. For details about what permissions are required to run the <i>AddIpRoutes</i> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html">
     * Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param addIpRoutesRequest
     * @return Result of the AddIpRoutes operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws IpRouteLimitExceededException
     *         The maximum allowed number of IP addresses was exceeded. The default limit is 100 IP address blocks.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.AddIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddIpRoutesResponse addIpRoutes(AddIpRoutesRequest addIpRoutesRequest) throws EntityDoesNotExistException,
            EntityAlreadyExistsException, InvalidParameterException, DirectoryUnavailableException,
            IpRouteLimitExceededException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddIpRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddIpRoutes");

            return clientHandler.execute(new ClientExecutionParams<AddIpRoutesRequest, AddIpRoutesResponse>()
                    .withOperationName("AddIpRoutes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(addIpRoutesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddIpRoutesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds two domain controllers in the specified Region for the specified directory.
     * </p>
     *
     * @param addRegionRequest
     * @return Result of the AddRegion operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws DirectoryAlreadyInRegionException
     *         The Region you specified is the same Region where the Managed Microsoft AD directory was created. Specify
     *         a different Region and try again.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws RegionLimitExceededException
     *         You have reached the limit for maximum number of simultaneous Region replications per directory.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.AddRegion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddRegion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddRegionResponse addRegion(AddRegionRequest addRegionRequest) throws DirectoryUnavailableException,
            InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadyInRegionException,
            UnsupportedOperationException, DirectoryDoesNotExistException, RegionLimitExceededException, AccessDeniedException,
            ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddRegionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddRegionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addRegionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRegionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRegion");

            return clientHandler.execute(new ClientExecutionParams<AddRegionRequest, AddRegionResponse>()
                    .withOperationName("AddRegion").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(addRegionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddRegionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified directory. Each directory can have a maximum of 50 tags.
     * Each tag consists of a key and optional value. Tag keys must be unique to each resource.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws TagLimitExceededException
     *         The maximum allowed number of tags was exceeded.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws EntityDoesNotExistException, InvalidParameterException, TagLimitExceededException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsToResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(addTagsToResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an in-progress schema extension to a Microsoft AD directory. Once a schema extension has started
     * replicating to all domain controllers, the task can no longer be canceled. A schema extension can be canceled
     * during any of the following states; <code>Initializing</code>, <code>CreatingSnapshot</code>, and
     * <code>UpdatingSchema</code>.
     * </p>
     *
     * @param cancelSchemaExtensionRequest
     * @return Result of the CancelSchemaExtension operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CancelSchemaExtension
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CancelSchemaExtension" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelSchemaExtensionResponse cancelSchemaExtension(CancelSchemaExtensionRequest cancelSchemaExtensionRequest)
            throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelSchemaExtensionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelSchemaExtensionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelSchemaExtensionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelSchemaExtensionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelSchemaExtension");

            return clientHandler.execute(new ClientExecutionParams<CancelSchemaExtensionRequest, CancelSchemaExtensionResponse>()
                    .withOperationName("CancelSchemaExtension").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelSchemaExtensionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelSchemaExtensionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an AD Connector to connect to a self-managed directory.
     * </p>
     * <p>
     * Before you call <code>ConnectDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the
     * <code>ConnectDirectory</code> operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param connectDirectoryRequest
     *        Contains the inputs for the <a>ConnectDirectory</a> operation.
     * @return Result of the ConnectDirectory operation returned by the service.
     * @throws DirectoryLimitExceededException
     *         The maximum number of directories in the region has been reached. You can use the
     *         <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ConnectDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ConnectDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ConnectDirectoryResponse connectDirectory(ConnectDirectoryRequest connectDirectoryRequest)
            throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ConnectDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ConnectDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(connectDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, connectDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ConnectDirectory");

            return clientHandler.execute(new ClientExecutionParams<ConnectDirectoryRequest, ConnectDirectoryResponse>()
                    .withOperationName("ConnectDirectory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(connectDirectoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ConnectDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an alias for a directory and assigns the alias to the directory. The alias is used to construct the
     * access URL for the directory, such as <code>http://&lt;alias&gt;.awsapps.com</code>.
     * </p>
     * <important>
     * <p>
     * After an alias has been created, it cannot be deleted or reused, so this operation should only be used when
     * absolutely necessary.
     * </p>
     * </important>
     *
     * @param createAliasRequest
     *        Contains the inputs for the <a>CreateAlias</a> operation.
     * @return Result of the CreateAlias operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAliasResponse createAlias(CreateAliasRequest createAliasRequest) throws EntityAlreadyExistsException,
            EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAliasResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAliasRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateAliasRequest, CreateAliasResponse>()
                    .withOperationName("CreateAlias").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createAliasRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Active Directory computer object in the specified directory.
     * </p>
     *
     * @param createComputerRequest
     *        Contains the inputs for the <a>CreateComputer</a> operation.
     * @return Result of the CreateComputer operation returned by the service.
     * @throws AuthenticationFailedException
     *         An authentication error occurred.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateComputer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateComputer" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateComputerResponse createComputer(CreateComputerRequest createComputerRequest)
            throws AuthenticationFailedException, DirectoryUnavailableException, EntityAlreadyExistsException,
            EntityDoesNotExistException, InvalidParameterException, UnsupportedOperationException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateComputerResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateComputerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createComputerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createComputerRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateComputer");

            return clientHandler.execute(new ClientExecutionParams<CreateComputerRequest, CreateComputerResponse>()
                    .withOperationName("CreateComputer").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createComputerRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateComputerRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are
     * required in order to set up a trust relationship with another domain. The conditional forwarder points to the
     * trusted domain.
     * </p>
     *
     * @param createConditionalForwarderRequest
     *        Initiates the creation of a conditional forwarder for your Directory Service for Microsoft Active
     *        Directory. Conditional forwarders are required in order to set up a trust relationship with another
     *        domain.
     * @return Result of the CreateConditionalForwarder operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateConditionalForwarderResponse createConditionalForwarder(
            CreateConditionalForwarderRequest createConditionalForwarderRequest) throws EntityAlreadyExistsException,
            EntityDoesNotExistException, DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException,
            ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateConditionalForwarderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateConditionalForwarder");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateConditionalForwarderRequest, CreateConditionalForwarderResponse>()
                            .withOperationName("CreateConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createConditionalForwarderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateConditionalForwarderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Simple AD directory. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_simple_ad.html">Simple Active
     * Directory</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <code>CreateDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>CreateDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createDirectoryRequest
     *        Contains the inputs for the <a>CreateDirectory</a> operation.
     * @return Result of the CreateDirectory operation returned by the service.
     * @throws DirectoryLimitExceededException
     *         The maximum number of directories in the region has been reached. You can use the
     *         <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDirectoryResponse createDirectory(CreateDirectoryRequest createDirectoryRequest)
            throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDirectory");

            return clientHandler.execute(new ClientExecutionParams<CreateDirectoryRequest, CreateDirectoryResponse>()
                    .withOperationName("CreateDirectory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDirectoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a hybrid directory that connects your self-managed Active Directory (AD) infrastructure and Amazon Web
     * Services.
     * </p>
     * <p>
     * You must have a successful directory assessment using <a>StartADAssessment</a> to validate your environment
     * compatibility before you use this operation.
     * </p>
     * <p>
     * Updates are applied asynchronously. Use <a>DescribeDirectories</a> to monitor the progress of directory creation.
     * </p>
     *
     * @param createHybridAdRequest
     * @return Result of the CreateHybridAD operation returned by the service.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws DirectoryLimitExceededException
     *         The maximum number of directories in the region has been reached. You can use the
     *         <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.
     * @throws AdAssessmentLimitExceededException
     *         A directory assessment is automatically created when you create a hybrid directory. There are two types
     *         of assessments: <code>CUSTOMER</code> and <code>SYSTEM</code>. Your Amazon Web Services account has a
     *         limit of 100 <code>CUSTOMER</code> directory assessments.</p>
     *         <p>
     *         If you attempt to create a hybrid directory; and you already have 100 <code>CUSTOMER</code> directory
     *         assessments;, you will encounter an error. Delete assessments to free up capacity before trying again.
     *         </p>
     *         <p>
     *         You can request an increase to your <code>CUSTOMER</code> directory assessment quota by contacting
     *         customer support or delete existing CUSTOMER directory assessments; to free up capacity.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateHybridAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateHybridAD" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateHybridAdResponse createHybridAD(CreateHybridAdRequest createHybridAdRequest) throws ClientException,
            ServiceException, InvalidParameterException, UnsupportedOperationException, DirectoryLimitExceededException,
            AdAssessmentLimitExceededException, EntityDoesNotExistException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateHybridAdResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateHybridAdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createHybridAdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createHybridAdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateHybridAD");

            return clientHandler.execute(new ClientExecutionParams<CreateHybridAdRequest, CreateHybridAdResponse>()
                    .withOperationName("CreateHybridAD").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createHybridAdRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateHybridAdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a subscription to forward real-time Directory Service domain controller security logs to the specified
     * Amazon CloudWatch log group in your Amazon Web Services account.
     * </p>
     *
     * @param createLogSubscriptionRequest
     * @return Result of the CreateLogSubscription operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InsufficientPermissionsException
     *         The account does not have sufficient permission to perform the operation.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLogSubscriptionResponse createLogSubscription(CreateLogSubscriptionRequest createLogSubscriptionRequest)
            throws EntityAlreadyExistsException, EntityDoesNotExistException, UnsupportedOperationException,
            InsufficientPermissionsException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLogSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLogSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createLogSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLogSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLogSubscription");

            return clientHandler.execute(new ClientExecutionParams<CreateLogSubscriptionRequest, CreateLogSubscriptionResponse>()
                    .withOperationName("CreateLogSubscription").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createLogSubscriptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLogSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Microsoft AD directory in the Amazon Web Services Cloud. For more information, see <a
     * href="https://docs.aws.amazon.com/directoryservice/latest/admin-guide/directory_microsoft_ad.html">Managed
     * Microsoft AD</a> in the <i>Directory Service Admin Guide</i>.
     * </p>
     * <p>
     * Before you call <i>CreateMicrosoftAD</i>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <i>CreateMicrosoftAD</i>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param createMicrosoftAdRequest
     *        Creates an Managed Microsoft AD directory.
     * @return Result of the CreateMicrosoftAD operation returned by the service.
     * @throws DirectoryLimitExceededException
     *         The maximum number of directories in the region has been reached. You can use the
     *         <a>GetDirectoryLimits</a> operation to determine your directory limits in the region.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateMicrosoftAD
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateMicrosoftAD" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateMicrosoftAdResponse createMicrosoftAD(CreateMicrosoftAdRequest createMicrosoftAdRequest)
            throws DirectoryLimitExceededException, InvalidParameterException, ClientException, ServiceException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMicrosoftAdResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMicrosoftAdResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMicrosoftAdRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMicrosoftAdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMicrosoftAD");

            return clientHandler.execute(new ClientExecutionParams<CreateMicrosoftAdRequest, CreateMicrosoftAdResponse>()
                    .withOperationName("CreateMicrosoftAD").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMicrosoftAdRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMicrosoftAdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a snapshot of a Simple AD or Microsoft AD directory in the Amazon Web Services cloud.
     * </p>
     * <note>
     * <p>
     * You cannot take snapshots of AD Connector directories.
     * </p>
     * </note>
     *
     * @param createSnapshotRequest
     *        Contains the inputs for the <a>CreateSnapshot</a> operation.
     * @return Result of the CreateSnapshot operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws SnapshotLimitExceededException
     *         The maximum number of manual snapshots for the directory has been reached. You can use the
     *         <a>GetSnapshotLimits</a> operation to determine the snapshot limits for a directory.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSnapshotResponse createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws EntityDoesNotExistException,
            InvalidParameterException, SnapshotLimitExceededException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSnapshot");

            return clientHandler.execute(new ClientExecutionParams<CreateSnapshotRequest, CreateSnapshotResponse>()
                    .withOperationName("CreateSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example, you
     * can establish a trust between your Managed Microsoft AD directory, and your existing self-managed Microsoft
     * Active Directory. This would allow you to provide users and groups access to resources in either domain, with a
     * single set of credentials.
     * </p>
     * <p>
     * This action initiates the creation of the Amazon Web Services side of a trust relationship between an Managed
     * Microsoft AD directory and an external domain. You can create either a forest trust or an external trust.
     * </p>
     *
     * @param createTrustRequest
     *        Directory Service for Microsoft Active Directory allows you to configure trust relationships. For example,
     *        you can establish a trust between your Managed Microsoft AD directory, and your existing self-managed
     *        Microsoft Active Directory. This would allow you to provide users and groups access to resources in either
     *        domain, with a single set of credentials.</p>
     *        <p>
     *        This action initiates the creation of the Amazon Web Services side of a trust relationship between an
     *        Managed Microsoft AD directory and an external domain.
     * @return Result of the CreateTrust operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.CreateTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/CreateTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTrustResponse createTrust(CreateTrustRequest createTrustRequest) throws EntityAlreadyExistsException,
            EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTrustResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrust");

            return clientHandler.execute(new ClientExecutionParams<CreateTrustRequest, CreateTrustResponse>()
                    .withOperationName("CreateTrust").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTrustRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrustRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a directory assessment and all associated data. This operation permanently removes the assessment
     * results, validation reports, and configuration information.
     * </p>
     * <p>
     * You cannot delete system-initiated assessments. You can delete customer-created assessments even if they are in
     * progress.
     * </p>
     *
     * @param deleteAdAssessmentRequest
     * @return Result of the DeleteADAssessment operation returned by the service.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeleteADAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteADAssessment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAdAssessmentResponse deleteADAssessment(DeleteAdAssessmentRequest deleteAdAssessmentRequest)
            throws ClientException, ServiceException, InvalidParameterException, UnsupportedOperationException,
            EntityDoesNotExistException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAdAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAdAssessmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAdAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAdAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteADAssessment");

            return clientHandler.execute(new ClientExecutionParams<DeleteAdAssessmentRequest, DeleteAdAssessmentResponse>()
                    .withOperationName("DeleteADAssessment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteAdAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAdAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a conditional forwarder that has been set up for your Amazon Web Services directory.
     * </p>
     *
     * @param deleteConditionalForwarderRequest
     *        Deletes a conditional forwarder.
     * @return Result of the DeleteConditionalForwarder operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeleteConditionalForwarder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteConditionalForwarderResponse deleteConditionalForwarder(
            DeleteConditionalForwarderRequest deleteConditionalForwarderRequest) throws EntityDoesNotExistException,
            DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteConditionalForwarderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteConditionalForwarderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteConditionalForwarderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteConditionalForwarderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteConditionalForwarder");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteConditionalForwarderRequest, DeleteConditionalForwarderResponse>()
                            .withOperationName("DeleteConditionalForwarder").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteConditionalForwarderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteConditionalForwarderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an Directory Service directory.
     * </p>
     * <p>
     * Before you call <code>DeleteDirectory</code>, ensure that all of the required permissions have been explicitly
     * granted through a policy. For details about what permissions are required to run the <code>DeleteDirectory</code>
     * operation, see <a
     * href="http://docs.aws.amazon.com/directoryservice/latest/admin-guide/UsingWithDS_IAM_ResourcePermissions.html"
     * >Directory Service API Permissions: Actions, Resources, and Conditions Reference</a>.
     * </p>
     *
     * @param deleteDirectoryRequest
     *        Contains the inputs for the <a>DeleteDirectory</a> operation.
     * @return Result of the DeleteDirectory operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeleteDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDirectoryResponse deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest)
            throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDirectory");

            return clientHandler.execute(new ClientExecutionParams<DeleteDirectoryRequest, DeleteDirectoryResponse>()
                    .withOperationName("DeleteDirectory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDirectoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified log subscription.
     * </p>
     *
     * @param deleteLogSubscriptionRequest
     * @return Result of the DeleteLogSubscription operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeleteLogSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteLogSubscription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLogSubscriptionResponse deleteLogSubscription(DeleteLogSubscriptionRequest deleteLogSubscriptionRequest)
            throws EntityDoesNotExistException, UnsupportedOperationException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLogSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLogSubscriptionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteLogSubscriptionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLogSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLogSubscription");

            return clientHandler.execute(new ClientExecutionParams<DeleteLogSubscriptionRequest, DeleteLogSubscriptionResponse>()
                    .withOperationName("DeleteLogSubscription").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteLogSubscriptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLogSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a directory snapshot.
     * </p>
     *
     * @param deleteSnapshotRequest
     *        Contains the inputs for the <a>DeleteSnapshot</a> operation.
     * @return Result of the DeleteSnapshot operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeleteSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteSnapshot" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSnapshotResponse deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) throws EntityDoesNotExistException,
            InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSnapshotRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSnapshot");

            return clientHandler.execute(new ClientExecutionParams<DeleteSnapshotRequest, DeleteSnapshotResponse>()
                    .withOperationName("DeleteSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing trust relationship between your Managed Microsoft AD directory and an external domain.
     * </p>
     *
     * @param deleteTrustRequest
     *        Deletes the local side of an existing trust relationship between the Managed Microsoft AD directory and
     *        the external domain.
     * @return Result of the DeleteTrust operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeleteTrust
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteTrust" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTrustResponse deleteTrust(DeleteTrustRequest deleteTrustRequest) throws EntityDoesNotExistException,
            InvalidParameterException, ClientException, ServiceException, UnsupportedOperationException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrustResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTrustResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrustRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrust");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrustRequest, DeleteTrustResponse>()
                    .withOperationName("DeleteTrust").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTrustRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrustRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes from the system the certificate that was registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param deregisterCertificateRequest
     * @return Result of the DeregisterCertificate operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws CertificateDoesNotExistException
     *         The certificate is not present in the system for describe or deregister activities.
     * @throws CertificateInUseException
     *         The certificate is being used for the LDAP security connection and cannot be removed without disabling
     *         LDAP security.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeregisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeregisterCertificateResponse deregisterCertificate(DeregisterCertificateRequest deregisterCertificateRequest)
            throws DirectoryUnavailableException, DirectoryDoesNotExistException, CertificateDoesNotExistException,
            CertificateInUseException, UnsupportedOperationException, InvalidParameterException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterCertificate");

            return clientHandler.execute(new ClientExecutionParams<DeregisterCertificateRequest, DeregisterCertificateResponse>()
                    .withOperationName("DeregisterCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deregisterCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeregisterCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * </p>
     *
     * @param deregisterEventTopicRequest
     *        Removes the specified directory as a publisher to the specified Amazon SNS topic.
     * @return Result of the DeregisterEventTopic operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DeregisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeregisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeregisterEventTopicResponse deregisterEventTopic(DeregisterEventTopicRequest deregisterEventTopicRequest)
            throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterEventTopicResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterEventTopicResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deregisterEventTopicRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterEventTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterEventTopic");

            return clientHandler.execute(new ClientExecutionParams<DeregisterEventTopicRequest, DeregisterEventTopicResponse>()
                    .withOperationName("DeregisterEventTopic").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deregisterEventTopicRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeregisterEventTopicRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about a directory assessment, including its current status, validation results,
     * and configuration details. Use this operation to monitor assessment progress and review results.
     * </p>
     *
     * @param describeAdAssessmentRequest
     * @return Result of the DescribeADAssessment operation returned by the service.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeADAssessment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeADAssessment" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAdAssessmentResponse describeADAssessment(DescribeAdAssessmentRequest describeAdAssessmentRequest)
            throws ClientException, ServiceException, InvalidParameterException, UnsupportedOperationException,
            EntityDoesNotExistException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAdAssessmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAdAssessmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeAdAssessmentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAdAssessmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeADAssessment");

            return clientHandler.execute(new ClientExecutionParams<DescribeAdAssessmentRequest, DescribeAdAssessmentResponse>()
                    .withOperationName("DescribeADAssessment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeAdAssessmentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAdAssessmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about the certificate authority (CA) enrollment policy for the specified
     * directory. This policy determines how client certificates are automatically enrolled and managed through Amazon
     * Web Services Private Certificate Authority.
     * </p>
     *
     * @param describeCaEnrollmentPolicyRequest
     *        Contains the inputs for the <a>DescribeCAEnrollmentPolicy</a> operation.
     * @return Result of the DescribeCAEnrollmentPolicy operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeCAEnrollmentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCAEnrollmentPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeCaEnrollmentPolicyResponse describeCAEnrollmentPolicy(
            DescribeCaEnrollmentPolicyRequest describeCaEnrollmentPolicyRequest) throws DirectoryDoesNotExistException,
            UnsupportedOperationException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCaEnrollmentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCaEnrollmentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCaEnrollmentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCaEnrollmentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCAEnrollmentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeCaEnrollmentPolicyRequest, DescribeCaEnrollmentPolicyResponse>()
                            .withOperationName("DescribeCAEnrollmentPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeCaEnrollmentPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeCaEnrollmentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Displays information about the certificate registered for secure LDAP or client certificate authentication.
     * </p>
     *
     * @param describeCertificateRequest
     * @return Result of the DescribeCertificate operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws CertificateDoesNotExistException
     *         The certificate is not present in the system for describe or deregister activities.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeCertificateResponse describeCertificate(DescribeCertificateRequest describeCertificateRequest)
            throws DirectoryDoesNotExistException, UnsupportedOperationException, CertificateDoesNotExistException,
            InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeCertificate");

            return clientHandler.execute(new ClientExecutionParams<DescribeCertificateRequest, DescribeCertificateResponse>()
                    .withOperationName("DescribeCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the type of client authentication for the specified directory, if the type is
     * specified. If no type is specified, information about all client authentication types that are supported for the
     * specified directory is retrieved. Currently, only <code>SmartCard</code> is supported.
     * </p>
     *
     * @param describeClientAuthenticationSettingsRequest
     * @return Result of the DescribeClientAuthenticationSettings operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeClientAuthenticationSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeClientAuthenticationSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeClientAuthenticationSettingsResponse describeClientAuthenticationSettings(
            DescribeClientAuthenticationSettingsRequest describeClientAuthenticationSettingsRequest)
            throws DirectoryDoesNotExistException, UnsupportedOperationException, AccessDeniedException,
            InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeClientAuthenticationSettingsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeClientAuthenticationSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeClientAuthenticationSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeClientAuthenticationSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeClientAuthenticationSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeClientAuthenticationSettingsRequest, DescribeClientAuthenticationSettingsResponse>()
                            .withOperationName("DescribeClientAuthenticationSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeClientAuthenticationSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeClientAuthenticationSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains information about the conditional forwarders for this account.
     * </p>
     * <p>
     * If no input parameters are provided for RemoteDomainNames, this request describes all conditional forwarders for
     * the specified directory ID.
     * </p>
     *
     * @param describeConditionalForwardersRequest
     *        Describes a conditional forwarder.
     * @return Result of the DescribeConditionalForwarders operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeConditionalForwarders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeConditionalForwarders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeConditionalForwardersResponse describeConditionalForwarders(
            DescribeConditionalForwardersRequest describeConditionalForwardersRequest) throws EntityDoesNotExistException,
            DirectoryUnavailableException, InvalidParameterException, UnsupportedOperationException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeConditionalForwardersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeConditionalForwardersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeConditionalForwardersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeConditionalForwardersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeConditionalForwarders");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeConditionalForwardersRequest, DescribeConditionalForwardersResponse>()
                            .withOperationName("DescribeConditionalForwarders").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeConditionalForwardersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeConditionalForwardersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains information about the directories that belong to this account.
     * </p>
     * <p>
     * You can retrieve information about specific directories by passing the directory identifiers in the
     * <code>DirectoryIds</code> parameter. Otherwise, all directories that belong to the current account are returned.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <code>NextToken</code> request and response parameters. If
     * more results are available, the <code>DescribeDirectoriesResult.NextToken</code> member contains a token that you
     * pass in the next call to <a>DescribeDirectories</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <code>Limit</code> parameter.
     * </p>
     *
     * @param describeDirectoriesRequest
     *        Contains the inputs for the <a>DescribeDirectories</a> operation.
     * @return Result of the DescribeDirectories operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectories" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDirectoriesResponse describeDirectories(DescribeDirectoriesRequest describeDirectoriesRequest)
            throws EntityDoesNotExistException, InvalidParameterException, InvalidNextTokenException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDirectoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectories");

            return clientHandler.execute(new ClientExecutionParams<DescribeDirectoriesRequest, DescribeDirectoriesResponse>()
                    .withOperationName("DescribeDirectories").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeDirectoriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDirectoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains status of directory data access enablement through the Directory Service Data API for the specified
     * directory.
     * </p>
     *
     * @param describeDirectoryDataAccessRequest
     * @return Result of the DescribeDirectoryDataAccess operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeDirectoryDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDirectoryDataAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDirectoryDataAccessResponse describeDirectoryDataAccess(
            DescribeDirectoryDataAccessRequest describeDirectoryDataAccessRequest) throws DirectoryDoesNotExistException,
            UnsupportedOperationException, AccessDeniedException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDirectoryDataAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDirectoryDataAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDirectoryDataAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDirectoryDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDirectoryDataAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDirectoryDataAccessRequest, DescribeDirectoryDataAccessResponse>()
                            .withOperationName("DescribeDirectoryDataAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDirectoryDataAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDirectoryDataAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides information about any domain controllers in your directory.
     * </p>
     *
     * @param describeDomainControllersRequest
     * @return Result of the DescribeDomainControllers operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeDomainControllers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeDomainControllers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDomainControllersResponse describeDomainControllers(
            DescribeDomainControllersRequest describeDomainControllersRequest) throws EntityDoesNotExistException,
            InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDomainControllersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDomainControllersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeDomainControllersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDomainControllersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDomainControllers");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDomainControllersRequest, DescribeDomainControllersResponse>()
                            .withOperationName("DescribeDomainControllers").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeDomainControllersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDomainControllersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains information about which Amazon SNS topics receive status messages from the specified directory.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TopicName, this request describes all of the
     * associations in the account.
     * </p>
     *
     * @param describeEventTopicsRequest
     *        Describes event topics.
     * @return Result of the DescribeEventTopics operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeEventTopics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeEventTopics" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeEventTopicsResponse describeEventTopics(DescribeEventTopicsRequest describeEventTopicsRequest)
            throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEventTopicsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeEventTopicsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeEventTopicsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeEventTopicsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEventTopics");

            return clientHandler.execute(new ClientExecutionParams<DescribeEventTopicsRequest, DescribeEventTopicsResponse>()
                    .withOperationName("DescribeEventTopics").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeEventTopicsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeEventTopicsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about update activities for a hybrid directory. This operation provides details about
     * configuration changes, administrator account updates, and self-managed instance settings (IDs and DNS IPs).
     * </p>
     *
     * @param describeHybridAdUpdateRequest
     * @return Result of the DescribeHybridADUpdate operation returned by the service.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeHybridADUpdate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeHybridADUpdate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeHybridAdUpdateResponse describeHybridADUpdate(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest)
            throws ClientException, ServiceException, UnsupportedOperationException, DirectoryDoesNotExistException,
            InvalidParameterException, InvalidNextTokenException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeHybridAdUpdateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeHybridAdUpdateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeHybridAdUpdateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeHybridAdUpdateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeHybridADUpdate");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeHybridAdUpdateRequest, DescribeHybridAdUpdateResponse>()
                            .withOperationName("DescribeHybridADUpdate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeHybridAdUpdateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeHybridAdUpdateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the status of LDAP security for the specified directory.
     * </p>
     *
     * @param describeLdapsSettingsRequest
     * @return Result of the DescribeLDAPSSettings operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeLDAPSSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeLDAPSSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeLdapsSettingsResponse describeLDAPSSettings(DescribeLdapsSettingsRequest describeLdapsSettingsRequest)
            throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidNextTokenException,
            InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeLdapsSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeLdapsSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeLdapsSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeLdapsSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeLDAPSSettings");

            return clientHandler.execute(new ClientExecutionParams<DescribeLdapsSettingsRequest, DescribeLdapsSettingsResponse>()
                    .withOperationName("DescribeLDAPSSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeLdapsSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeLdapsSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides information about the Regions that are configured for multi-Region replication.
     * </p>
     *
     * @param describeRegionsRequest
     * @return Result of the DescribeRegions operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeRegions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeRegionsResponse describeRegions(DescribeRegionsRequest describeRegionsRequest)
            throws InvalidParameterException, DirectoryDoesNotExistException, UnsupportedOperationException,
            InvalidNextTokenException, AccessDeniedException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeRegionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeRegionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeRegionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeRegionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeRegions");

            return clientHandler.execute(new ClientExecutionParams<DescribeRegionsRequest, DescribeRegionsResponse>()
                    .withOperationName("DescribeRegions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeRegionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeRegionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the configurable settings for the specified directory.
     * </p>
     *
     * @param describeSettingsRequest
     * @return Result of the DescribeSettings operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSettings" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSettingsResponse describeSettings(DescribeSettingsRequest describeSettingsRequest)
            throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidParameterException,
            InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSettingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSettings");

            return clientHandler.execute(new ClientExecutionParams<DescribeSettingsRequest, DescribeSettingsResponse>()
                    .withOperationName("DescribeSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the shared directories in your account.
     * </p>
     *
     * @param describeSharedDirectoriesRequest
     * @return Result of the DescribeSharedDirectories operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeSharedDirectories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSharedDirectories" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeSharedDirectoriesResponse describeSharedDirectories(
            DescribeSharedDirectoriesRequest describeSharedDirectoriesRequest) throws EntityDoesNotExistException,
            InvalidNextTokenException, InvalidParameterException, UnsupportedOperationException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSharedDirectoriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeSharedDirectoriesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSharedDirectoriesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSharedDirectoriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSharedDirectories");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeSharedDirectoriesRequest, DescribeSharedDirectoriesResponse>()
                            .withOperationName("DescribeSharedDirectories").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeSharedDirectoriesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeSharedDirectoriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains information about the directory snapshots that belong to this account.
     * </p>
     * <p>
     * This operation supports pagination with the use of the <i>NextToken</i> request and response parameters. If more
     * results are available, the <i>DescribeSnapshots.NextToken</i> member contains a token that you pass in the next
     * call to <a>DescribeSnapshots</a> to retrieve the next set of items.
     * </p>
     * <p>
     * You can also specify a maximum number of return results with the <i>Limit</i> parameter.
     * </p>
     *
     * @param describeSnapshotsRequest
     *        Contains the inputs for the <a>DescribeSnapshots</a> operation.
     * @return Result of the DescribeSnapshots operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeSnapshots" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSnapshotsResponse describeSnapshots(DescribeSnapshotsRequest describeSnapshotsRequest)
            throws EntityDoesNotExistException, InvalidParameterException, InvalidNextTokenException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSnapshots");

            return clientHandler.execute(new ClientExecutionParams<DescribeSnapshotsRequest, DescribeSnapshotsResponse>()
                    .withOperationName("DescribeSnapshots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains information about the trust relationships for this account.
     * </p>
     * <p>
     * If no input parameters are provided, such as DirectoryId or TrustIds, this request describes all the trust
     * relationships belonging to the account.
     * </p>
     *
     * @param describeTrustsRequest
     *        Describes the trust relationships for a particular Managed Microsoft AD directory. If no input parameters
     *        are provided, such as directory ID or trust ID, this request describes all the trust relationships.
     * @return Result of the DescribeTrusts operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeTrusts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeTrusts" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeTrustsResponse describeTrusts(DescribeTrustsRequest describeTrustsRequest) throws EntityDoesNotExistException,
            InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException,
            UnsupportedOperationException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTrustsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTrustsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeTrustsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTrustsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrusts");

            return clientHandler.execute(new ClientExecutionParams<DescribeTrustsRequest, DescribeTrustsResponse>()
                    .withOperationName("DescribeTrusts").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeTrustsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTrustsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the updates of a directory for a particular update type.
     * </p>
     *
     * @param describeUpdateDirectoryRequest
     * @return Result of the DescribeUpdateDirectory operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DescribeUpdateDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DescribeUpdateDirectory" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeUpdateDirectoryResponse describeUpdateDirectory(DescribeUpdateDirectoryRequest describeUpdateDirectoryRequest)
            throws DirectoryDoesNotExistException, InvalidParameterException, AccessDeniedException, ClientException,
            ServiceException, InvalidNextTokenException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUpdateDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeUpdateDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeUpdateDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUpdateDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUpdateDirectory");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeUpdateDirectoryRequest, DescribeUpdateDirectoryResponse>()
                            .withOperationName("DescribeUpdateDirectory").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(describeUpdateDirectoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeUpdateDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables the certificate authority (CA) enrollment policy for the specified directory. This stops automatic
     * certificate enrollment and management for domain-joined clients, but does not affect existing certificates.
     * </p>
     * <important>
     * <p>
     * Disabling the CA enrollment policy prevents new certificates from being automatically enrolled, but existing
     * certificates remain valid and functional until they expire.
     * </p>
     * </important>
     *
     * @param disableCaEnrollmentPolicyRequest
     *        Contains the inputs for the <a>DisableCAEnrollmentPolicy</a> operation.
     * @return Result of the DisableCAEnrollmentPolicy operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DisableAlreadyInProgressException
     *         A disable operation for CA enrollment policy is already in progress for this directory.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DisableCAEnrollmentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableCAEnrollmentPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisableCaEnrollmentPolicyResponse disableCAEnrollmentPolicy(
            DisableCaEnrollmentPolicyRequest disableCaEnrollmentPolicyRequest) throws DirectoryDoesNotExistException,
            DirectoryUnavailableException, InvalidParameterException, DisableAlreadyInProgressException,
            EntityDoesNotExistException, AccessDeniedException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableCaEnrollmentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisableCaEnrollmentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableCaEnrollmentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableCaEnrollmentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableCAEnrollmentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DisableCaEnrollmentPolicyRequest, DisableCaEnrollmentPolicyResponse>()
                            .withOperationName("DisableCAEnrollmentPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disableCaEnrollmentPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisableCaEnrollmentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param disableClientAuthenticationRequest
     * @return Result of the DisableClientAuthentication operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidClientAuthStatusException
     *         Client authentication is already enabled.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DisableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableClientAuthentication"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisableClientAuthenticationResponse disableClientAuthentication(
            DisableClientAuthenticationRequest disableClientAuthenticationRequest) throws DirectoryDoesNotExistException,
            UnsupportedOperationException, InvalidClientAuthStatusException, AccessDeniedException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableClientAuthenticationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisableClientAuthenticationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableClientAuthenticationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableClientAuthenticationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableClientAuthentication");

            return clientHandler
                    .execute(new ClientExecutionParams<DisableClientAuthenticationRequest, DisableClientAuthenticationResponse>()
                            .withOperationName("DisableClientAuthentication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disableClientAuthenticationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisableClientAuthenticationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates access to directory data via the Directory Service Data API for the specified directory. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/Welcome.html"
     * >Directory Service Data API Reference</a>.
     * </p>
     *
     * @param disableDirectoryDataAccessRequest
     * @return Result of the DisableDirectoryDataAccess operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws DirectoryInDesiredStateException
     *         The directory is already updated to desired update type settings.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DisableDirectoryDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableDirectoryDataAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DisableDirectoryDataAccessResponse disableDirectoryDataAccess(
            DisableDirectoryDataAccessRequest disableDirectoryDataAccessRequest) throws DirectoryDoesNotExistException,
            DirectoryUnavailableException, UnsupportedOperationException, DirectoryInDesiredStateException,
            AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableDirectoryDataAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisableDirectoryDataAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableDirectoryDataAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableDirectoryDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableDirectoryDataAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<DisableDirectoryDataAccessRequest, DisableDirectoryDataAccessResponse>()
                            .withOperationName("DisableDirectoryDataAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disableDirectoryDataAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisableDirectoryDataAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates LDAP secure calls for the specified directory.
     * </p>
     *
     * @param disableLdapsRequest
     * @return Result of the DisableLDAPS operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws InvalidLdapsStatusException
     *         The LDAP activities could not be performed because they are limited by the LDAPS status.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DisableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisableLdapsResponse disableLDAPS(DisableLdapsRequest disableLdapsRequest) throws DirectoryUnavailableException,
            DirectoryDoesNotExistException, InvalidLdapsStatusException, UnsupportedOperationException,
            InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableLdapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableLdapsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableLdapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableLDAPS");

            return clientHandler.execute(new ClientExecutionParams<DisableLdapsRequest, DisableLdapsResponse>()
                    .withOperationName("DisableLDAPS").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disableLdapsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableLdapsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server
     * for an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param disableRadiusRequest
     *        Contains the inputs for the <a>DisableRadius</a> operation.
     * @return Result of the DisableRadius operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DisableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisableRadiusResponse disableRadius(DisableRadiusRequest disableRadiusRequest) throws EntityDoesNotExistException,
            ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableRadiusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableRadius");

            return clientHandler.execute(new ClientExecutionParams<DisableRadiusRequest, DisableRadiusResponse>()
                    .withOperationName("DisableRadius").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disableRadiusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableRadiusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disables single-sign on for a directory.
     * </p>
     *
     * @param disableSsoRequest
     *        Contains the inputs for the <a>DisableSso</a> operation.
     * @return Result of the DisableSso operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InsufficientPermissionsException
     *         The account does not have sufficient permission to perform the operation.
     * @throws AuthenticationFailedException
     *         An authentication error occurred.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.DisableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DisableSso" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisableSsoResponse disableSso(DisableSsoRequest disableSsoRequest) throws EntityDoesNotExistException,
            InsufficientPermissionsException, AuthenticationFailedException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisableSsoResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisableSsoResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disableSsoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisableSso");

            return clientHandler.execute(new ClientExecutionParams<DisableSsoRequest, DisableSsoResponse>()
                    .withOperationName("DisableSso").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(disableSsoRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisableSsoRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables certificate authority (CA) enrollment policy for the specified directory. This allows domain-joined
     * clients to automatically request and receive certificates from the specified Amazon Web Services Private
     * Certificate Authority.
     * </p>
     * <note>
     * <p>
     * Before enabling CA enrollment, ensure that the PCA connector is properly configured and accessible from the
     * directory. The connector must be in an active state and have the necessary permissions.
     * </p>
     * </note>
     *
     * @param enableCaEnrollmentPolicyRequest
     *        Contains the inputs for the <a>EnableCAEnrollmentPolicy</a> operation.
     * @return Result of the EnableCAEnrollmentPolicy operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws EnableAlreadyInProgressException
     *         An enable operation for CA enrollment policy is already in progress for this directory.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.EnableCAEnrollmentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableCAEnrollmentPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public EnableCaEnrollmentPolicyResponse enableCAEnrollmentPolicy(
            EnableCaEnrollmentPolicyRequest enableCaEnrollmentPolicyRequest) throws DirectoryDoesNotExistException,
            DirectoryUnavailableException, InvalidParameterException, EntityAlreadyExistsException, EntityDoesNotExistException,
            EnableAlreadyInProgressException, ClientException, ServiceException, AccessDeniedException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableCaEnrollmentPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, EnableCaEnrollmentPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableCaEnrollmentPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableCaEnrollmentPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableCAEnrollmentPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableCaEnrollmentPolicyRequest, EnableCaEnrollmentPolicyResponse>()
                            .withOperationName("EnableCAEnrollmentPolicy").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(enableCaEnrollmentPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EnableCaEnrollmentPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables alternative client authentication methods for the specified directory.
     * </p>
     *
     * @param enableClientAuthenticationRequest
     * @return Result of the EnableClientAuthentication operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidClientAuthStatusException
     *         Client authentication is already enabled.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws NoAvailableCertificateException
     *         Client authentication setup could not be completed because at least one valid certificate must be
     *         registered in the system.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.EnableClientAuthentication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableClientAuthentication" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public EnableClientAuthenticationResponse enableClientAuthentication(
            EnableClientAuthenticationRequest enableClientAuthenticationRequest) throws DirectoryDoesNotExistException,
            UnsupportedOperationException, InvalidClientAuthStatusException, AccessDeniedException,
            NoAvailableCertificateException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableClientAuthenticationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, EnableClientAuthenticationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableClientAuthenticationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableClientAuthenticationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableClientAuthentication");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableClientAuthenticationRequest, EnableClientAuthenticationResponse>()
                            .withOperationName("EnableClientAuthentication").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(enableClientAuthenticationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EnableClientAuthenticationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables access to directory data via the Directory Service Data API for the specified directory. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/directoryservicedata/latest/DirectoryServiceDataAPIReference/Welcome.html"
     * >Directory Service Data API Reference</a>.
     * </p>
     *
     * @param enableDirectoryDataAccessRequest
     * @return Result of the EnableDirectoryDataAccess operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws DirectoryInDesiredStateException
     *         The directory is already updated to desired update type settings.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.EnableDirectoryDataAccess
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableDirectoryDataAccess" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public EnableDirectoryDataAccessResponse enableDirectoryDataAccess(
            EnableDirectoryDataAccessRequest enableDirectoryDataAccessRequest) throws DirectoryDoesNotExistException,
            DirectoryUnavailableException, UnsupportedOperationException, DirectoryInDesiredStateException,
            AccessDeniedException, ClientException, ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableDirectoryDataAccessResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, EnableDirectoryDataAccessResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableDirectoryDataAccessRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableDirectoryDataAccessRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableDirectoryDataAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<EnableDirectoryDataAccessRequest, EnableDirectoryDataAccessResponse>()
                            .withOperationName("EnableDirectoryDataAccess").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(enableDirectoryDataAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EnableDirectoryDataAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Activates the switch for the specific directory to always use LDAP secure calls.
     * </p>
     *
     * @param enableLdapsRequest
     * @return Result of the EnableLDAPS operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws NoAvailableCertificateException
     *         Client authentication setup could not be completed because at least one valid certificate must be
     *         registered in the system.
     * @throws InvalidLdapsStatusException
     *         The LDAP activities could not be performed because they are limited by the LDAPS status.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.EnableLDAPS
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableLDAPS" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EnableLdapsResponse enableLDAPS(EnableLdapsRequest enableLdapsRequest) throws DirectoryUnavailableException,
            DirectoryDoesNotExistException, NoAvailableCertificateException, InvalidLdapsStatusException,
            UnsupportedOperationException, InvalidParameterException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableLdapsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableLdapsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableLdapsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableLdapsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableLDAPS");

            return clientHandler.execute(new ClientExecutionParams<EnableLdapsRequest, EnableLdapsResponse>()
                    .withOperationName("EnableLDAPS").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(enableLdapsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableLdapsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables multi-factor authentication (MFA) with the Remote Authentication Dial In User Service (RADIUS) server for
     * an AD Connector or Microsoft AD directory.
     * </p>
     *
     * @param enableRadiusRequest
     *        Contains the inputs for the <a>EnableRadius</a> operation.
     * @return Result of the EnableRadius operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws EntityAlreadyExistsException
     *         The specified entity already exists.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.EnableRadius
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableRadius" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EnableRadiusResponse enableRadius(EnableRadiusRequest enableRadiusRequest) throws InvalidParameterException,
            EntityAlreadyExistsException, EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableRadiusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableRadiusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableRadiusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableRadiusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableRadius");

            return clientHandler.execute(new ClientExecutionParams<EnableRadiusRequest, EnableRadiusResponse>()
                    .withOperationName("EnableRadius").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(enableRadiusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableRadiusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables single sign-on for a directory. Single sign-on allows users in your directory to access certain Amazon
     * Web Services services from a computer joined to the directory without having to enter their credentials
     * separately.
     * </p>
     *
     * @param enableSsoRequest
     *        Contains the inputs for the <a>EnableSso</a> operation.
     * @return Result of the EnableSso operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InsufficientPermissionsException
     *         The account does not have sufficient permission to perform the operation.
     * @throws AuthenticationFailedException
     *         An authentication error occurred.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.EnableSso
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/EnableSso" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EnableSsoResponse enableSso(EnableSsoRequest enableSsoRequest) throws EntityDoesNotExistException,
            InsufficientPermissionsException, AuthenticationFailedException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EnableSsoResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EnableSsoResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(enableSsoRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableSsoRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableSso");

            return clientHandler.execute(new ClientExecutionParams<EnableSsoRequest, EnableSsoResponse>()
                    .withOperationName("EnableSso").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(enableSsoRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableSsoRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains directory limit information for the current Region.
     * </p>
     *
     * @param getDirectoryLimitsRequest
     *        Contains the inputs for the <a>GetDirectoryLimits</a> operation.
     * @return Result of the GetDirectoryLimits operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.GetDirectoryLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetDirectoryLimits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDirectoryLimitsResponse getDirectoryLimits(GetDirectoryLimitsRequest getDirectoryLimitsRequest)
            throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDirectoryLimitsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDirectoryLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDirectoryLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDirectoryLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDirectoryLimits");

            return clientHandler.execute(new ClientExecutionParams<GetDirectoryLimitsRequest, GetDirectoryLimitsResponse>()
                    .withOperationName("GetDirectoryLimits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDirectoryLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDirectoryLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Obtains the manual snapshot limits for a directory.
     * </p>
     *
     * @param getSnapshotLimitsRequest
     *        Contains the inputs for the <a>GetSnapshotLimits</a> operation.
     * @return Result of the GetSnapshotLimits operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.GetSnapshotLimits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/GetSnapshotLimits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSnapshotLimitsResponse getSnapshotLimits(GetSnapshotLimitsRequest getSnapshotLimitsRequest)
            throws EntityDoesNotExistException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSnapshotLimitsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSnapshotLimitsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSnapshotLimitsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSnapshotLimitsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSnapshotLimits");

            return clientHandler.execute(new ClientExecutionParams<GetSnapshotLimitsRequest, GetSnapshotLimitsResponse>()
                    .withOperationName("GetSnapshotLimits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSnapshotLimitsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSnapshotLimitsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of directory assessments for the specified directory or all assessments in your account. Use
     * this operation to monitor assessment status and manage multiple assessments.
     * </p>
     *
     * @param listAdAssessmentsRequest
     * @return Result of the ListADAssessments operation returned by the service.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ListADAssessments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListADAssessments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAdAssessmentsResponse listADAssessments(ListAdAssessmentsRequest listAdAssessmentsRequest) throws ClientException,
            ServiceException, InvalidParameterException, UnsupportedOperationException, DirectoryDoesNotExistException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAdAssessmentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAdAssessmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAdAssessmentsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAdAssessmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListADAssessments");

            return clientHandler.execute(new ClientExecutionParams<ListAdAssessmentsRequest, ListAdAssessmentsResponse>()
                    .withOperationName("ListADAssessments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listAdAssessmentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAdAssessmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For the specified directory, lists all the certificates registered for a secure LDAP or client certificate
     * authentication.
     * </p>
     *
     * @param listCertificatesRequest
     * @return Result of the ListCertificates operation returned by the service.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ListCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCertificatesResponse listCertificates(ListCertificatesRequest listCertificatesRequest)
            throws DirectoryDoesNotExistException, UnsupportedOperationException, InvalidParameterException,
            InvalidNextTokenException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCertificatesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCertificates");

            return clientHandler.execute(new ClientExecutionParams<ListCertificatesRequest, ListCertificatesResponse>()
                    .withOperationName("ListCertificates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCertificatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the address blocks that you have added to a directory.
     * </p>
     *
     * @param listIpRoutesRequest
     * @return Result of the ListIpRoutes operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ListIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIpRoutesResponse listIpRoutes(ListIpRoutesRequest listIpRoutesRequest) throws EntityDoesNotExistException,
            InvalidNextTokenException, InvalidParameterException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIpRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIpRoutesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIpRoutesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIpRoutes");

            return clientHandler.execute(new ClientExecutionParams<ListIpRoutesRequest, ListIpRoutesResponse>()
                    .withOperationName("ListIpRoutes").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIpRoutesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIpRoutesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the active log subscriptions for the Amazon Web Services account.
     * </p>
     *
     * @param listLogSubscriptionsRequest
     * @return Result of the ListLogSubscriptions operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ListLogSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListLogSubscriptions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLogSubscriptionsResponse listLogSubscriptions(ListLogSubscriptionsRequest listLogSubscriptionsRequest)
            throws EntityDoesNotExistException, InvalidNextTokenException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLogSubscriptionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLogSubscriptionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listLogSubscriptionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLogSubscriptionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLogSubscriptions");

            return clientHandler.execute(new ClientExecutionParams<ListLogSubscriptionsRequest, ListLogSubscriptionsResponse>()
                    .withOperationName("ListLogSubscriptions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listLogSubscriptionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLogSubscriptionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all schema extensions applied to a Microsoft AD Directory.
     * </p>
     *
     * @param listSchemaExtensionsRequest
     * @return Result of the ListSchemaExtensions operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ListSchemaExtensions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListSchemaExtensions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSchemaExtensionsResponse listSchemaExtensions(ListSchemaExtensionsRequest listSchemaExtensionsRequest)
            throws InvalidNextTokenException, EntityDoesNotExistException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSchemaExtensionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSchemaExtensionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSchemaExtensionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSchemaExtensionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSchemaExtensions");

            return clientHandler.execute(new ClientExecutionParams<ListSchemaExtensionsRequest, ListSchemaExtensionsResponse>()
                    .withOperationName("ListSchemaExtensions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSchemaExtensionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSchemaExtensionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags on a directory.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value is not valid.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws EntityDoesNotExistException, InvalidNextTokenException, InvalidParameterException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a certificate for a secure LDAP or client certificate authentication.
     * </p>
     *
     * @param registerCertificateRequest
     * @return Result of the RegisterCertificate operation returned by the service.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws DirectoryDoesNotExistException
     *         The specified directory does not exist in the system.
     * @throws InvalidCertificateException
     *         The certificate PEM that was provided has incorrect encoding.
     * @throws CertificateLimitExceededException
     *         The certificate could not be added because the certificate limit has been reached.
     * @throws CertificateAlreadyExistsException
     *         The certificate has already been registered into the system.
     * @throws UnsupportedOperationException
     *         The operation is not supported.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.RegisterCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RegisterCertificateResponse registerCertificate(RegisterCertificateRequest registerCertificateRequest)
            throws DirectoryUnavailableException, DirectoryDoesNotExistException, InvalidCertificateException,
            CertificateLimitExceededException, CertificateAlreadyExistsException, UnsupportedOperationException,
            InvalidParameterException, ClientException, ServiceException, AwsServiceException, SdkClientException,
            DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterCertificateResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterCertificate");

            return clientHandler.execute(new ClientExecutionParams<RegisterCertificateRequest, RegisterCertificateResponse>()
                    .withOperationName("RegisterCertificate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a directory with an Amazon SNS topic. This establishes the directory as a publisher to the specified
     * Amazon SNS topic. You can then receive email or text (SMS) messages when the status of your directory changes.
     * You get notified if your directory goes from an Active status to an Impaired or Inoperable status. You also
     * receive a notification when the directory returns to an Active status.
     * </p>
     *
     * @param registerEventTopicRequest
     *        Registers a new event topic.
     * @return Result of the RegisterEventTopic operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.RegisterEventTopic
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RegisterEventTopic" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RegisterEventTopicResponse registerEventTopic(RegisterEventTopicRequest registerEventTopicRequest)
            throws EntityDoesNotExistException, InvalidParameterException, ClientException, ServiceException,
            AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterEventTopicResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterEventTopicResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(registerEventTopicRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerEventTopicRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterEventTopic");

            return clientHandler.execute(new ClientExecutionParams<RegisterEventTopicRequest, RegisterEventTopicResponse>()
                    .withOperationName("RegisterEventTopic").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(registerEventTopicRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterEventTopicRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Rejects a directory sharing request that was sent from the directory owner account.
     * </p>
     *
     * @param rejectSharedDirectoryRequest
     * @return Result of the RejectSharedDirectory operation returned by the service.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws DirectoryAlreadySharedException
     *         The specified directory has already been shared with this Amazon Web Services account.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.RejectSharedDirectory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RejectSharedDirectory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RejectSharedDirectoryResponse rejectSharedDirectory(RejectSharedDirectoryRequest rejectSharedDirectoryRequest)
            throws InvalidParameterException, EntityDoesNotExistException, DirectoryAlreadySharedException, ClientException,
            ServiceException, AwsServiceException, SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectSharedDirectoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectSharedDirectoryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder).build());
            case "CertificateDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateDoesNotExistException::builder).build());
            case "ServiceException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceException").httpStatusCode(500)
                        .exceptionBuilderSupplier(ServiceException::builder).build());
            case "SnapshotLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("SnapshotLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(SnapshotLimitExceededException::builder).build());
            case "EntityAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).build());
            case "ADAssessmentLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ADAssessmentLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(AdAssessmentLimitExceededException::builder).build());
            case "InvalidClientAuthStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidClientAuthStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidClientAuthStatusException::builder).build());
            case "UnsupportedSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedSettingsException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "NoAvailableCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NoAvailableCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(NoAvailableCertificateException::builder).build());
            case "InvalidTargetException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTargetException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidTargetException::builder).build());
            case "IpRouteLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IpRouteLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IpRouteLimitExceededException::builder).build());
            case "TagLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("TagLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(TagLimitExceededException::builder).build());
            case "ShareLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ShareLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ShareLimitExceededException::builder).build());
            case "CertificateInUseException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateInUseException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateInUseException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectSharedDirectoryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectSharedDirectoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Directory Service");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectSharedDirectory");

            return clientHandler.execute(new ClientExecutionParams<RejectSharedDirectoryRequest, RejectSharedDirectoryResponse>()
                    .withOperationName("RejectSharedDirectory").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(rejectSharedDirectoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RejectSharedDirectoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes IP address blocks from a directory.
     * </p>
     *
     * @param removeIpRoutesRequest
     * @return Result of the RemoveIpRoutes operation returned by the service.
     * @throws EntityDoesNotExistException
     *         The specified entity could not be found.
     * @throws InvalidParameterException
     *         One or more parameters are not valid.
     * @throws DirectoryUnavailableException
     *         The specified directory is unavailable.
     * @throws ClientException
     *         A client exception has occurred.
     * @throws ServiceException
     *         An exception has occurred in Directory Service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws DirectoryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample DirectoryClient.RemoveIpRoutes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/RemoveIpRoutes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemoveIpRoutesResponse removeIpRoutes(RemoveIpRoutesRequest removeIpRoutesRequest) throws EntityDoesNotExistException,
            InvalidParameterException, DirectoryUnavailableException, ClientException, ServiceException, AwsServiceException,
            SdkClientException, DirectoryException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveIpRoutesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RemoveIpRoutesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "DirectoryAlreadySharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadySharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadySharedException::builder).build());
            case "EnableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EnableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EnableAlreadyInProgressException::builder).build());
            case "DirectoryUnavailableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryUnavailableException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryUnavailableException::builder).build());
            case "InvalidCertificateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCertificateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidCertificateException::builder).build());
            case "DirectoryNotSharedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryNotSharedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryNotSharedException::builder).build());
            case "RegionLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RegionLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(RegionLimitExceededException::builder).build());
            case "DisableAlreadyInProgressException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DisableAlreadyInProgressException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DisableAlreadyInProgressException::builder).build());
            case "EntityDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("EntityDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(EntityDoesNotExistException::builder).build());
            case "DirectoryLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryLimitExceededException::builder).build());
            case "DirectoryDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryDoesNotExistException::builder).build());
            case "InvalidNextTokenException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
            case "CertificateAlreadyExistsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateAlreadyExistsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateAlreadyExistsException::builder).build());
            case "DirectoryAlreadyInRegionException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryAlreadyInRegionException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryAlreadyInRegionException::builder).build());
            case "DomainControllerLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DomainControllerLimitExceededException")
                        .httpStatusCode(400).exceptionBuilderSupplier(DomainControllerLimitExceededException::builder).build());
            case "UserDoesNotExistException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UserDoesNotExistException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UserDoesNotExistException::builder).build());
            case "InvalidPasswordException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidPasswordException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidPasswordException::builder).build());
            case "UnsupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
            case "ClientException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ClientException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ClientException::builder).build());
            case "IncompatibleSettingsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("IncompatibleSettingsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(IncompatibleSettingsException::builder).build());
            case "AuthenticationFailedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AuthenticationFailedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AuthenticationFailedException::builder).build());
            case "DirectoryInDesiredStateException":
                return Optional.of(ExceptionMetadata.builder().errorCode("DirectoryInDesiredStateException").httpStatusCode(400)
                        .exceptionBuilderSupplier(DirectoryInDesiredStateException::builder).build());
            case "InsufficientPermissionsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientPermissionsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InsufficientPermissionsException::builder).build());
            case "CertificateLimitExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("CertificateLimitExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(CertificateLimitExceededException::builder).build());
            case "OrganizationsException":
                return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsException").httpStatusCode(400)
                        .exceptionBuilderSupplier(OrganizationsException::builder).build());
            case "InvalidLDAPSStatusException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLDAPSStatusException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidLdapsStatusException::builder).build());
            case "InvalidParameterException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(400)
                        .exceptionBuilderSupplier(InvalidParameterException::builder