/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the inputs for the <a>CreateComputer</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputerRequest extends DirectoryRequest implements
        ToCopyableBuilder<CreateComputerRequest.Builder, CreateComputerRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateComputerRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> COMPUTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputerName").getter(getter(CreateComputerRequest::computerName)).setter(setter(Builder::computerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(CreateComputerRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OrganizationalUnitDistinguishedName")
            .getter(getter(CreateComputerRequest::organizationalUnitDistinguishedName))
            .setter(setter(Builder::organizationalUnitDistinguishedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationalUnitDistinguishedName").build()).build();

    private static final SdkField<List<Attribute>> COMPUTER_ATTRIBUTES_FIELD = SdkField
            .<List<Attribute>> builder(MarshallingType.LIST)
            .memberName("ComputerAttributes")
            .getter(getter(CreateComputerRequest::computerAttributes))
            .setter(setter(Builder::computerAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputerAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Attribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(Attribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            COMPUTER_NAME_FIELD, PASSWORD_FIELD, ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD, COMPUTER_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String computerName;

    private final String password;

    private final String organizationalUnitDistinguishedName;

    private final List<Attribute> computerAttributes;

    private CreateComputerRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.computerName = builder.computerName;
        this.password = builder.password;
        this.organizationalUnitDistinguishedName = builder.organizationalUnitDistinguishedName;
        this.computerAttributes = builder.computerAttributes;
    }

    /**
     * <p>
     * The identifier of the directory in which to create the computer account.
     * </p>
     * 
     * @return The identifier of the directory in which to create the computer account.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the computer account.
     * </p>
     * 
     * @return The name of the computer account.
     */
    public final String computerName() {
        return computerName;
    }

    /**
     * <p>
     * A one-time password that is used to join the computer to the directory. You should generate a random, strong
     * password to use for this parameter.
     * </p>
     * 
     * @return A one-time password that is used to join the computer to the directory. You should generate a random,
     *         strong password to use for this parameter.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The fully-qualified distinguished name of the organizational unit to place the computer account in.
     * </p>
     * 
     * @return The fully-qualified distinguished name of the organizational unit to place the computer account in.
     */
    public final String organizationalUnitDistinguishedName() {
        return organizationalUnitDistinguishedName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputerAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasComputerAttributes() {
        return computerAttributes != null && !(computerAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputerAttributes} method.
     * </p>
     * 
     * @return An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer account.
     */
    public final List<Attribute> computerAttributes() {
        return computerAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(computerName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedName());
        hashCode = 31 * hashCode + Objects.hashCode(hasComputerAttributes() ? computerAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputerRequest)) {
            return false;
        }
        CreateComputerRequest other = (CreateComputerRequest) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(computerName(), other.computerName())
                && Objects.equals(password(), other.password())
                && Objects.equals(organizationalUnitDistinguishedName(), other.organizationalUnitDistinguishedName())
                && hasComputerAttributes() == other.hasComputerAttributes()
                && Objects.equals(computerAttributes(), other.computerAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputerRequest").add("DirectoryId", directoryId()).add("ComputerName", computerName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("OrganizationalUnitDistinguishedName", organizationalUnitDistinguishedName())
                .add("ComputerAttributes", hasComputerAttributes() ? computerAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "ComputerName":
            return Optional.ofNullable(clazz.cast(computerName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "OrganizationalUnitDistinguishedName":
            return Optional.ofNullable(clazz.cast(organizationalUnitDistinguishedName()));
        case "ComputerAttributes":
            return Optional.ofNullable(clazz.cast(computerAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("ComputerName", COMPUTER_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("OrganizationalUnitDistinguishedName", ORGANIZATIONAL_UNIT_DISTINGUISHED_NAME_FIELD);
        map.put("ComputerAttributes", COMPUTER_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputerRequest, T> g) {
        return obj -> g.apply((CreateComputerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputerRequest> {
        /**
         * <p>
         * The identifier of the directory in which to create the computer account.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory in which to create the computer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the computer account.
         * </p>
         * 
         * @param computerName
         *        The name of the computer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerName(String computerName);

        /**
         * <p>
         * A one-time password that is used to join the computer to the directory. You should generate a random, strong
         * password to use for this parameter.
         * </p>
         * 
         * @param password
         *        A one-time password that is used to join the computer to the directory. You should generate a random,
         *        strong password to use for this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The fully-qualified distinguished name of the organizational unit to place the computer account in.
         * </p>
         * 
         * @param organizationalUnitDistinguishedName
         *        The fully-qualified distinguished name of the organizational unit to place the computer account in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName);

        /**
         * <p>
         * An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer account.
         * </p>
         * 
         * @param computerAttributes
         *        An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(Collection<Attribute> computerAttributes);

        /**
         * <p>
         * An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer account.
         * </p>
         * 
         * @param computerAttributes
         *        An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computerAttributes(Attribute... computerAttributes);

        /**
         * <p>
         * An array of <a>Attribute</a> objects that contain any LDAP attributes to apply to the computer account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.Attribute.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directory.model.Attribute#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.Attribute.Builder#build()} is called immediately and
         * its result is passed to {@link #computerAttributes(List<Attribute>)}.
         * 
         * @param computerAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.Attribute.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computerAttributes(java.util.Collection<Attribute>)
         */
        Builder computerAttributes(Consumer<Attribute.Builder>... computerAttributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String computerName;

        private String password;

        private String organizationalUnitDistinguishedName;

        private List<Attribute> computerAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputerRequest model) {
            super(model);
            directoryId(model.directoryId);
            computerName(model.computerName);
            password(model.password);
            organizationalUnitDistinguishedName(model.organizationalUnitDistinguishedName);
            computerAttributes(model.computerAttributes);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getComputerName() {
            return computerName;
        }

        public final void setComputerName(String computerName) {
            this.computerName = computerName;
        }

        @Override
        public final Builder computerName(String computerName) {
            this.computerName = computerName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getOrganizationalUnitDistinguishedName() {
            return organizationalUnitDistinguishedName;
        }

        public final void setOrganizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
        }

        @Override
        public final Builder organizationalUnitDistinguishedName(String organizationalUnitDistinguishedName) {
            this.organizationalUnitDistinguishedName = organizationalUnitDistinguishedName;
            return this;
        }

        public final List<Attribute.Builder> getComputerAttributes() {
            List<Attribute.Builder> result = AttributesCopier.copyToBuilder(this.computerAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputerAttributes(Collection<Attribute.BuilderImpl> computerAttributes) {
            this.computerAttributes = AttributesCopier.copyFromBuilder(computerAttributes);
        }

        @Override
        public final Builder computerAttributes(Collection<Attribute> computerAttributes) {
            this.computerAttributes = AttributesCopier.copy(computerAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Attribute... computerAttributes) {
            computerAttributes(Arrays.asList(computerAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computerAttributes(Consumer<Attribute.Builder>... computerAttributes) {
            computerAttributes(Stream.of(computerAttributes).map(c -> Attribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputerRequest build() {
            return new CreateComputerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
