/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the current hybrid directory configuration settings for a directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HybridSettingsDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<HybridSettingsDescription.Builder, HybridSettingsDescription> {
    private static final SdkField<List<String>> SELF_MANAGED_DNS_IP_ADDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelfManagedDnsIpAddrs")
            .getter(getter(HybridSettingsDescription::selfManagedDnsIpAddrs))
            .setter(setter(Builder::selfManagedDnsIpAddrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedDnsIpAddrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SELF_MANAGED_INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelfManagedInstanceIds")
            .getter(getter(HybridSettingsDescription::selfManagedInstanceIds))
            .setter(setter(Builder::selfManagedInstanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedInstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SELF_MANAGED_DNS_IP_ADDRS_FIELD, SELF_MANAGED_INSTANCE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> selfManagedDnsIpAddrs;

    private final List<String> selfManagedInstanceIds;

    private HybridSettingsDescription(BuilderImpl builder) {
        this.selfManagedDnsIpAddrs = builder.selfManagedDnsIpAddrs;
        this.selfManagedInstanceIds = builder.selfManagedInstanceIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelfManagedDnsIpAddrs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelfManagedDnsIpAddrs() {
        return selfManagedDnsIpAddrs != null && !(selfManagedDnsIpAddrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP addresses of the DNS servers in your self-managed AD environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelfManagedDnsIpAddrs} method.
     * </p>
     * 
     * @return The IP addresses of the DNS servers in your self-managed AD environment.
     */
    public final List<String> selfManagedDnsIpAddrs() {
        return selfManagedDnsIpAddrs;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelfManagedInstanceIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSelfManagedInstanceIds() {
        return selfManagedInstanceIds != null && !(selfManagedInstanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifiers of the self-managed instances with SSM used for hybrid directory operations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelfManagedInstanceIds} method.
     * </p>
     * 
     * @return The identifiers of the self-managed instances with SSM used for hybrid directory operations.
     */
    public final List<String> selfManagedInstanceIds() {
        return selfManagedInstanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelfManagedDnsIpAddrs() ? selfManagedDnsIpAddrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSelfManagedInstanceIds() ? selfManagedInstanceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridSettingsDescription)) {
            return false;
        }
        HybridSettingsDescription other = (HybridSettingsDescription) obj;
        return hasSelfManagedDnsIpAddrs() == other.hasSelfManagedDnsIpAddrs()
                && Objects.equals(selfManagedDnsIpAddrs(), other.selfManagedDnsIpAddrs())
                && hasSelfManagedInstanceIds() == other.hasSelfManagedInstanceIds()
                && Objects.equals(selfManagedInstanceIds(), other.selfManagedInstanceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HybridSettingsDescription")
                .add("SelfManagedDnsIpAddrs", hasSelfManagedDnsIpAddrs() ? selfManagedDnsIpAddrs() : null)
                .add("SelfManagedInstanceIds", hasSelfManagedInstanceIds() ? selfManagedInstanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelfManagedDnsIpAddrs":
            return Optional.ofNullable(clazz.cast(selfManagedDnsIpAddrs()));
        case "SelfManagedInstanceIds":
            return Optional.ofNullable(clazz.cast(selfManagedInstanceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SelfManagedDnsIpAddrs", SELF_MANAGED_DNS_IP_ADDRS_FIELD);
        map.put("SelfManagedInstanceIds", SELF_MANAGED_INSTANCE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridSettingsDescription, T> g) {
        return obj -> g.apply((HybridSettingsDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HybridSettingsDescription> {
        /**
         * <p>
         * The IP addresses of the DNS servers in your self-managed AD environment.
         * </p>
         * 
         * @param selfManagedDnsIpAddrs
         *        The IP addresses of the DNS servers in your self-managed AD environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedDnsIpAddrs(Collection<String> selfManagedDnsIpAddrs);

        /**
         * <p>
         * The IP addresses of the DNS servers in your self-managed AD environment.
         * </p>
         * 
         * @param selfManagedDnsIpAddrs
         *        The IP addresses of the DNS servers in your self-managed AD environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedDnsIpAddrs(String... selfManagedDnsIpAddrs);

        /**
         * <p>
         * The identifiers of the self-managed instances with SSM used for hybrid directory operations.
         * </p>
         * 
         * @param selfManagedInstanceIds
         *        The identifiers of the self-managed instances with SSM used for hybrid directory operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedInstanceIds(Collection<String> selfManagedInstanceIds);

        /**
         * <p>
         * The identifiers of the self-managed instances with SSM used for hybrid directory operations.
         * </p>
         * 
         * @param selfManagedInstanceIds
         *        The identifiers of the self-managed instances with SSM used for hybrid directory operations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedInstanceIds(String... selfManagedInstanceIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> selfManagedDnsIpAddrs = DefaultSdkAutoConstructList.getInstance();

        private List<String> selfManagedInstanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HybridSettingsDescription model) {
            selfManagedDnsIpAddrs(model.selfManagedDnsIpAddrs);
            selfManagedInstanceIds(model.selfManagedInstanceIds);
        }

        public final Collection<String> getSelfManagedDnsIpAddrs() {
            if (selfManagedDnsIpAddrs instanceof SdkAutoConstructList) {
                return null;
            }
            return selfManagedDnsIpAddrs;
        }

        public final void setSelfManagedDnsIpAddrs(Collection<String> selfManagedDnsIpAddrs) {
            this.selfManagedDnsIpAddrs = IpAddrsCopier.copy(selfManagedDnsIpAddrs);
        }

        @Override
        public final Builder selfManagedDnsIpAddrs(Collection<String> selfManagedDnsIpAddrs) {
            this.selfManagedDnsIpAddrs = IpAddrsCopier.copy(selfManagedDnsIpAddrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedDnsIpAddrs(String... selfManagedDnsIpAddrs) {
            selfManagedDnsIpAddrs(Arrays.asList(selfManagedDnsIpAddrs));
            return this;
        }

        public final Collection<String> getSelfManagedInstanceIds() {
            if (selfManagedInstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return selfManagedInstanceIds;
        }

        public final void setSelfManagedInstanceIds(Collection<String> selfManagedInstanceIds) {
            this.selfManagedInstanceIds = AssessmentInstanceIdsCopier.copy(selfManagedInstanceIds);
        }

        @Override
        public final Builder selfManagedInstanceIds(Collection<String> selfManagedInstanceIds) {
            this.selfManagedInstanceIds = AssessmentInstanceIdsCopier.copy(selfManagedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedInstanceIds(String... selfManagedInstanceIds) {
            selfManagedInstanceIds(Arrays.asList(selfManagedInstanceIds));
            return this;
        }

        @Override
        public HybridSettingsDescription build() {
            return new HybridSettingsDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
