/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the shared directory in the directory owner account for which the share request in the directory
 * consumer account has been accepted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SharedDirectory implements SdkPojo, Serializable, ToCopyableBuilder<SharedDirectory.Builder, SharedDirectory> {
    private static final SdkField<String> OWNER_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerAccountId").getter(getter(SharedDirectory::ownerAccountId)).setter(setter(Builder::ownerAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerAccountId").build()).build();

    private static final SdkField<String> OWNER_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerDirectoryId").getter(getter(SharedDirectory::ownerDirectoryId))
            .setter(setter(Builder::ownerDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerDirectoryId").build()).build();

    private static final SdkField<String> SHARE_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareMethod").getter(getter(SharedDirectory::shareMethodAsString)).setter(setter(Builder::shareMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareMethod").build()).build();

    private static final SdkField<String> SHARED_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedAccountId").getter(getter(SharedDirectory::sharedAccountId))
            .setter(setter(Builder::sharedAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedAccountId").build()).build();

    private static final SdkField<String> SHARED_DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedDirectoryId").getter(getter(SharedDirectory::sharedDirectoryId))
            .setter(setter(Builder::sharedDirectoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectoryId").build()).build();

    private static final SdkField<String> SHARE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareStatus").getter(getter(SharedDirectory::shareStatusAsString)).setter(setter(Builder::shareStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareStatus").build()).build();

    private static final SdkField<String> SHARE_NOTES_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ShareNotes").getter(getter(SharedDirectory::shareNotes)).setter(setter(Builder::shareNotes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShareNotes").build()).build();

    private static final SdkField<Instant> CREATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDateTime").getter(getter(SharedDirectory::createdDateTime))
            .setter(setter(Builder::createdDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDateTime").getter(getter(SharedDirectory::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_ACCOUNT_ID_FIELD,
            OWNER_DIRECTORY_ID_FIELD, SHARE_METHOD_FIELD, SHARED_ACCOUNT_ID_FIELD, SHARED_DIRECTORY_ID_FIELD, SHARE_STATUS_FIELD,
            SHARE_NOTES_FIELD, CREATED_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ownerAccountId;

    private final String ownerDirectoryId;

    private final String shareMethod;

    private final String sharedAccountId;

    private final String sharedDirectoryId;

    private final String shareStatus;

    private final String shareNotes;

    private final Instant createdDateTime;

    private final Instant lastUpdatedDateTime;

    private SharedDirectory(BuilderImpl builder) {
        this.ownerAccountId = builder.ownerAccountId;
        this.ownerDirectoryId = builder.ownerDirectoryId;
        this.shareMethod = builder.shareMethod;
        this.sharedAccountId = builder.sharedAccountId;
        this.sharedDirectoryId = builder.sharedDirectoryId;
        this.shareStatus = builder.shareStatus;
        this.shareNotes = builder.shareNotes;
        this.createdDateTime = builder.createdDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * Identifier of the directory owner account, which contains the directory that has been shared to the consumer
     * account.
     * </p>
     * 
     * @return Identifier of the directory owner account, which contains the directory that has been shared to the
     *         consumer account.
     */
    public final String ownerAccountId() {
        return ownerAccountId;
    }

    /**
     * <p>
     * Identifier of the directory in the directory owner account.
     * </p>
     * 
     * @return Identifier of the directory in the directory owner account.
     */
    public final String ownerDirectoryId() {
        return ownerDirectoryId;
    }

    /**
     * <p>
     * The method used when sharing a directory to determine whether the directory should be shared within your Amazon
     * Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a
     * shared directory request (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareMethod} will
     * return {@link ShareMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareMethodAsString}.
     * </p>
     * 
     * @return The method used when sharing a directory to determine whether the directory should be shared within your
     *         Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
     *         sending a shared directory request (<code>HANDSHAKE</code>).
     * @see ShareMethod
     */
    public final ShareMethod shareMethod() {
        return ShareMethod.fromValue(shareMethod);
    }

    /**
     * <p>
     * The method used when sharing a directory to determine whether the directory should be shared within your Amazon
     * Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by sending a
     * shared directory request (<code>HANDSHAKE</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareMethod} will
     * return {@link ShareMethod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareMethodAsString}.
     * </p>
     * 
     * @return The method used when sharing a directory to determine whether the directory should be shared within your
     *         Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
     *         sending a shared directory request (<code>HANDSHAKE</code>).
     * @see ShareMethod
     */
    public final String shareMethodAsString() {
        return shareMethod;
    }

    /**
     * <p>
     * Identifier of the directory consumer account that has access to the shared directory (
     * <code>OwnerDirectoryId</code>) in the directory owner account.
     * </p>
     * 
     * @return Identifier of the directory consumer account that has access to the shared directory (
     *         <code>OwnerDirectoryId</code>) in the directory owner account.
     */
    public final String sharedAccountId() {
        return sharedAccountId;
    }

    /**
     * <p>
     * Identifier of the shared directory in the directory consumer account. This identifier is different for each
     * directory owner account.
     * </p>
     * 
     * @return Identifier of the shared directory in the directory consumer account. This identifier is different for
     *         each directory owner account.
     */
    public final String sharedDirectoryId() {
        return sharedDirectoryId;
    }

    /**
     * <p>
     * Current directory status of the shared Managed Microsoft AD directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Current directory status of the shared Managed Microsoft AD directory.
     * @see ShareStatus
     */
    public final ShareStatus shareStatus() {
        return ShareStatus.fromValue(shareStatus);
    }

    /**
     * <p>
     * Current directory status of the shared Managed Microsoft AD directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #shareStatus} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #shareStatusAsString}.
     * </p>
     * 
     * @return Current directory status of the shared Managed Microsoft AD directory.
     * @see ShareStatus
     */
    public final String shareStatusAsString() {
        return shareStatus;
    }

    /**
     * <p>
     * A directory share request that is sent by the directory owner to the directory consumer. The request includes a
     * typed message to help the directory consumer administrator determine whether to approve or reject the share
     * invitation.
     * </p>
     * 
     * @return A directory share request that is sent by the directory owner to the directory consumer. The request
     *         includes a typed message to help the directory consumer administrator determine whether to approve or
     *         reject the share invitation.
     */
    public final String shareNotes() {
        return shareNotes;
    }

    /**
     * <p>
     * The date and time that the shared directory was created.
     * </p>
     * 
     * @return The date and time that the shared directory was created.
     */
    public final Instant createdDateTime() {
        return createdDateTime;
    }

    /**
     * <p>
     * The date and time that the shared directory was last updated.
     * </p>
     * 
     * @return The date and time that the shared directory was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(shareMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sharedAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sharedDirectoryId());
        hashCode = 31 * hashCode + Objects.hashCode(shareStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareNotes());
        hashCode = 31 * hashCode + Objects.hashCode(createdDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SharedDirectory)) {
            return false;
        }
        SharedDirectory other = (SharedDirectory) obj;
        return Objects.equals(ownerAccountId(), other.ownerAccountId())
                && Objects.equals(ownerDirectoryId(), other.ownerDirectoryId())
                && Objects.equals(shareMethodAsString(), other.shareMethodAsString())
                && Objects.equals(sharedAccountId(), other.sharedAccountId())
                && Objects.equals(sharedDirectoryId(), other.sharedDirectoryId())
                && Objects.equals(shareStatusAsString(), other.shareStatusAsString())
                && Objects.equals(shareNotes(), other.shareNotes()) && Objects.equals(createdDateTime(), other.createdDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SharedDirectory").add("OwnerAccountId", ownerAccountId())
                .add("OwnerDirectoryId", ownerDirectoryId()).add("ShareMethod", shareMethodAsString())
                .add("SharedAccountId", sharedAccountId()).add("SharedDirectoryId", sharedDirectoryId())
                .add("ShareStatus", shareStatusAsString())
                .add("ShareNotes", shareNotes() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatedDateTime", createdDateTime()).add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerAccountId":
            return Optional.ofNullable(clazz.cast(ownerAccountId()));
        case "OwnerDirectoryId":
            return Optional.ofNullable(clazz.cast(ownerDirectoryId()));
        case "ShareMethod":
            return Optional.ofNullable(clazz.cast(shareMethodAsString()));
        case "SharedAccountId":
            return Optional.ofNullable(clazz.cast(sharedAccountId()));
        case "SharedDirectoryId":
            return Optional.ofNullable(clazz.cast(sharedDirectoryId()));
        case "ShareStatus":
            return Optional.ofNullable(clazz.cast(shareStatusAsString()));
        case "ShareNotes":
            return Optional.ofNullable(clazz.cast(shareNotes()));
        case "CreatedDateTime":
            return Optional.ofNullable(clazz.cast(createdDateTime()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerAccountId", OWNER_ACCOUNT_ID_FIELD);
        map.put("OwnerDirectoryId", OWNER_DIRECTORY_ID_FIELD);
        map.put("ShareMethod", SHARE_METHOD_FIELD);
        map.put("SharedAccountId", SHARED_ACCOUNT_ID_FIELD);
        map.put("SharedDirectoryId", SHARED_DIRECTORY_ID_FIELD);
        map.put("ShareStatus", SHARE_STATUS_FIELD);
        map.put("ShareNotes", SHARE_NOTES_FIELD);
        map.put("CreatedDateTime", CREATED_DATE_TIME_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SharedDirectory, T> g) {
        return obj -> g.apply((SharedDirectory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SharedDirectory> {
        /**
         * <p>
         * Identifier of the directory owner account, which contains the directory that has been shared to the consumer
         * account.
         * </p>
         * 
         * @param ownerAccountId
         *        Identifier of the directory owner account, which contains the directory that has been shared to the
         *        consumer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccountId(String ownerAccountId);

        /**
         * <p>
         * Identifier of the directory in the directory owner account.
         * </p>
         * 
         * @param ownerDirectoryId
         *        Identifier of the directory in the directory owner account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerDirectoryId(String ownerDirectoryId);

        /**
         * <p>
         * The method used when sharing a directory to determine whether the directory should be shared within your
         * Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
         * sending a shared directory request (<code>HANDSHAKE</code>).
         * </p>
         * 
         * @param shareMethod
         *        The method used when sharing a directory to determine whether the directory should be shared within
         *        your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services
         *        account by sending a shared directory request (<code>HANDSHAKE</code>).
         * @see ShareMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareMethod
         */
        Builder shareMethod(String shareMethod);

        /**
         * <p>
         * The method used when sharing a directory to determine whether the directory should be shared within your
         * Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services account by
         * sending a shared directory request (<code>HANDSHAKE</code>).
         * </p>
         * 
         * @param shareMethod
         *        The method used when sharing a directory to determine whether the directory should be shared within
         *        your Amazon Web Services organization (<code>ORGANIZATIONS</code>) or with any Amazon Web Services
         *        account by sending a shared directory request (<code>HANDSHAKE</code>).
         * @see ShareMethod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareMethod
         */
        Builder shareMethod(ShareMethod shareMethod);

        /**
         * <p>
         * Identifier of the directory consumer account that has access to the shared directory (
         * <code>OwnerDirectoryId</code>) in the directory owner account.
         * </p>
         * 
         * @param sharedAccountId
         *        Identifier of the directory consumer account that has access to the shared directory (
         *        <code>OwnerDirectoryId</code>) in the directory owner account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedAccountId(String sharedAccountId);

        /**
         * <p>
         * Identifier of the shared directory in the directory consumer account. This identifier is different for each
         * directory owner account.
         * </p>
         * 
         * @param sharedDirectoryId
         *        Identifier of the shared directory in the directory consumer account. This identifier is different for
         *        each directory owner account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDirectoryId(String sharedDirectoryId);

        /**
         * <p>
         * Current directory status of the shared Managed Microsoft AD directory.
         * </p>
         * 
         * @param shareStatus
         *        Current directory status of the shared Managed Microsoft AD directory.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(String shareStatus);

        /**
         * <p>
         * Current directory status of the shared Managed Microsoft AD directory.
         * </p>
         * 
         * @param shareStatus
         *        Current directory status of the shared Managed Microsoft AD directory.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder shareStatus(ShareStatus shareStatus);

        /**
         * <p>
         * A directory share request that is sent by the directory owner to the directory consumer. The request includes
         * a typed message to help the directory consumer administrator determine whether to approve or reject the share
         * invitation.
         * </p>
         * 
         * @param shareNotes
         *        A directory share request that is sent by the directory owner to the directory consumer. The request
         *        includes a typed message to help the directory consumer administrator determine whether to approve or
         *        reject the share invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareNotes(String shareNotes);

        /**
         * <p>
         * The date and time that the shared directory was created.
         * </p>
         * 
         * @param createdDateTime
         *        The date and time that the shared directory was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDateTime(Instant createdDateTime);

        /**
         * <p>
         * The date and time that the shared directory was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time that the shared directory was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String ownerAccountId;

        private String ownerDirectoryId;

        private String shareMethod;

        private String sharedAccountId;

        private String sharedDirectoryId;

        private String shareStatus;

        private String shareNotes;

        private Instant createdDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SharedDirectory model) {
            ownerAccountId(model.ownerAccountId);
            ownerDirectoryId(model.ownerDirectoryId);
            shareMethod(model.shareMethod);
            sharedAccountId(model.sharedAccountId);
            sharedDirectoryId(model.sharedDirectoryId);
            shareStatus(model.shareStatus);
            shareNotes(model.shareNotes);
            createdDateTime(model.createdDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getOwnerAccountId() {
            return ownerAccountId;
        }

        public final void setOwnerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
        }

        @Override
        public final Builder ownerAccountId(String ownerAccountId) {
            this.ownerAccountId = ownerAccountId;
            return this;
        }

        public final String getOwnerDirectoryId() {
            return ownerDirectoryId;
        }

        public final void setOwnerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
        }

        @Override
        public final Builder ownerDirectoryId(String ownerDirectoryId) {
            this.ownerDirectoryId = ownerDirectoryId;
            return this;
        }

        public final String getShareMethod() {
            return shareMethod;
        }

        public final void setShareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
        }

        @Override
        public final Builder shareMethod(String shareMethod) {
            this.shareMethod = shareMethod;
            return this;
        }

        @Override
        public final Builder shareMethod(ShareMethod shareMethod) {
            this.shareMethod(shareMethod == null ? null : shareMethod.toString());
            return this;
        }

        public final String getSharedAccountId() {
            return sharedAccountId;
        }

        public final void setSharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
        }

        @Override
        public final Builder sharedAccountId(String sharedAccountId) {
            this.sharedAccountId = sharedAccountId;
            return this;
        }

        public final String getSharedDirectoryId() {
            return sharedDirectoryId;
        }

        public final void setSharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
        }

        @Override
        public final Builder sharedDirectoryId(String sharedDirectoryId) {
            this.sharedDirectoryId = sharedDirectoryId;
            return this;
        }

        public final String getShareStatus() {
            return shareStatus;
        }

        public final void setShareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
        }

        @Override
        public final Builder shareStatus(String shareStatus) {
            this.shareStatus = shareStatus;
            return this;
        }

        @Override
        public final Builder shareStatus(ShareStatus shareStatus) {
            this.shareStatus(shareStatus == null ? null : shareStatus.toString());
            return this;
        }

        public final String getShareNotes() {
            return shareNotes;
        }

        public final void setShareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
        }

        @Override
        public final Builder shareNotes(String shareNotes) {
            this.shareNotes = shareNotes;
            return this;
        }

        public final Instant getCreatedDateTime() {
            return createdDateTime;
        }

        public final void setCreatedDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
        }

        @Override
        public final Builder createdDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public SharedDirectory build() {
            return new SharedDirectory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
