/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHybridAdRequest extends DirectoryRequest implements
        ToCopyableBuilder<UpdateHybridAdRequest.Builder, UpdateHybridAdRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(UpdateHybridAdRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<HybridAdministratorAccountUpdate> HYBRID_ADMINISTRATOR_ACCOUNT_UPDATE_FIELD = SdkField
            .<HybridAdministratorAccountUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("HybridAdministratorAccountUpdate")
            .getter(getter(UpdateHybridAdRequest::hybridAdministratorAccountUpdate))
            .setter(setter(Builder::hybridAdministratorAccountUpdate))
            .constructor(HybridAdministratorAccountUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HybridAdministratorAccountUpdate")
                    .build()).build();

    private static final SdkField<HybridCustomerInstancesSettings> SELF_MANAGED_INSTANCES_SETTINGS_FIELD = SdkField
            .<HybridCustomerInstancesSettings> builder(MarshallingType.SDK_POJO)
            .memberName("SelfManagedInstancesSettings")
            .getter(getter(UpdateHybridAdRequest::selfManagedInstancesSettings))
            .setter(setter(Builder::selfManagedInstancesSettings))
            .constructor(HybridCustomerInstancesSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedInstancesSettings")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            HYBRID_ADMINISTRATOR_ACCOUNT_UPDATE_FIELD, SELF_MANAGED_INSTANCES_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate;

    private final HybridCustomerInstancesSettings selfManagedInstancesSettings;

    private UpdateHybridAdRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.hybridAdministratorAccountUpdate = builder.hybridAdministratorAccountUpdate;
        this.selfManagedInstancesSettings = builder.selfManagedInstancesSettings;
    }

    /**
     * <p>
     * The identifier of the hybrid directory to update.
     * </p>
     * 
     * @return The identifier of the hybrid directory to update.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * We create a hybrid directory administrator account when we create a hybrid directory. Use
     * <code>HybridAdministratorAccountUpdate</code> to recover the hybrid directory administrator account if you have
     * deleted it.
     * </p>
     * <p>
     * To recover your hybrid directory administrator account, we need temporary access to a user in your self-managed
     * AD with administrator permissions in the form of a secret from Amazon Web Services Secrets Manager. We use these
     * credentials once during recovery and don't store them.
     * </p>
     * <p>
     * If your hybrid directory administrator account exists, then you don’t need to use
     * <code>HybridAdministratorAccountUpdate</code>, even if you have updated your self-managed AD administrator user.
     * </p>
     * 
     * @return We create a hybrid directory administrator account when we create a hybrid directory. Use
     *         <code>HybridAdministratorAccountUpdate</code> to recover the hybrid directory administrator account if
     *         you have deleted it.</p>
     *         <p>
     *         To recover your hybrid directory administrator account, we need temporary access to a user in your
     *         self-managed AD with administrator permissions in the form of a secret from Amazon Web Services Secrets
     *         Manager. We use these credentials once during recovery and don't store them.
     *         </p>
     *         <p>
     *         If your hybrid directory administrator account exists, then you don’t need to use
     *         <code>HybridAdministratorAccountUpdate</code>, even if you have updated your self-managed AD
     *         administrator user.
     */
    public final HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate() {
        return hybridAdministratorAccountUpdate;
    }

    /**
     * <p>
     * Updates to the self-managed AD configuration, including DNS server IP addresses and Amazon Web Services System
     * Manager managed node identifiers.
     * </p>
     * 
     * @return Updates to the self-managed AD configuration, including DNS server IP addresses and Amazon Web Services
     *         System Manager managed node identifiers.
     */
    public final HybridCustomerInstancesSettings selfManagedInstancesSettings() {
        return selfManagedInstancesSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hybridAdministratorAccountUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(selfManagedInstancesSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHybridAdRequest)) {
            return false;
        }
        UpdateHybridAdRequest other = (UpdateHybridAdRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(hybridAdministratorAccountUpdate(), other.hybridAdministratorAccountUpdate())
                && Objects.equals(selfManagedInstancesSettings(), other.selfManagedInstancesSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHybridAdRequest").add("DirectoryId", directoryId())
                .add("HybridAdministratorAccountUpdate", hybridAdministratorAccountUpdate())
                .add("SelfManagedInstancesSettings", selfManagedInstancesSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "HybridAdministratorAccountUpdate":
            return Optional.ofNullable(clazz.cast(hybridAdministratorAccountUpdate()));
        case "SelfManagedInstancesSettings":
            return Optional.ofNullable(clazz.cast(selfManagedInstancesSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("HybridAdministratorAccountUpdate", HYBRID_ADMINISTRATOR_ACCOUNT_UPDATE_FIELD);
        map.put("SelfManagedInstancesSettings", SELF_MANAGED_INSTANCES_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHybridAdRequest, T> g) {
        return obj -> g.apply((UpdateHybridAdRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHybridAdRequest> {
        /**
         * <p>
         * The identifier of the hybrid directory to update.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the hybrid directory to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * We create a hybrid directory administrator account when we create a hybrid directory. Use
         * <code>HybridAdministratorAccountUpdate</code> to recover the hybrid directory administrator account if you
         * have deleted it.
         * </p>
         * <p>
         * To recover your hybrid directory administrator account, we need temporary access to a user in your
         * self-managed AD with administrator permissions in the form of a secret from Amazon Web Services Secrets
         * Manager. We use these credentials once during recovery and don't store them.
         * </p>
         * <p>
         * If your hybrid directory administrator account exists, then you don’t need to use
         * <code>HybridAdministratorAccountUpdate</code>, even if you have updated your self-managed AD administrator
         * user.
         * </p>
         * 
         * @param hybridAdministratorAccountUpdate
         *        We create a hybrid directory administrator account when we create a hybrid directory. Use
         *        <code>HybridAdministratorAccountUpdate</code> to recover the hybrid directory administrator account if
         *        you have deleted it.</p>
         *        <p>
         *        To recover your hybrid directory administrator account, we need temporary access to a user in your
         *        self-managed AD with administrator permissions in the form of a secret from Amazon Web Services
         *        Secrets Manager. We use these credentials once during recovery and don't store them.
         *        </p>
         *        <p>
         *        If your hybrid directory administrator account exists, then you don’t need to use
         *        <code>HybridAdministratorAccountUpdate</code>, even if you have updated your self-managed AD
         *        administrator user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate);

        /**
         * <p>
         * We create a hybrid directory administrator account when we create a hybrid directory. Use
         * <code>HybridAdministratorAccountUpdate</code> to recover the hybrid directory administrator account if you
         * have deleted it.
         * </p>
         * <p>
         * To recover your hybrid directory administrator account, we need temporary access to a user in your
         * self-managed AD with administrator permissions in the form of a secret from Amazon Web Services Secrets
         * Manager. We use these credentials once during recovery and don't store them.
         * </p>
         * <p>
         * If your hybrid directory administrator account exists, then you don’t need to use
         * <code>HybridAdministratorAccountUpdate</code>, even if you have updated your self-managed AD administrator
         * user.
         * </p>
         * This is a convenience method that creates an instance of the {@link HybridAdministratorAccountUpdate.Builder}
         * avoiding the need to create one manually via {@link HybridAdministratorAccountUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HybridAdministratorAccountUpdate.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate)}.
         * 
         * @param hybridAdministratorAccountUpdate
         *        a consumer that will call methods on {@link HybridAdministratorAccountUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate)
         */
        default Builder hybridAdministratorAccountUpdate(
                Consumer<HybridAdministratorAccountUpdate.Builder> hybridAdministratorAccountUpdate) {
            return hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate.builder()
                    .applyMutation(hybridAdministratorAccountUpdate).build());
        }

        /**
         * <p>
         * Updates to the self-managed AD configuration, including DNS server IP addresses and Amazon Web Services
         * System Manager managed node identifiers.
         * </p>
         * 
         * @param selfManagedInstancesSettings
         *        Updates to the self-managed AD configuration, including DNS server IP addresses and Amazon Web
         *        Services System Manager managed node identifiers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfManagedInstancesSettings(HybridCustomerInstancesSettings selfManagedInstancesSettings);

        /**
         * <p>
         * Updates to the self-managed AD configuration, including DNS server IP addresses and Amazon Web Services
         * System Manager managed node identifiers.
         * </p>
         * This is a convenience method that creates an instance of the {@link HybridCustomerInstancesSettings.Builder}
         * avoiding the need to create one manually via {@link HybridCustomerInstancesSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HybridCustomerInstancesSettings.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #selfManagedInstancesSettings(HybridCustomerInstancesSettings)}.
         * 
         * @param selfManagedInstancesSettings
         *        a consumer that will call methods on {@link HybridCustomerInstancesSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selfManagedInstancesSettings(HybridCustomerInstancesSettings)
         */
        default Builder selfManagedInstancesSettings(
                Consumer<HybridCustomerInstancesSettings.Builder> selfManagedInstancesSettings) {
            return selfManagedInstancesSettings(HybridCustomerInstancesSettings.builder()
                    .applyMutation(selfManagedInstancesSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate;

        private HybridCustomerInstancesSettings selfManagedInstancesSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHybridAdRequest model) {
            super(model);
            directoryId(model.directoryId);
            hybridAdministratorAccountUpdate(model.hybridAdministratorAccountUpdate);
            selfManagedInstancesSettings(model.selfManagedInstancesSettings);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final HybridAdministratorAccountUpdate.Builder getHybridAdministratorAccountUpdate() {
            return hybridAdministratorAccountUpdate != null ? hybridAdministratorAccountUpdate.toBuilder() : null;
        }

        public final void setHybridAdministratorAccountUpdate(
                HybridAdministratorAccountUpdate.BuilderImpl hybridAdministratorAccountUpdate) {
            this.hybridAdministratorAccountUpdate = hybridAdministratorAccountUpdate != null ? hybridAdministratorAccountUpdate
                    .build() : null;
        }

        @Override
        public final Builder hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate) {
            this.hybridAdministratorAccountUpdate = hybridAdministratorAccountUpdate;
            return this;
        }

        public final HybridCustomerInstancesSettings.Builder getSelfManagedInstancesSettings() {
            return selfManagedInstancesSettings != null ? selfManagedInstancesSettings.toBuilder() : null;
        }

        public final void setSelfManagedInstancesSettings(HybridCustomerInstancesSettings.BuilderImpl selfManagedInstancesSettings) {
            this.selfManagedInstancesSettings = selfManagedInstancesSettings != null ? selfManagedInstancesSettings.build()
                    : null;
        }

        @Override
        public final Builder selfManagedInstancesSettings(HybridCustomerInstancesSettings selfManagedInstancesSettings) {
            this.selfManagedInstancesSettings = selfManagedInstancesSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHybridAdRequest build() {
            return new UpdateHybridAdRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
