/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.AssessmentInstanceIdsCopier;
import software.amazon.awssdk.services.directory.model.CustomerDnsIpsCopier;
import software.amazon.awssdk.services.directory.model.SecurityGroupIdsCopier;
import software.amazon.awssdk.services.directory.model.SubnetIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Assessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Assessment> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentId").getter(Assessment.getter(Assessment::assessmentId)).setter(Assessment.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(Assessment.getter(Assessment::directoryId)).setter(Assessment.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(Assessment.getter(Assessment::dnsName)).setter(Assessment.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(Assessment.getter(Assessment::startTime)).setter(Assessment.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDateTime").getter(Assessment.getter(Assessment::lastUpdateDateTime)).setter(Assessment.setter(Builder::lastUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Assessment.getter(Assessment::status)).setter(Assessment.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusCode").getter(Assessment.getter(Assessment::statusCode)).setter(Assessment.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(Assessment.getter(Assessment::statusReason)).setter(Assessment.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerDnsIps").getter(Assessment.getter(Assessment::customerDnsIps)).setter(Assessment.setter(Builder::customerDnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Assessment.getter(Assessment::vpcId)).setter(Assessment.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SubnetIds").getter(Assessment.getter(Assessment::subnetIds)).setter(Assessment.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(Assessment.getter(Assessment::securityGroupIds)).setter(Assessment.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SELF_MANAGED_INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelfManagedInstanceIds").getter(Assessment.getter(Assessment::selfManagedInstanceIds)).setter(Assessment.setter(Builder::selfManagedInstanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedInstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportType").getter(Assessment.getter(Assessment::reportType)).setter(Assessment.setter(Builder::reportType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportType").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(Assessment.getter(Assessment::version)).setter(Assessment.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, DIRECTORY_ID_FIELD, DNS_NAME_FIELD, START_TIME_FIELD, LAST_UPDATE_DATE_TIME_FIELD, STATUS_FIELD, STATUS_CODE_FIELD, STATUS_REASON_FIELD, CUSTOMER_DNS_IPS_FIELD, VPC_ID_FIELD, SUBNET_IDS_FIELD, SECURITY_GROUP_IDS_FIELD, SELF_MANAGED_INSTANCE_IDS_FIELD, REPORT_TYPE_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Assessment.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assessmentId;
    private final String directoryId;
    private final String dnsName;
    private final Instant startTime;
    private final Instant lastUpdateDateTime;
    private final String status;
    private final String statusCode;
    private final String statusReason;
    private final List<String> customerDnsIps;
    private final String vpcId;
    private final List<String> subnetIds;
    private final List<String> securityGroupIds;
    private final List<String> selfManagedInstanceIds;
    private final String reportType;
    private final String version;

    private Assessment(BuilderImpl builder) {
        this.assessmentId = builder.assessmentId;
        this.directoryId = builder.directoryId;
        this.dnsName = builder.dnsName;
        this.startTime = builder.startTime;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.status = builder.status;
        this.statusCode = builder.statusCode;
        this.statusReason = builder.statusReason;
        this.customerDnsIps = builder.customerDnsIps;
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.securityGroupIds = builder.securityGroupIds;
        this.selfManagedInstanceIds = builder.selfManagedInstanceIds;
        this.reportType = builder.reportType;
        this.version = builder.version;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public final String status() {
        return this.status;
    }

    public final String statusCode() {
        return this.statusCode;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final boolean hasCustomerDnsIps() {
        return this.customerDnsIps != null && !(this.customerDnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> customerDnsIps() {
        return this.customerDnsIps;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final boolean hasSelfManagedInstanceIds() {
        return this.selfManagedInstanceIds != null && !(this.selfManagedInstanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> selfManagedInstanceIds() {
        return this.selfManagedInstanceIds;
    }

    public final String reportType() {
        return this.reportType;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerDnsIps() ? this.customerDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelfManagedInstanceIds() ? this.selfManagedInstanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportType());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Assessment)) {
            return false;
        }
        Assessment other = (Assessment)obj;
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateDateTime(), other.lastUpdateDateTime()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusCode(), other.statusCode()) && Objects.equals(this.statusReason(), other.statusReason()) && this.hasCustomerDnsIps() == other.hasCustomerDnsIps() && Objects.equals(this.customerDnsIps(), other.customerDnsIps()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && this.hasSelfManagedInstanceIds() == other.hasSelfManagedInstanceIds() && Objects.equals(this.selfManagedInstanceIds(), other.selfManagedInstanceIds()) && Objects.equals(this.reportType(), other.reportType()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"Assessment").add("AssessmentId", (Object)this.assessmentId()).add("DirectoryId", (Object)this.directoryId()).add("DnsName", (Object)this.dnsName()).add("StartTime", (Object)this.startTime()).add("LastUpdateDateTime", (Object)this.lastUpdateDateTime()).add("Status", (Object)this.status()).add("StatusCode", (Object)this.statusCode()).add("StatusReason", (Object)this.statusReason()).add("CustomerDnsIps", this.hasCustomerDnsIps() ? this.customerDnsIps() : null).add("VpcId", (Object)this.vpcId()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("SelfManagedInstanceIds", this.hasSelfManagedInstanceIds() ? this.selfManagedInstanceIds() : null).add("ReportType", (Object)this.reportType()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "LastUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCode()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "CustomerDnsIps": {
                return Optional.ofNullable(clazz.cast(this.customerDnsIps()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "SelfManagedInstanceIds": {
                return Optional.ofNullable(clazz.cast(this.selfManagedInstanceIds()));
            }
            case "ReportType": {
                return Optional.ofNullable(clazz.cast(this.reportType()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssessmentId", ASSESSMENT_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusCode", STATUS_CODE_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("CustomerDnsIps", CUSTOMER_DNS_IPS_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SubnetIds", SUBNET_IDS_FIELD);
        map.put("SecurityGroupIds", SECURITY_GROUP_IDS_FIELD);
        map.put("SelfManagedInstanceIds", SELF_MANAGED_INSTANCE_IDS_FIELD);
        map.put("ReportType", REPORT_TYPE_FIELD);
        map.put("Version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Assessment, T> g) {
        return obj -> g.apply((Assessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assessmentId;
        private String directoryId;
        private String dnsName;
        private Instant startTime;
        private Instant lastUpdateDateTime;
        private String status;
        private String statusCode;
        private String statusReason;
        private List<String> customerDnsIps = DefaultSdkAutoConstructList.getInstance();
        private String vpcId;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> selfManagedInstanceIds = DefaultSdkAutoConstructList.getInstance();
        private String reportType;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(Assessment model) {
            this.assessmentId(model.assessmentId);
            this.directoryId(model.directoryId);
            this.dnsName(model.dnsName);
            this.startTime(model.startTime);
            this.lastUpdateDateTime(model.lastUpdateDateTime);
            this.status(model.status);
            this.statusCode(model.statusCode);
            this.statusReason(model.statusReason);
            this.customerDnsIps(model.customerDnsIps);
            this.vpcId(model.vpcId);
            this.subnetIds(model.subnetIds);
            this.securityGroupIds(model.securityGroupIds);
            this.selfManagedInstanceIds(model.selfManagedInstanceIds);
            this.reportType(model.reportType);
            this.version(model.version);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdateDateTime() {
            return this.lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Collection<String> getCustomerDnsIps() {
            if (this.customerDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerDnsIps;
        }

        public final void setCustomerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
        }

        @Override
        public final Builder customerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIps(String ... customerDnsIps) {
            this.customerDnsIps(Arrays.asList(customerDnsIps));
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final Collection<String> getSelfManagedInstanceIds() {
            if (this.selfManagedInstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.selfManagedInstanceIds;
        }

        public final void setSelfManagedInstanceIds(Collection<String> selfManagedInstanceIds) {
            this.selfManagedInstanceIds = AssessmentInstanceIdsCopier.copy(selfManagedInstanceIds);
        }

        @Override
        public final Builder selfManagedInstanceIds(Collection<String> selfManagedInstanceIds) {
            this.selfManagedInstanceIds = AssessmentInstanceIdsCopier.copy(selfManagedInstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedInstanceIds(String ... selfManagedInstanceIds) {
            this.selfManagedInstanceIds(Arrays.asList(selfManagedInstanceIds));
            return this;
        }

        public final String getReportType() {
            return this.reportType;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public Assessment build() {
            return new Assessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Assessment> {
        public Builder assessmentId(String var1);

        public Builder directoryId(String var1);

        public Builder dnsName(String var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateDateTime(Instant var1);

        public Builder status(String var1);

        public Builder statusCode(String var1);

        public Builder statusReason(String var1);

        public Builder customerDnsIps(Collection<String> var1);

        public Builder customerDnsIps(String ... var1);

        public Builder vpcId(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder selfManagedInstanceIds(Collection<String> var1);

        public Builder selfManagedInstanceIds(String ... var1);

        public Builder reportType(String var1);

        public Builder version(String var1);
    }
}

