/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.HybridUpdateInfoEntriesCopier;
import software.amazon.awssdk.services.directory.model.HybridUpdateInfoEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HybridUpdateActivities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HybridUpdateActivities> {
    private static final SdkField<List<HybridUpdateInfoEntry>> SELF_MANAGED_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelfManagedInstances").getter(HybridUpdateActivities.getter(HybridUpdateActivities::selfManagedInstances)).setter(HybridUpdateActivities.setter(Builder::selfManagedInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HybridUpdateInfoEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HybridUpdateInfoEntry>> HYBRID_ADMINISTRATOR_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HybridAdministratorAccount").getter(HybridUpdateActivities.getter(HybridUpdateActivities::hybridAdministratorAccount)).setter(HybridUpdateActivities.setter(Builder::hybridAdministratorAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HybridAdministratorAccount").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HybridUpdateInfoEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELF_MANAGED_INSTANCES_FIELD, HYBRID_ADMINISTRATOR_ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HybridUpdateActivities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<HybridUpdateInfoEntry> selfManagedInstances;
    private final List<HybridUpdateInfoEntry> hybridAdministratorAccount;

    private HybridUpdateActivities(BuilderImpl builder) {
        this.selfManagedInstances = builder.selfManagedInstances;
        this.hybridAdministratorAccount = builder.hybridAdministratorAccount;
    }

    public final boolean hasSelfManagedInstances() {
        return this.selfManagedInstances != null && !(this.selfManagedInstances instanceof SdkAutoConstructList);
    }

    public final List<HybridUpdateInfoEntry> selfManagedInstances() {
        return this.selfManagedInstances;
    }

    public final boolean hasHybridAdministratorAccount() {
        return this.hybridAdministratorAccount != null && !(this.hybridAdministratorAccount instanceof SdkAutoConstructList);
    }

    public final List<HybridUpdateInfoEntry> hybridAdministratorAccount() {
        return this.hybridAdministratorAccount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelfManagedInstances() ? this.selfManagedInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHybridAdministratorAccount() ? this.hybridAdministratorAccount() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridUpdateActivities)) {
            return false;
        }
        HybridUpdateActivities other = (HybridUpdateActivities)obj;
        return this.hasSelfManagedInstances() == other.hasSelfManagedInstances() && Objects.equals(this.selfManagedInstances(), other.selfManagedInstances()) && this.hasHybridAdministratorAccount() == other.hasHybridAdministratorAccount() && Objects.equals(this.hybridAdministratorAccount(), other.hybridAdministratorAccount());
    }

    public final String toString() {
        return ToString.builder((String)"HybridUpdateActivities").add("SelfManagedInstances", this.hasSelfManagedInstances() ? this.selfManagedInstances() : null).add("HybridAdministratorAccount", this.hasHybridAdministratorAccount() ? this.hybridAdministratorAccount() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelfManagedInstances": {
                return Optional.ofNullable(clazz.cast(this.selfManagedInstances()));
            }
            case "HybridAdministratorAccount": {
                return Optional.ofNullable(clazz.cast(this.hybridAdministratorAccount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<HybridUpdateInfoEntry>>> map = new HashMap<String, SdkField<List<HybridUpdateInfoEntry>>>();
        map.put("SelfManagedInstances", SELF_MANAGED_INSTANCES_FIELD);
        map.put("HybridAdministratorAccount", HYBRID_ADMINISTRATOR_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridUpdateActivities, T> g) {
        return obj -> g.apply((HybridUpdateActivities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<HybridUpdateInfoEntry> selfManagedInstances = DefaultSdkAutoConstructList.getInstance();
        private List<HybridUpdateInfoEntry> hybridAdministratorAccount = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HybridUpdateActivities model) {
            this.selfManagedInstances(model.selfManagedInstances);
            this.hybridAdministratorAccount(model.hybridAdministratorAccount);
        }

        public final List<HybridUpdateInfoEntry.Builder> getSelfManagedInstances() {
            List<HybridUpdateInfoEntry.Builder> result = HybridUpdateInfoEntriesCopier.copyToBuilder(this.selfManagedInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelfManagedInstances(Collection<HybridUpdateInfoEntry.BuilderImpl> selfManagedInstances) {
            this.selfManagedInstances = HybridUpdateInfoEntriesCopier.copyFromBuilder(selfManagedInstances);
        }

        @Override
        public final Builder selfManagedInstances(Collection<HybridUpdateInfoEntry> selfManagedInstances) {
            this.selfManagedInstances = HybridUpdateInfoEntriesCopier.copy(selfManagedInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedInstances(HybridUpdateInfoEntry ... selfManagedInstances) {
            this.selfManagedInstances(Arrays.asList(selfManagedInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selfManagedInstances(Consumer<HybridUpdateInfoEntry.Builder> ... selfManagedInstances) {
            this.selfManagedInstances(Stream.of(selfManagedInstances).map(c -> (HybridUpdateInfoEntry)((HybridUpdateInfoEntry.Builder)HybridUpdateInfoEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HybridUpdateInfoEntry.Builder> getHybridAdministratorAccount() {
            List<HybridUpdateInfoEntry.Builder> result = HybridUpdateInfoEntriesCopier.copyToBuilder(this.hybridAdministratorAccount);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHybridAdministratorAccount(Collection<HybridUpdateInfoEntry.BuilderImpl> hybridAdministratorAccount) {
            this.hybridAdministratorAccount = HybridUpdateInfoEntriesCopier.copyFromBuilder(hybridAdministratorAccount);
        }

        @Override
        public final Builder hybridAdministratorAccount(Collection<HybridUpdateInfoEntry> hybridAdministratorAccount) {
            this.hybridAdministratorAccount = HybridUpdateInfoEntriesCopier.copy(hybridAdministratorAccount);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hybridAdministratorAccount(HybridUpdateInfoEntry ... hybridAdministratorAccount) {
            this.hybridAdministratorAccount(Arrays.asList(hybridAdministratorAccount));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hybridAdministratorAccount(Consumer<HybridUpdateInfoEntry.Builder> ... hybridAdministratorAccount) {
            this.hybridAdministratorAccount(Stream.of(hybridAdministratorAccount).map(c -> (HybridUpdateInfoEntry)((HybridUpdateInfoEntry.Builder)HybridUpdateInfoEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public HybridUpdateActivities build() {
            return new HybridUpdateActivities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HybridUpdateActivities> {
        public Builder selfManagedInstances(Collection<HybridUpdateInfoEntry> var1);

        public Builder selfManagedInstances(HybridUpdateInfoEntry ... var1);

        public Builder selfManagedInstances(Consumer<HybridUpdateInfoEntry.Builder> ... var1);

        public Builder hybridAdministratorAccount(Collection<HybridUpdateInfoEntry> var1);

        public Builder hybridAdministratorAccount(HybridUpdateInfoEntry ... var1);

        public Builder hybridAdministratorAccount(Consumer<HybridUpdateInfoEntry.Builder> ... var1);
    }
}

