/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.AssessmentSummary;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsRequest;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsResponse;

public class ListADAssessmentsPublisher
implements SdkPublisher<ListAdAssessmentsResponse> {
    private final DirectoryAsyncClient client;
    private final ListAdAssessmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListADAssessmentsPublisher(DirectoryAsyncClient client, ListAdAssessmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListADAssessmentsPublisher(DirectoryAsyncClient client, ListAdAssessmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAdAssessmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAdAssessmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssessmentSummary> assessments() {
        Function<ListAdAssessmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assessments() != null) {
                return response.assessments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAdAssessmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAdAssessmentsResponseFetcher
    implements AsyncPageFetcher<ListAdAssessmentsResponse> {
        private ListAdAssessmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAdAssessmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAdAssessmentsResponse> nextPage(ListAdAssessmentsResponse previousPage) {
            if (previousPage == null) {
                return ListADAssessmentsPublisher.this.client.listADAssessments(ListADAssessmentsPublisher.this.firstRequest);
            }
            return ListADAssessmentsPublisher.this.client.listADAssessments((ListAdAssessmentsRequest)((Object)ListADAssessmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

