/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateRequest;
import software.amazon.awssdk.services.directory.model.DescribeHybridAdUpdateResponse;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.waiters.DirectoryAsyncWaiter;
import software.amazon.awssdk.services.directory.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultDirectoryAsyncWaiter
implements DirectoryAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final DirectoryAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeHybridAdUpdateResponse> hybridADUpdatedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultDirectoryAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (DirectoryAsyncClient)DirectoryAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.hybridADUpdatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeHybridAdUpdateResponse.class).acceptors(DefaultDirectoryAsyncWaiter.hybridADUpdatedWaiterAcceptors())).overrideConfiguration(DefaultDirectoryAsyncWaiter.hybridADUpdatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeHybridAdUpdateResponse>> waitUntilHybridADUpdated(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest) {
        return this.hybridADUpdatedWaiter.runAsync(() -> this.client.describeHybridADUpdate(this.applyWaitersUserAgent(describeHybridAdUpdateRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeHybridAdUpdateResponse>> waitUntilHybridADUpdated(DescribeHybridAdUpdateRequest describeHybridAdUpdateRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.hybridADUpdatedWaiter.runAsync(() -> this.client.describeHybridADUpdate(this.applyWaitersUserAgent(describeHybridAdUpdateRequest)), DefaultDirectoryAsyncWaiter.hybridADUpdatedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeHybridAdUpdateResponse>> hybridADUpdatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeHybridAdUpdateResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeHybridAdUpdateResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("UpdateActivities").field("SelfManagedInstances").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Updated"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("UpdateActivities").field("SelfManagedInstances").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "UpdateFailed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (UpdateActivities.SelfManagedInstances[].Status=UpdateFailed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration hybridADUpdatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(120L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static DirectoryAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends DirectoryRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DirectoryRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements DirectoryAsyncWaiter.Builder {
        private DirectoryAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public DirectoryAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public DirectoryAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public DirectoryAsyncWaiter.Builder client(DirectoryAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public DirectoryAsyncWaiter build() {
            return new DefaultDirectoryAsyncWaiter(this);
        }
    }
}

