/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.TopicStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EventTopic
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EventTopic> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(EventTopic.getter(EventTopic::directoryId)).setter(EventTopic.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(EventTopic.getter(EventTopic::topicName)).setter(EventTopic.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicName").build()}).build();
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(EventTopic.getter(EventTopic::topicArn)).setter(EventTopic.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicArn").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedDateTime").getter(EventTopic.getter(EventTopic::createdDateTime)).setter(EventTopic.setter(Builder::createdDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(EventTopic.getter(EventTopic::statusAsString)).setter(EventTopic.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, TOPIC_NAME_FIELD, TOPIC_ARN_FIELD, CREATED_DATE_TIME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EventTopic.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String topicName;
    private final String topicArn;
    private final Instant createdDateTime;
    private final String status;

    private EventTopic(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.topicName = builder.topicName;
        this.topicArn = builder.topicArn;
        this.createdDateTime = builder.createdDateTime;
        this.status = builder.status;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final Instant createdDateTime() {
        return this.createdDateTime;
    }

    public final TopicStatus status() {
        return TopicStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventTopic)) {
            return false;
        }
        EventTopic other = (EventTopic)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.createdDateTime(), other.createdDateTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"EventTopic").add("DirectoryId", (Object)this.directoryId()).add("TopicName", (Object)this.topicName()).add("TopicArn", (Object)this.topicArn()).add("CreatedDateTime", (Object)this.createdDateTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "CreatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.createdDateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("TopicName", TOPIC_NAME_FIELD);
        map.put("TopicArn", TOPIC_ARN_FIELD);
        map.put("CreatedDateTime", CREATED_DATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EventTopic, T> g) {
        return obj -> g.apply((EventTopic)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String topicName;
        private String topicArn;
        private Instant createdDateTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(EventTopic model) {
            this.directoryId(model.directoryId);
            this.topicName(model.topicName);
            this.topicArn(model.topicArn);
            this.createdDateTime(model.createdDateTime);
            this.status(model.status);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final Instant getCreatedDateTime() {
            return this.createdDateTime;
        }

        public final void setCreatedDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
        }

        @Override
        public final Builder createdDateTime(Instant createdDateTime) {
            this.createdDateTime = createdDateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public EventTopic build() {
            return new EventTopic(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EventTopic> {
        public Builder directoryId(String var1);

        public Builder topicName(String var1);

        public Builder topicArn(String var1);

        public Builder createdDateTime(Instant var1);

        public Builder status(String var1);

        public Builder status(TopicStatus var1);
    }
}

