/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.HybridUpdateValue;
import software.amazon.awssdk.services.directory.model.UpdateStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HybridUpdateInfoEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HybridUpdateInfoEntry> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::statusAsString)).setter(HybridUpdateInfoEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusReason").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::statusReason)).setter(HybridUpdateInfoEntry.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()}).build();
    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitiatedBy").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::initiatedBy)).setter(HybridUpdateInfoEntry.setter(Builder::initiatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()}).build();
    private static final SdkField<HybridUpdateValue> NEW_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NewValue").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::newValue)).setter(HybridUpdateInfoEntry.setter(Builder::newValue)).constructor(HybridUpdateValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()}).build();
    private static final SdkField<HybridUpdateValue> PREVIOUS_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PreviousValue").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::previousValue)).setter(HybridUpdateInfoEntry.setter(Builder::previousValue)).constructor(HybridUpdateValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValue").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::startTime)).setter(HybridUpdateInfoEntry.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedDateTime").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::lastUpdatedDateTime)).setter(HybridUpdateInfoEntry.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build()}).build();
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentId").getter(HybridUpdateInfoEntry.getter(HybridUpdateInfoEntry::assessmentId)).setter(HybridUpdateInfoEntry.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, STATUS_REASON_FIELD, INITIATED_BY_FIELD, NEW_VALUE_FIELD, PREVIOUS_VALUE_FIELD, START_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD, ASSESSMENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HybridUpdateInfoEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String status;
    private final String statusReason;
    private final String initiatedBy;
    private final HybridUpdateValue newValue;
    private final HybridUpdateValue previousValue;
    private final Instant startTime;
    private final Instant lastUpdatedDateTime;
    private final String assessmentId;

    private HybridUpdateInfoEntry(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.initiatedBy = builder.initiatedBy;
        this.newValue = builder.newValue;
        this.previousValue = builder.previousValue;
        this.startTime = builder.startTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.assessmentId = builder.assessmentId;
    }

    public final UpdateStatus status() {
        return UpdateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String initiatedBy() {
        return this.initiatedBy;
    }

    public final HybridUpdateValue newValue() {
        return this.newValue;
    }

    public final HybridUpdateValue previousValue() {
        return this.previousValue;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.newValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.previousValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridUpdateInfoEntry)) {
            return false;
        }
        HybridUpdateInfoEntry other = (HybridUpdateInfoEntry)obj;
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.initiatedBy(), other.initiatedBy()) && Objects.equals(this.newValue(), other.newValue()) && Objects.equals(this.previousValue(), other.previousValue()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime()) && Objects.equals(this.assessmentId(), other.assessmentId());
    }

    public final String toString() {
        return ToString.builder((String)"HybridUpdateInfoEntry").add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("InitiatedBy", (Object)this.initiatedBy()).add("NewValue", (Object)this.newValue()).add("PreviousValue", (Object)this.previousValue()).add("StartTime", (Object)this.startTime()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).add("AssessmentId", (Object)this.assessmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "InitiatedBy": {
                return Optional.ofNullable(clazz.cast(this.initiatedBy()));
            }
            case "NewValue": {
                return Optional.ofNullable(clazz.cast(this.newValue()));
            }
            case "PreviousValue": {
                return Optional.ofNullable(clazz.cast(this.previousValue()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "LastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
            case "AssessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("InitiatedBy", INITIATED_BY_FIELD);
        map.put("NewValue", NEW_VALUE_FIELD);
        map.put("PreviousValue", PREVIOUS_VALUE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("AssessmentId", ASSESSMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridUpdateInfoEntry, T> g) {
        return obj -> g.apply((HybridUpdateInfoEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String status;
        private String statusReason;
        private String initiatedBy;
        private HybridUpdateValue newValue;
        private HybridUpdateValue previousValue;
        private Instant startTime;
        private Instant lastUpdatedDateTime;
        private String assessmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(HybridUpdateInfoEntry model) {
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.initiatedBy(model.initiatedBy);
            this.newValue(model.newValue);
            this.previousValue(model.previousValue);
            this.startTime(model.startTime);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
            this.assessmentId(model.assessmentId);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getInitiatedBy() {
            return this.initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        public final HybridUpdateValue.Builder getNewValue() {
            return this.newValue != null ? this.newValue.toBuilder() : null;
        }

        public final void setNewValue(HybridUpdateValue.BuilderImpl newValue) {
            this.newValue = newValue != null ? newValue.build() : null;
        }

        @Override
        public final Builder newValue(HybridUpdateValue newValue) {
            this.newValue = newValue;
            return this;
        }

        public final HybridUpdateValue.Builder getPreviousValue() {
            return this.previousValue != null ? this.previousValue.toBuilder() : null;
        }

        public final void setPreviousValue(HybridUpdateValue.BuilderImpl previousValue) {
            this.previousValue = previousValue != null ? previousValue.build() : null;
        }

        @Override
        public final Builder previousValue(HybridUpdateValue previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public HybridUpdateInfoEntry build() {
            return new HybridUpdateInfoEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HybridUpdateInfoEntry> {
        public Builder status(String var1);

        public Builder status(UpdateStatus var1);

        public Builder statusReason(String var1);

        public Builder initiatedBy(String var1);

        public Builder newValue(HybridUpdateValue var1);

        default public Builder newValue(Consumer<HybridUpdateValue.Builder> newValue) {
            return this.newValue((HybridUpdateValue)((HybridUpdateValue.Builder)HybridUpdateValue.builder().applyMutation(newValue)).build());
        }

        public Builder previousValue(HybridUpdateValue var1);

        default public Builder previousValue(Consumer<HybridUpdateValue.Builder> previousValue) {
            return this.previousValue((HybridUpdateValue)((HybridUpdateValue.Builder)HybridUpdateValue.builder().applyMutation(previousValue)).build());
        }

        public Builder startTime(Instant var1);

        public Builder lastUpdatedDateTime(Instant var1);

        public Builder assessmentId(String var1);
    }
}

