/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryClient;
import software.amazon.awssdk.services.directory.internal.UserAgentUtils;
import software.amazon.awssdk.services.directory.model.AssessmentSummary;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsRequest;
import software.amazon.awssdk.services.directory.model.ListAdAssessmentsResponse;

public class ListADAssessmentsIterable
implements SdkIterable<ListAdAssessmentsResponse> {
    private final DirectoryClient client;
    private final ListAdAssessmentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListADAssessmentsIterable(DirectoryClient client, ListAdAssessmentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAdAssessmentsResponseFetcher();
    }

    public Iterator<ListAdAssessmentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssessmentSummary> assessments() {
        Function<ListAdAssessmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assessments() != null) {
                return response.assessments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAdAssessmentsResponseFetcher
    implements SyncPageFetcher<ListAdAssessmentsResponse> {
        private ListAdAssessmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListAdAssessmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAdAssessmentsResponse nextPage(ListAdAssessmentsResponse previousPage) {
            if (previousPage == null) {
                return ListADAssessmentsIterable.this.client.listADAssessments(ListADAssessmentsIterable.this.firstRequest);
            }
            return ListADAssessmentsIterable.this.client.listADAssessments((ListAdAssessmentsRequest)((Object)ListADAssessmentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

