/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.CidrIpsCopier;
import software.amazon.awssdk.services.directory.model.CidrIpv6sCopier;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveIpRoutesRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, RemoveIpRoutesRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(RemoveIpRoutesRequest.getter(RemoveIpRoutesRequest::directoryId)).setter(RemoveIpRoutesRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> CIDR_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrIps").getter(RemoveIpRoutesRequest.getter(RemoveIpRoutesRequest::cidrIps)).setter(RemoveIpRoutesRequest.setter(Builder::cidrIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CIDR_IPV6_S_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CidrIpv6s").getter(RemoveIpRoutesRequest.getter(RemoveIpRoutesRequest::cidrIpv6s)).setter(RemoveIpRoutesRequest.setter(Builder::cidrIpv6s)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6s").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, CIDR_IPS_FIELD, CIDR_IPV6_S_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveIpRoutesRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final List<String> cidrIps;
    private final List<String> cidrIpv6s;

    private RemoveIpRoutesRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.cidrIps = builder.cidrIps;
        this.cidrIpv6s = builder.cidrIpv6s;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasCidrIps() {
        return this.cidrIps != null && !(this.cidrIps instanceof SdkAutoConstructList);
    }

    public final List<String> cidrIps() {
        return this.cidrIps;
    }

    public final boolean hasCidrIpv6s() {
        return this.cidrIpv6s != null && !(this.cidrIpv6s instanceof SdkAutoConstructList);
    }

    public final List<String> cidrIpv6s() {
        return this.cidrIpv6s;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrIps() ? this.cidrIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCidrIpv6s() ? this.cidrIpv6s() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveIpRoutesRequest)) {
            return false;
        }
        RemoveIpRoutesRequest other = (RemoveIpRoutesRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasCidrIps() == other.hasCidrIps() && Objects.equals(this.cidrIps(), other.cidrIps()) && this.hasCidrIpv6s() == other.hasCidrIpv6s() && Objects.equals(this.cidrIpv6s(), other.cidrIpv6s());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveIpRoutesRequest").add("DirectoryId", (Object)this.directoryId()).add("CidrIps", this.hasCidrIps() ? this.cidrIps() : null).add("CidrIpv6s", this.hasCidrIpv6s() ? this.cidrIpv6s() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "CidrIps": {
                return Optional.ofNullable(clazz.cast(this.cidrIps()));
            }
            case "CidrIpv6s": {
                return Optional.ofNullable(clazz.cast(this.cidrIpv6s()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("CidrIps", CIDR_IPS_FIELD);
        map.put("CidrIpv6s", CIDR_IPV6_S_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveIpRoutesRequest, T> g) {
        return obj -> g.apply((RemoveIpRoutesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> cidrIps = DefaultSdkAutoConstructList.getInstance();
        private List<String> cidrIpv6s = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveIpRoutesRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.cidrIps(model.cidrIps);
            this.cidrIpv6s(model.cidrIpv6s);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getCidrIps() {
            if (this.cidrIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrIps;
        }

        public final void setCidrIps(Collection<String> cidrIps) {
            this.cidrIps = CidrIpsCopier.copy(cidrIps);
        }

        @Override
        public final Builder cidrIps(Collection<String> cidrIps) {
            this.cidrIps = CidrIpsCopier.copy(cidrIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrIps(String ... cidrIps) {
            this.cidrIps(Arrays.asList(cidrIps));
            return this;
        }

        public final Collection<String> getCidrIpv6s() {
            if (this.cidrIpv6s instanceof SdkAutoConstructList) {
                return null;
            }
            return this.cidrIpv6s;
        }

        public final void setCidrIpv6s(Collection<String> cidrIpv6s) {
            this.cidrIpv6s = CidrIpv6sCopier.copy(cidrIpv6s);
        }

        @Override
        public final Builder cidrIpv6s(Collection<String> cidrIpv6s) {
            this.cidrIpv6s = CidrIpv6sCopier.copy(cidrIpv6s);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cidrIpv6s(String ... cidrIpv6s) {
            this.cidrIpv6s(Arrays.asList(cidrIpv6s));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveIpRoutesRequest build() {
            return new RemoveIpRoutesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveIpRoutesRequest> {
        public Builder directoryId(String var1);

        public Builder cidrIps(Collection<String> var1);

        public Builder cidrIps(String ... var1);

        public Builder cidrIpv6s(Collection<String> var1);

        public Builder cidrIpv6s(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

