/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the <a>DescribeCAEnrollmentPolicy</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCaEnrollmentPolicyResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeCaEnrollmentPolicyResponse.Builder, DescribeCaEnrollmentPolicyResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeCaEnrollmentPolicyResponse::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> PCA_CONNECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PcaConnectorArn").getter(getter(DescribeCaEnrollmentPolicyResponse::pcaConnectorArn))
            .setter(setter(Builder::pcaConnectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PcaConnectorArn").build()).build();

    private static final SdkField<String> CA_ENROLLMENT_POLICY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaEnrollmentPolicyStatus")
            .getter(getter(DescribeCaEnrollmentPolicyResponse::caEnrollmentPolicyStatusAsString))
            .setter(setter(Builder::caEnrollmentPolicyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaEnrollmentPolicyStatus").build())
            .build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDateTime").getter(getter(DescribeCaEnrollmentPolicyResponse::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> CA_ENROLLMENT_POLICY_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CaEnrollmentPolicyStatusReason")
            .getter(getter(DescribeCaEnrollmentPolicyResponse::caEnrollmentPolicyStatusReason))
            .setter(setter(Builder::caEnrollmentPolicyStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaEnrollmentPolicyStatusReason")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            PCA_CONNECTOR_ARN_FIELD, CA_ENROLLMENT_POLICY_STATUS_FIELD, LAST_UPDATED_DATE_TIME_FIELD,
            CA_ENROLLMENT_POLICY_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String pcaConnectorArn;

    private final String caEnrollmentPolicyStatus;

    private final Instant lastUpdatedDateTime;

    private final String caEnrollmentPolicyStatusReason;

    private DescribeCaEnrollmentPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.pcaConnectorArn = builder.pcaConnectorArn;
        this.caEnrollmentPolicyStatus = builder.caEnrollmentPolicyStatus;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.caEnrollmentPolicyStatusReason = builder.caEnrollmentPolicyStatusReason;
    }

    /**
     * <p>
     * The identifier of the directory associated with this CA enrollment policy.
     * </p>
     * 
     * @return The identifier of the directory associated with this CA enrollment policy.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Web Services Private Certificate Authority (PCA) connector that is
     * configured for automatic certificate enrollment in this directory.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Web Services Private Certificate Authority (PCA) connector
     *         that is configured for automatic certificate enrollment in this directory.
     */
    public final String pcaConnectorArn() {
        return pcaConnectorArn;
    }

    /**
     * <p>
     * The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is currently
     * active, inactive, or in a transitional state.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The policy is being activated T
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The policy activation or deactivation failed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - The policy is being deactivated
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> - Network connectivity is impaired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #caEnrollmentPolicyStatus} will return {@link CaEnrollmentPolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #caEnrollmentPolicyStatusAsString}.
     * </p>
     * 
     * @return The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is
     *         currently active, inactive, or in a transitional state.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The policy is being activated T
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The policy activation or deactivation failed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - The policy is being deactivated
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> - Network connectivity is impaired.
     *         </p>
     *         </li>
     * @see CaEnrollmentPolicyStatus
     */
    public final CaEnrollmentPolicyStatus caEnrollmentPolicyStatus() {
        return CaEnrollmentPolicyStatus.fromValue(caEnrollmentPolicyStatus);
    }

    /**
     * <p>
     * The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is currently
     * active, inactive, or in a transitional state.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The policy is being activated T
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - The policy activation or deactivation failed
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLING</code> - The policy is being deactivated
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IMPAIRED</code> - Network connectivity is impaired.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #caEnrollmentPolicyStatus} will return {@link CaEnrollmentPolicyStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #caEnrollmentPolicyStatusAsString}.
     * </p>
     * 
     * @return The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is
     *         currently active, inactive, or in a transitional state.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The policy is being activated T
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - The policy activation or deactivation failed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLING</code> - The policy is being deactivated
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IMPAIRED</code> - Network connectivity is impaired.
     *         </p>
     *         </li>
     * @see CaEnrollmentPolicyStatus
     */
    public final String caEnrollmentPolicyStatusAsString() {
        return caEnrollmentPolicyStatus;
    }

    /**
     * <p>
     * The date and time when the CA enrollment policy was last modified or updated.
     * </p>
     * 
     * @return The date and time when the CA enrollment policy was last modified or updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * Additional information explaining the current status of the CA enrollment policy, particularly useful when the
     * policy is in an error or transitional state.
     * </p>
     * 
     * @return Additional information explaining the current status of the CA enrollment policy, particularly useful
     *         when the policy is in an error or transitional state.
     */
    public final String caEnrollmentPolicyStatusReason() {
        return caEnrollmentPolicyStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(pcaConnectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(caEnrollmentPolicyStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(caEnrollmentPolicyStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCaEnrollmentPolicyResponse)) {
            return false;
        }
        DescribeCaEnrollmentPolicyResponse other = (DescribeCaEnrollmentPolicyResponse) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(pcaConnectorArn(), other.pcaConnectorArn())
                && Objects.equals(caEnrollmentPolicyStatusAsString(), other.caEnrollmentPolicyStatusAsString())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(caEnrollmentPolicyStatusReason(), other.caEnrollmentPolicyStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCaEnrollmentPolicyResponse").add("DirectoryId", directoryId())
                .add("PcaConnectorArn", pcaConnectorArn()).add("CaEnrollmentPolicyStatus", caEnrollmentPolicyStatusAsString())
                .add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("CaEnrollmentPolicyStatusReason", caEnrollmentPolicyStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "PcaConnectorArn":
            return Optional.ofNullable(clazz.cast(pcaConnectorArn()));
        case "CaEnrollmentPolicyStatus":
            return Optional.ofNullable(clazz.cast(caEnrollmentPolicyStatusAsString()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "CaEnrollmentPolicyStatusReason":
            return Optional.ofNullable(clazz.cast(caEnrollmentPolicyStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("PcaConnectorArn", PCA_CONNECTOR_ARN_FIELD);
        map.put("CaEnrollmentPolicyStatus", CA_ENROLLMENT_POLICY_STATUS_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("CaEnrollmentPolicyStatusReason", CA_ENROLLMENT_POLICY_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCaEnrollmentPolicyResponse, T> g) {
        return obj -> g.apply((DescribeCaEnrollmentPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCaEnrollmentPolicyResponse> {
        /**
         * <p>
         * The identifier of the directory associated with this CA enrollment policy.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory associated with this CA enrollment policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Web Services Private Certificate Authority (PCA) connector that
         * is configured for automatic certificate enrollment in this directory.
         * </p>
         * 
         * @param pcaConnectorArn
         *        The Amazon Resource Name (ARN) of the Amazon Web Services Private Certificate Authority (PCA)
         *        connector that is configured for automatic certificate enrollment in this directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pcaConnectorArn(String pcaConnectorArn);

        /**
         * <p>
         * The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is
         * currently active, inactive, or in a transitional state.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The policy is being activated T
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The policy activation or deactivation failed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - The policy is being deactivated
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> - Network connectivity is impaired.
         * </p>
         * </li>
         * </ul>
         * 
         * @param caEnrollmentPolicyStatus
         *        The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is
         *        currently active, inactive, or in a transitional state.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The policy is being activated T
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The policy activation or deactivation failed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - The policy is being deactivated
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> - Network connectivity is impaired.
         *        </p>
         *        </li>
         * @see CaEnrollmentPolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaEnrollmentPolicyStatus
         */
        Builder caEnrollmentPolicyStatus(String caEnrollmentPolicyStatus);

        /**
         * <p>
         * The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is
         * currently active, inactive, or in a transitional state.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The policy is being activated T
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - The policy activation or deactivation failed
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLING</code> - The policy is being deactivated
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IMPAIRED</code> - Network connectivity is impaired.
         * </p>
         * </li>
         * </ul>
         * 
         * @param caEnrollmentPolicyStatus
         *        The current status of the CA enrollment policy. This indicates if automatic certificate enrollment is
         *        currently active, inactive, or in a transitional state.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The policy is being activated T
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code> - The policy is active and automatic certificate enrollment is operational
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - The policy activation or deactivation failed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLING</code> - The policy is being deactivated
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - The policy is inactive and automatic certificate enrollment is not available
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IMPAIRED</code> - Network connectivity is impaired.
         *        </p>
         *        </li>
         * @see CaEnrollmentPolicyStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaEnrollmentPolicyStatus
         */
        Builder caEnrollmentPolicyStatus(CaEnrollmentPolicyStatus caEnrollmentPolicyStatus);

        /**
         * <p>
         * The date and time when the CA enrollment policy was last modified or updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time when the CA enrollment policy was last modified or updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * Additional information explaining the current status of the CA enrollment policy, particularly useful when
         * the policy is in an error or transitional state.
         * </p>
         * 
         * @param caEnrollmentPolicyStatusReason
         *        Additional information explaining the current status of the CA enrollment policy, particularly useful
         *        when the policy is in an error or transitional state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caEnrollmentPolicyStatusReason(String caEnrollmentPolicyStatusReason);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String directoryId;

        private String pcaConnectorArn;

        private String caEnrollmentPolicyStatus;

        private Instant lastUpdatedDateTime;

        private String caEnrollmentPolicyStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCaEnrollmentPolicyResponse model) {
            super(model);
            directoryId(model.directoryId);
            pcaConnectorArn(model.pcaConnectorArn);
            caEnrollmentPolicyStatus(model.caEnrollmentPolicyStatus);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            caEnrollmentPolicyStatusReason(model.caEnrollmentPolicyStatusReason);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getPcaConnectorArn() {
            return pcaConnectorArn;
        }

        public final void setPcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
        }

        @Override
        public final Builder pcaConnectorArn(String pcaConnectorArn) {
            this.pcaConnectorArn = pcaConnectorArn;
            return this;
        }

        public final String getCaEnrollmentPolicyStatus() {
            return caEnrollmentPolicyStatus;
        }

        public final void setCaEnrollmentPolicyStatus(String caEnrollmentPolicyStatus) {
            this.caEnrollmentPolicyStatus = caEnrollmentPolicyStatus;
        }

        @Override
        public final Builder caEnrollmentPolicyStatus(String caEnrollmentPolicyStatus) {
            this.caEnrollmentPolicyStatus = caEnrollmentPolicyStatus;
            return this;
        }

        @Override
        public final Builder caEnrollmentPolicyStatus(CaEnrollmentPolicyStatus caEnrollmentPolicyStatus) {
            this.caEnrollmentPolicyStatus(caEnrollmentPolicyStatus == null ? null : caEnrollmentPolicyStatus.toString());
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getCaEnrollmentPolicyStatusReason() {
            return caEnrollmentPolicyStatusReason;
        }

        public final void setCaEnrollmentPolicyStatusReason(String caEnrollmentPolicyStatusReason) {
            this.caEnrollmentPolicyStatusReason = caEnrollmentPolicyStatusReason;
        }

        @Override
        public final Builder caEnrollmentPolicyStatusReason(String caEnrollmentPolicyStatusReason) {
            this.caEnrollmentPolicyStatusReason = caEnrollmentPolicyStatusReason;
            return this;
        }

        @Override
        public DescribeCaEnrollmentPolicyResponse build() {
            return new DescribeCaEnrollmentPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
