/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDirectoryDataAccessResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeDirectoryDataAccessResponse.Builder, DescribeDirectoryDataAccessResponse> {
    private static final SdkField<String> DATA_ACCESS_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataAccessStatus").getter(getter(DescribeDirectoryDataAccessResponse::dataAccessStatusAsString))
            .setter(setter(Builder::dataAccessStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ACCESS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataAccessStatus;

    private DescribeDirectoryDataAccessResponse(BuilderImpl builder) {
        super(builder);
        this.dataAccessStatus = builder.dataAccessStatus;
    }

    /**
     * <p>
     * The current status of data access through the Directory Service Data API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataAccessStatus}
     * will return {@link DataAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataAccessStatusAsString}.
     * </p>
     * 
     * @return The current status of data access through the Directory Service Data API.
     * @see DataAccessStatus
     */
    public final DataAccessStatus dataAccessStatus() {
        return DataAccessStatus.fromValue(dataAccessStatus);
    }

    /**
     * <p>
     * The current status of data access through the Directory Service Data API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dataAccessStatus}
     * will return {@link DataAccessStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dataAccessStatusAsString}.
     * </p>
     * 
     * @return The current status of data access through the Directory Service Data API.
     * @see DataAccessStatus
     */
    public final String dataAccessStatusAsString() {
        return dataAccessStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectoryDataAccessResponse)) {
            return false;
        }
        DescribeDirectoryDataAccessResponse other = (DescribeDirectoryDataAccessResponse) obj;
        return Objects.equals(dataAccessStatusAsString(), other.dataAccessStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDirectoryDataAccessResponse").add("DataAccessStatus", dataAccessStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataAccessStatus":
            return Optional.ofNullable(clazz.cast(dataAccessStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataAccessStatus", DATA_ACCESS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectoryDataAccessResponse, T> g) {
        return obj -> g.apply((DescribeDirectoryDataAccessResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDirectoryDataAccessResponse> {
        /**
         * <p>
         * The current status of data access through the Directory Service Data API.
         * </p>
         * 
         * @param dataAccessStatus
         *        The current status of data access through the Directory Service Data API.
         * @see DataAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAccessStatus
         */
        Builder dataAccessStatus(String dataAccessStatus);

        /**
         * <p>
         * The current status of data access through the Directory Service Data API.
         * </p>
         * 
         * @param dataAccessStatus
         *        The current status of data access through the Directory Service Data API.
         * @see DataAccessStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataAccessStatus
         */
        Builder dataAccessStatus(DataAccessStatus dataAccessStatus);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String dataAccessStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectoryDataAccessResponse model) {
            super(model);
            dataAccessStatus(model.dataAccessStatus);
        }

        public final String getDataAccessStatus() {
            return dataAccessStatus;
        }

        public final void setDataAccessStatus(String dataAccessStatus) {
            this.dataAccessStatus = dataAccessStatus;
        }

        @Override
        public final Builder dataAccessStatus(String dataAccessStatus) {
            this.dataAccessStatus = dataAccessStatus;
            return this;
        }

        @Override
        public final Builder dataAccessStatus(DataAccessStatus dataAccessStatus) {
            this.dataAccessStatus(dataAccessStatus == null ? null : dataAccessStatus.toString());
            return this;
        }

        @Override
        public DescribeDirectoryDataAccessResponse build() {
            return new DescribeDirectoryDataAccessResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
