/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSettingsResponse extends DirectoryResponse implements
        ToCopyableBuilder<DescribeSettingsResponse.Builder, DescribeSettingsResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(DescribeSettingsResponse::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<SettingEntry>> SETTING_ENTRIES_FIELD = SdkField
            .<List<SettingEntry>> builder(MarshallingType.LIST)
            .memberName("SettingEntries")
            .getter(getter(DescribeSettingsResponse::settingEntries))
            .setter(setter(Builder::settingEntries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingEntries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SettingEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(SettingEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeSettingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            SETTING_ENTRIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final List<SettingEntry> settingEntries;

    private final String nextToken;

    private DescribeSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.settingEntries = builder.settingEntries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The identifier of the directory.
     * </p>
     * 
     * @return The identifier of the directory.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SettingEntries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSettingEntries() {
        return settingEntries != null && !(settingEntries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <a>SettingEntry</a> objects that were retrieved.
     * </p>
     * <p>
     * It is possible that this list contains less than the number of items specified in the <code>Limit</code> member
     * of the request. This occurs if there are less than the requested number of items left to retrieve, or if the
     * limitations of the operation have been exceeded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSettingEntries} method.
     * </p>
     * 
     * @return The list of <a>SettingEntry</a> objects that were retrieved.</p>
     *         <p>
     *         It is possible that this list contains less than the number of items specified in the <code>Limit</code>
     *         member of the request. This occurs if there are less than the requested number of items left to retrieve,
     *         or if the limitations of the operation have been exceeded.
     */
    public final List<SettingEntry> settingEntries() {
        return settingEntries;
    }

    /**
     * <p>
     * If not null, token that indicates that more results are available. Pass this value for the <code>NextToken</code>
     * parameter in a subsequent call to <code>DescribeSettings</code> to retrieve the next set of items.
     * </p>
     * 
     * @return If not null, token that indicates that more results are available. Pass this value for the
     *         <code>NextToken</code> parameter in a subsequent call to <code>DescribeSettings</code> to retrieve the
     *         next set of items.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSettingEntries() ? settingEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSettingsResponse)) {
            return false;
        }
        DescribeSettingsResponse other = (DescribeSettingsResponse) obj;
        return Objects.equals(directoryId(), other.directoryId()) && hasSettingEntries() == other.hasSettingEntries()
                && Objects.equals(settingEntries(), other.settingEntries()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSettingsResponse").add("DirectoryId", directoryId())
                .add("SettingEntries", hasSettingEntries() ? settingEntries() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "SettingEntries":
            return Optional.ofNullable(clazz.cast(settingEntries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("SettingEntries", SETTING_ENTRIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSettingsResponse, T> g) {
        return obj -> g.apply((DescribeSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSettingsResponse> {
        /**
         * <p>
         * The identifier of the directory.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The list of <a>SettingEntry</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * 
         * @param settingEntries
         *        The list of <a>SettingEntry</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the
         *        <code>Limit</code> member of the request. This occurs if there are less than the requested number of
         *        items left to retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingEntries(Collection<SettingEntry> settingEntries);

        /**
         * <p>
         * The list of <a>SettingEntry</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * 
         * @param settingEntries
         *        The list of <a>SettingEntry</a> objects that were retrieved.</p>
         *        <p>
         *        It is possible that this list contains less than the number of items specified in the
         *        <code>Limit</code> member of the request. This occurs if there are less than the requested number of
         *        items left to retrieve, or if the limitations of the operation have been exceeded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingEntries(SettingEntry... settingEntries);

        /**
         * <p>
         * The list of <a>SettingEntry</a> objects that were retrieved.
         * </p>
         * <p>
         * It is possible that this list contains less than the number of items specified in the <code>Limit</code>
         * member of the request. This occurs if there are less than the requested number of items left to retrieve, or
         * if the limitations of the operation have been exceeded.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directory.model.SettingEntry.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.directory.model.SettingEntry#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directory.model.SettingEntry.Builder#build()} is called immediately
         * and its result is passed to {@link #settingEntries(List<SettingEntry>)}.
         * 
         * @param settingEntries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directory.model.SettingEntry.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #settingEntries(java.util.Collection<SettingEntry>)
         */
        Builder settingEntries(Consumer<SettingEntry.Builder>... settingEntries);

        /**
         * <p>
         * If not null, token that indicates that more results are available. Pass this value for the
         * <code>NextToken</code> parameter in a subsequent call to <code>DescribeSettings</code> to retrieve the next
         * set of items.
         * </p>
         * 
         * @param nextToken
         *        If not null, token that indicates that more results are available. Pass this value for the
         *        <code>NextToken</code> parameter in a subsequent call to <code>DescribeSettings</code> to retrieve the
         *        next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String directoryId;

        private List<SettingEntry> settingEntries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSettingsResponse model) {
            super(model);
            directoryId(model.directoryId);
            settingEntries(model.settingEntries);
            nextToken(model.nextToken);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final List<SettingEntry.Builder> getSettingEntries() {
            List<SettingEntry.Builder> result = SettingEntriesCopier.copyToBuilder(this.settingEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSettingEntries(Collection<SettingEntry.BuilderImpl> settingEntries) {
            this.settingEntries = SettingEntriesCopier.copyFromBuilder(settingEntries);
        }

        @Override
        @Transient
        public final Builder settingEntries(Collection<SettingEntry> settingEntries) {
            this.settingEntries = SettingEntriesCopier.copy(settingEntries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settingEntries(SettingEntry... settingEntries) {
            settingEntries(Arrays.asList(settingEntries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder settingEntries(Consumer<SettingEntry.Builder>... settingEntries) {
            settingEntries(Stream.of(settingEntries).map(c -> SettingEntry.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeSettingsResponse build() {
            return new DescribeSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
