/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about a specific update activity for a hybrid directory component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HybridUpdateInfoEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<HybridUpdateInfoEntry.Builder, HybridUpdateInfoEntry> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(HybridUpdateInfoEntry::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusReason").getter(getter(HybridUpdateInfoEntry::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusReason").build()).build();

    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiatedBy").getter(getter(HybridUpdateInfoEntry::initiatedBy)).setter(setter(Builder::initiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()).build();

    private static final SdkField<HybridUpdateValue> NEW_VALUE_FIELD = SdkField
            .<HybridUpdateValue> builder(MarshallingType.SDK_POJO).memberName("NewValue")
            .getter(getter(HybridUpdateInfoEntry::newValue)).setter(setter(Builder::newValue))
            .constructor(HybridUpdateValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NewValue").build()).build();

    private static final SdkField<HybridUpdateValue> PREVIOUS_VALUE_FIELD = SdkField
            .<HybridUpdateValue> builder(MarshallingType.SDK_POJO).memberName("PreviousValue")
            .getter(getter(HybridUpdateInfoEntry::previousValue)).setter(setter(Builder::previousValue))
            .constructor(HybridUpdateValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousValue").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(HybridUpdateInfoEntry::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedDateTime").getter(getter(HybridUpdateInfoEntry::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedDateTime").build())
            .build();

    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssessmentId").getter(getter(HybridUpdateInfoEntry::assessmentId)).setter(setter(Builder::assessmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            STATUS_REASON_FIELD, INITIATED_BY_FIELD, NEW_VALUE_FIELD, PREVIOUS_VALUE_FIELD, START_TIME_FIELD,
            LAST_UPDATED_DATE_TIME_FIELD, ASSESSMENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String statusReason;

    private final String initiatedBy;

    private final HybridUpdateValue newValue;

    private final HybridUpdateValue previousValue;

    private final Instant startTime;

    private final Instant lastUpdatedDateTime;

    private final String assessmentId;

    private HybridUpdateInfoEntry(BuilderImpl builder) {
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.initiatedBy = builder.initiatedBy;
        this.newValue = builder.newValue;
        this.previousValue = builder.previousValue;
        this.startTime = builder.startTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
        this.assessmentId = builder.assessmentId;
    }

    /**
     * <p>
     * The current status of the update activity. Valid values include <code>UPDATED</code>, <code>UPDATING</code>, and
     * <code>UPDATE_FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the update activity. Valid values include <code>UPDATED</code>,
     *         <code>UPDATING</code>, and <code>UPDATE_FAILED</code>.
     * @see UpdateStatus
     */
    public final UpdateStatus status() {
        return UpdateStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the update activity. Valid values include <code>UPDATED</code>, <code>UPDATING</code>, and
     * <code>UPDATE_FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the update activity. Valid values include <code>UPDATED</code>,
     *         <code>UPDATING</code>, and <code>UPDATE_FAILED</code>.
     * @see UpdateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A human-readable description of the update status, including any error details or progress information.
     * </p>
     * 
     * @return A human-readable description of the update status, including any error details or progress information.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * Specifies if the update was initiated by the customer or Amazon Web Services.
     * </p>
     * 
     * @return Specifies if the update was initiated by the customer or Amazon Web Services.
     */
    public final String initiatedBy() {
        return initiatedBy;
    }

    /**
     * <p>
     * The new configuration values being applied in this update.
     * </p>
     * 
     * @return The new configuration values being applied in this update.
     */
    public final HybridUpdateValue newValue() {
        return newValue;
    }

    /**
     * <p>
     * The previous configuration values before this update was applied.
     * </p>
     * 
     * @return The previous configuration values before this update was applied.
     */
    public final HybridUpdateValue previousValue() {
        return previousValue;
    }

    /**
     * <p>
     * The date and time when the update activity was initiated.
     * </p>
     * 
     * @return The date and time when the update activity was initiated.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time when the update activity status was last updated.
     * </p>
     * 
     * @return The date and time when the update activity status was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    /**
     * <p>
     * The identifier of the assessment performed to validate this update configuration.
     * </p>
     * 
     * @return The identifier of the assessment performed to validate this update configuration.
     */
    public final String assessmentId() {
        return assessmentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(newValue());
        hashCode = 31 * hashCode + Objects.hashCode(previousValue());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(assessmentId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HybridUpdateInfoEntry)) {
            return false;
        }
        HybridUpdateInfoEntry other = (HybridUpdateInfoEntry) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(initiatedBy(), other.initiatedBy()) && Objects.equals(newValue(), other.newValue())
                && Objects.equals(previousValue(), other.previousValue()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime())
                && Objects.equals(assessmentId(), other.assessmentId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HybridUpdateInfoEntry").add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("InitiatedBy", initiatedBy()).add("NewValue", newValue()).add("PreviousValue", previousValue())
                .add("StartTime", startTime()).add("LastUpdatedDateTime", lastUpdatedDateTime())
                .add("AssessmentId", assessmentId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "InitiatedBy":
            return Optional.ofNullable(clazz.cast(initiatedBy()));
        case "NewValue":
            return Optional.ofNullable(clazz.cast(newValue()));
        case "PreviousValue":
            return Optional.ofNullable(clazz.cast(previousValue()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "LastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        case "AssessmentId":
            return Optional.ofNullable(clazz.cast(assessmentId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("StatusReason", STATUS_REASON_FIELD);
        map.put("InitiatedBy", INITIATED_BY_FIELD);
        map.put("NewValue", NEW_VALUE_FIELD);
        map.put("PreviousValue", PREVIOUS_VALUE_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        map.put("AssessmentId", ASSESSMENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HybridUpdateInfoEntry, T> g) {
        return obj -> g.apply((HybridUpdateInfoEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HybridUpdateInfoEntry> {
        /**
         * <p>
         * The current status of the update activity. Valid values include <code>UPDATED</code>, <code>UPDATING</code>,
         * and <code>UPDATE_FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the update activity. Valid values include <code>UPDATED</code>,
         *        <code>UPDATING</code>, and <code>UPDATE_FAILED</code>.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the update activity. Valid values include <code>UPDATED</code>, <code>UPDATING</code>,
         * and <code>UPDATE_FAILED</code>.
         * </p>
         * 
         * @param status
         *        The current status of the update activity. Valid values include <code>UPDATED</code>,
         *        <code>UPDATING</code>, and <code>UPDATE_FAILED</code>.
         * @see UpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateStatus
         */
        Builder status(UpdateStatus status);

        /**
         * <p>
         * A human-readable description of the update status, including any error details or progress information.
         * </p>
         * 
         * @param statusReason
         *        A human-readable description of the update status, including any error details or progress
         *        information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * Specifies if the update was initiated by the customer or Amazon Web Services.
         * </p>
         * 
         * @param initiatedBy
         *        Specifies if the update was initiated by the customer or Amazon Web Services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initiatedBy(String initiatedBy);

        /**
         * <p>
         * The new configuration values being applied in this update.
         * </p>
         * 
         * @param newValue
         *        The new configuration values being applied in this update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newValue(HybridUpdateValue newValue);

        /**
         * <p>
         * The new configuration values being applied in this update.
         * </p>
         * This is a convenience method that creates an instance of the {@link HybridUpdateValue.Builder} avoiding the
         * need to create one manually via {@link HybridUpdateValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HybridUpdateValue.Builder#build()} is called immediately and its
         * result is passed to {@link #newValue(HybridUpdateValue)}.
         * 
         * @param newValue
         *        a consumer that will call methods on {@link HybridUpdateValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newValue(HybridUpdateValue)
         */
        default Builder newValue(Consumer<HybridUpdateValue.Builder> newValue) {
            return newValue(HybridUpdateValue.builder().applyMutation(newValue).build());
        }

        /**
         * <p>
         * The previous configuration values before this update was applied.
         * </p>
         * 
         * @param previousValue
         *        The previous configuration values before this update was applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousValue(HybridUpdateValue previousValue);

        /**
         * <p>
         * The previous configuration values before this update was applied.
         * </p>
         * This is a convenience method that creates an instance of the {@link HybridUpdateValue.Builder} avoiding the
         * need to create one manually via {@link HybridUpdateValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HybridUpdateValue.Builder#build()} is called immediately and its
         * result is passed to {@link #previousValue(HybridUpdateValue)}.
         * 
         * @param previousValue
         *        a consumer that will call methods on {@link HybridUpdateValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #previousValue(HybridUpdateValue)
         */
        default Builder previousValue(Consumer<HybridUpdateValue.Builder> previousValue) {
            return previousValue(HybridUpdateValue.builder().applyMutation(previousValue).build());
        }

        /**
         * <p>
         * The date and time when the update activity was initiated.
         * </p>
         * 
         * @param startTime
         *        The date and time when the update activity was initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time when the update activity status was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time when the update activity status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);

        /**
         * <p>
         * The identifier of the assessment performed to validate this update configuration.
         * </p>
         * 
         * @param assessmentId
         *        The identifier of the assessment performed to validate this update configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assessmentId(String assessmentId);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String statusReason;

        private String initiatedBy;

        private HybridUpdateValue newValue;

        private HybridUpdateValue previousValue;

        private Instant startTime;

        private Instant lastUpdatedDateTime;

        private String assessmentId;

        private BuilderImpl() {
        }

        private BuilderImpl(HybridUpdateInfoEntry model) {
            status(model.status);
            statusReason(model.statusReason);
            initiatedBy(model.initiatedBy);
            newValue(model.newValue);
            previousValue(model.previousValue);
            startTime(model.startTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
            assessmentId(model.assessmentId);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getInitiatedBy() {
            return initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        public final HybridUpdateValue.Builder getNewValue() {
            return newValue != null ? newValue.toBuilder() : null;
        }

        public final void setNewValue(HybridUpdateValue.BuilderImpl newValue) {
            this.newValue = newValue != null ? newValue.build() : null;
        }

        @Override
        public final Builder newValue(HybridUpdateValue newValue) {
            this.newValue = newValue;
            return this;
        }

        public final HybridUpdateValue.Builder getPreviousValue() {
            return previousValue != null ? previousValue.toBuilder() : null;
        }

        public final void setPreviousValue(HybridUpdateValue.BuilderImpl previousValue) {
            this.previousValue = previousValue != null ? previousValue.build() : null;
        }

        @Override
        public final Builder previousValue(HybridUpdateValue previousValue) {
            this.previousValue = previousValue;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        public final String getAssessmentId() {
            return assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        @Override
        public HybridUpdateInfoEntry build() {
            return new HybridUpdateInfoEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
