/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the IP address block. This is often the address block of the DNS server used for your self-managed domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpRoute implements SdkPojo, Serializable, ToCopyableBuilder<IpRoute.Builder, IpRoute> {
    private static final SdkField<String> CIDR_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CidrIp")
            .getter(getter(IpRoute::cidrIp)).setter(setter(Builder::cidrIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").build()).build();

    private static final SdkField<String> CIDR_IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CidrIpv6").getter(getter(IpRoute::cidrIpv6)).setter(setter(Builder::cidrIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIpv6").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(IpRoute::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CIDR_IP_FIELD,
            CIDR_IPV6_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cidrIp;

    private final String cidrIpv6;

    private final String description;

    private IpRoute(BuilderImpl builder) {
        this.cidrIp = builder.cidrIp;
        this.cidrIpv6 = builder.cidrIpv6;
        this.description = builder.description;
    }

    /**
     * <p>
     * IP address block in CIDR format, such as 10.0.0.0/24. This is often the address block of the DNS server used for
     * your self-managed domain. For a single IP address, use a CIDR address block with /32. For example, 10.0.0.0/32.
     * </p>
     * 
     * @return IP address block in CIDR format, such as 10.0.0.0/24. This is often the address block of the DNS server
     *         used for your self-managed domain. For a single IP address, use a CIDR address block with /32. For
     *         example, 10.0.0.0/32.
     */
    public final String cidrIp() {
        return cidrIp;
    }

    /**
     * <p>
     * IPv6 address block in CIDR format, such as 2001:db8::/32. This is often the address block of the DNS server used
     * for your self-managed domain. For a single IPv6 address, use a CIDR address block with /128. For example,
     * 2001:db8::1/128.
     * </p>
     * 
     * @return IPv6 address block in CIDR format, such as 2001:db8::/32. This is often the address block of the DNS
     *         server used for your self-managed domain. For a single IPv6 address, use a CIDR address block with /128.
     *         For example, 2001:db8::1/128.
     */
    public final String cidrIpv6() {
        return cidrIpv6;
    }

    /**
     * <p>
     * Description of the address block.
     * </p>
     * 
     * @return Description of the address block.
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(cidrIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRoute)) {
            return false;
        }
        IpRoute other = (IpRoute) obj;
        return Objects.equals(cidrIp(), other.cidrIp()) && Objects.equals(cidrIpv6(), other.cidrIpv6())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpRoute").add("CidrIp", cidrIp()).add("CidrIpv6", cidrIpv6()).add("Description", description())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CidrIp":
            return Optional.ofNullable(clazz.cast(cidrIp()));
        case "CidrIpv6":
            return Optional.ofNullable(clazz.cast(cidrIpv6()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CidrIp", CIDR_IP_FIELD);
        map.put("CidrIpv6", CIDR_IPV6_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpRoute, T> g) {
        return obj -> g.apply((IpRoute) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpRoute> {
        /**
         * <p>
         * IP address block in CIDR format, such as 10.0.0.0/24. This is often the address block of the DNS server used
         * for your self-managed domain. For a single IP address, use a CIDR address block with /32. For example,
         * 10.0.0.0/32.
         * </p>
         * 
         * @param cidrIp
         *        IP address block in CIDR format, such as 10.0.0.0/24. This is often the address block of the DNS
         *        server used for your self-managed domain. For a single IP address, use a CIDR address block with /32.
         *        For example, 10.0.0.0/32.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIp(String cidrIp);

        /**
         * <p>
         * IPv6 address block in CIDR format, such as 2001:db8::/32. This is often the address block of the DNS server
         * used for your self-managed domain. For a single IPv6 address, use a CIDR address block with /128. For
         * example, 2001:db8::1/128.
         * </p>
         * 
         * @param cidrIpv6
         *        IPv6 address block in CIDR format, such as 2001:db8::/32. This is often the address block of the DNS
         *        server used for your self-managed domain. For a single IPv6 address, use a CIDR address block with
         *        /128. For example, 2001:db8::1/128.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrIpv6(String cidrIpv6);

        /**
         * <p>
         * Description of the address block.
         * </p>
         * 
         * @param description
         *        Description of the address block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl implements Builder {
        private String cidrIp;

        private String cidrIpv6;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRoute model) {
            cidrIp(model.cidrIp);
            cidrIpv6(model.cidrIpv6);
            description(model.description);
        }

        public final String getCidrIp() {
            return cidrIp;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final String getCidrIpv6() {
            return cidrIpv6;
        }

        public final void setCidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
        }

        @Override
        public final Builder cidrIpv6(String cidrIpv6) {
            this.cidrIpv6 = cidrIpv6;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public IpRoute build() {
            return new IpRoute(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
