/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSchemaExtensionResponse extends DirectoryResponse implements
        ToCopyableBuilder<StartSchemaExtensionResponse.Builder, StartSchemaExtensionResponse> {
    private static final SdkField<String> SCHEMA_EXTENSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaExtensionId").getter(getter(StartSchemaExtensionResponse::schemaExtensionId))
            .setter(setter(Builder::schemaExtensionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaExtensionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_EXTENSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String schemaExtensionId;

    private StartSchemaExtensionResponse(BuilderImpl builder) {
        super(builder);
        this.schemaExtensionId = builder.schemaExtensionId;
    }

    /**
     * <p>
     * The identifier of the schema extension that will be applied.
     * </p>
     * 
     * @return The identifier of the schema extension that will be applied.
     */
    public final String schemaExtensionId() {
        return schemaExtensionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaExtensionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSchemaExtensionResponse)) {
            return false;
        }
        StartSchemaExtensionResponse other = (StartSchemaExtensionResponse) obj;
        return Objects.equals(schemaExtensionId(), other.schemaExtensionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSchemaExtensionResponse").add("SchemaExtensionId", schemaExtensionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaExtensionId":
            return Optional.ofNullable(clazz.cast(schemaExtensionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaExtensionId", SCHEMA_EXTENSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSchemaExtensionResponse, T> g) {
        return obj -> g.apply((StartSchemaExtensionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartSchemaExtensionResponse> {
        /**
         * <p>
         * The identifier of the schema extension that will be applied.
         * </p>
         * 
         * @param schemaExtensionId
         *        The identifier of the schema extension that will be applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaExtensionId(String schemaExtensionId);
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private String schemaExtensionId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSchemaExtensionResponse model) {
            super(model);
            schemaExtensionId(model.schemaExtensionId);
        }

        public final String getSchemaExtensionId() {
            return schemaExtensionId;
        }

        public final void setSchemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
        }

        @Override
        public final Builder schemaExtensionId(String schemaExtensionId) {
            this.schemaExtensionId = schemaExtensionId;
            return this;
        }

        @Override
        public StartSchemaExtensionResponse build() {
            return new StartSchemaExtensionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
