/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectorySetupRequest extends DirectoryRequest implements
        ToCopyableBuilder<UpdateDirectorySetupRequest.Builder, UpdateDirectorySetupRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(UpdateDirectorySetupRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateType").getter(getter(UpdateDirectorySetupRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()).build();

    private static final SdkField<OSUpdateSettings> OS_UPDATE_SETTINGS_FIELD = SdkField
            .<OSUpdateSettings> builder(MarshallingType.SDK_POJO).memberName("OSUpdateSettings")
            .getter(getter(UpdateDirectorySetupRequest::osUpdateSettings)).setter(setter(Builder::osUpdateSettings))
            .constructor(OSUpdateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OSUpdateSettings").build()).build();

    private static final SdkField<DirectorySizeUpdateSettings> DIRECTORY_SIZE_UPDATE_SETTINGS_FIELD = SdkField
            .<DirectorySizeUpdateSettings> builder(MarshallingType.SDK_POJO)
            .memberName("DirectorySizeUpdateSettings")
            .getter(getter(UpdateDirectorySetupRequest::directorySizeUpdateSettings))
            .setter(setter(Builder::directorySizeUpdateSettings))
            .constructor(DirectorySizeUpdateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectorySizeUpdateSettings")
                    .build()).build();

    private static final SdkField<NetworkUpdateSettings> NETWORK_UPDATE_SETTINGS_FIELD = SdkField
            .<NetworkUpdateSettings> builder(MarshallingType.SDK_POJO).memberName("NetworkUpdateSettings")
            .getter(getter(UpdateDirectorySetupRequest::networkUpdateSettings)).setter(setter(Builder::networkUpdateSettings))
            .constructor(NetworkUpdateSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkUpdateSettings").build())
            .build();

    private static final SdkField<Boolean> CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CreateSnapshotBeforeUpdate")
            .getter(getter(UpdateDirectorySetupRequest::createSnapshotBeforeUpdate))
            .setter(setter(Builder::createSnapshotBeforeUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateSnapshotBeforeUpdate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            UPDATE_TYPE_FIELD, OS_UPDATE_SETTINGS_FIELD, DIRECTORY_SIZE_UPDATE_SETTINGS_FIELD, NETWORK_UPDATE_SETTINGS_FIELD,
            CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String directoryId;

    private final String updateType;

    private final OSUpdateSettings osUpdateSettings;

    private final DirectorySizeUpdateSettings directorySizeUpdateSettings;

    private final NetworkUpdateSettings networkUpdateSettings;

    private final Boolean createSnapshotBeforeUpdate;

    private UpdateDirectorySetupRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.updateType = builder.updateType;
        this.osUpdateSettings = builder.osUpdateSettings;
        this.directorySizeUpdateSettings = builder.directorySizeUpdateSettings;
        this.networkUpdateSettings = builder.networkUpdateSettings;
        this.createSnapshotBeforeUpdate = builder.createSnapshotBeforeUpdate;
    }

    /**
     * <p>
     * The identifier of the directory to update.
     * </p>
     * 
     * @return The identifier of the directory to update.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The type of update to perform on the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of update to perform on the directory.
     * @see UpdateType
     */
    public final UpdateType updateType() {
        return UpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The type of update to perform on the directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link UpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of update to perform on the directory.
     * @see UpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    /**
     * <p>
     * Operating system configuration to apply during the directory update operation.
     * </p>
     * 
     * @return Operating system configuration to apply during the directory update operation.
     */
    public final OSUpdateSettings osUpdateSettings() {
        return osUpdateSettings;
    }

    /**
     * <p>
     * Directory size configuration to apply during the update operation.
     * </p>
     * 
     * @return Directory size configuration to apply during the update operation.
     */
    public final DirectorySizeUpdateSettings directorySizeUpdateSettings() {
        return directorySizeUpdateSettings;
    }

    /**
     * <p>
     * Network configuration to apply during the directory update operation.
     * </p>
     * 
     * @return Network configuration to apply during the directory update operation.
     */
    public final NetworkUpdateSettings networkUpdateSettings() {
        return networkUpdateSettings;
    }

    /**
     * <p>
     * Specifies whether to create a directory snapshot before performing the update.
     * </p>
     * 
     * @return Specifies whether to create a directory snapshot before performing the update.
     */
    public final Boolean createSnapshotBeforeUpdate() {
        return createSnapshotBeforeUpdate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(osUpdateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(directorySizeUpdateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(networkUpdateSettings());
        hashCode = 31 * hashCode + Objects.hashCode(createSnapshotBeforeUpdate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectorySetupRequest)) {
            return false;
        }
        UpdateDirectorySetupRequest other = (UpdateDirectorySetupRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString())
                && Objects.equals(osUpdateSettings(), other.osUpdateSettings())
                && Objects.equals(directorySizeUpdateSettings(), other.directorySizeUpdateSettings())
                && Objects.equals(networkUpdateSettings(), other.networkUpdateSettings())
                && Objects.equals(createSnapshotBeforeUpdate(), other.createSnapshotBeforeUpdate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDirectorySetupRequest").add("DirectoryId", directoryId())
                .add("UpdateType", updateTypeAsString()).add("OSUpdateSettings", osUpdateSettings())
                .add("DirectorySizeUpdateSettings", directorySizeUpdateSettings())
                .add("NetworkUpdateSettings", networkUpdateSettings())
                .add("CreateSnapshotBeforeUpdate", createSnapshotBeforeUpdate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "UpdateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        case "OSUpdateSettings":
            return Optional.ofNullable(clazz.cast(osUpdateSettings()));
        case "DirectorySizeUpdateSettings":
            return Optional.ofNullable(clazz.cast(directorySizeUpdateSettings()));
        case "NetworkUpdateSettings":
            return Optional.ofNullable(clazz.cast(networkUpdateSettings()));
        case "CreateSnapshotBeforeUpdate":
            return Optional.ofNullable(clazz.cast(createSnapshotBeforeUpdate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("UpdateType", UPDATE_TYPE_FIELD);
        map.put("OSUpdateSettings", OS_UPDATE_SETTINGS_FIELD);
        map.put("DirectorySizeUpdateSettings", DIRECTORY_SIZE_UPDATE_SETTINGS_FIELD);
        map.put("NetworkUpdateSettings", NETWORK_UPDATE_SETTINGS_FIELD);
        map.put("CreateSnapshotBeforeUpdate", CREATE_SNAPSHOT_BEFORE_UPDATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectorySetupRequest, T> g) {
        return obj -> g.apply((UpdateDirectorySetupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDirectorySetupRequest> {
        /**
         * <p>
         * The identifier of the directory to update.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The type of update to perform on the directory.
         * </p>
         * 
         * @param updateType
         *        The type of update to perform on the directory.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The type of update to perform on the directory.
         * </p>
         * 
         * @param updateType
         *        The type of update to perform on the directory.
         * @see UpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateType
         */
        Builder updateType(UpdateType updateType);

        /**
         * <p>
         * Operating system configuration to apply during the directory update operation.
         * </p>
         * 
         * @param osUpdateSettings
         *        Operating system configuration to apply during the directory update operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder osUpdateSettings(OSUpdateSettings osUpdateSettings);

        /**
         * <p>
         * Operating system configuration to apply during the directory update operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link OSUpdateSettings.Builder} avoiding the
         * need to create one manually via {@link OSUpdateSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OSUpdateSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #osUpdateSettings(OSUpdateSettings)}.
         * 
         * @param osUpdateSettings
         *        a consumer that will call methods on {@link OSUpdateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #osUpdateSettings(OSUpdateSettings)
         */
        default Builder osUpdateSettings(Consumer<OSUpdateSettings.Builder> osUpdateSettings) {
            return osUpdateSettings(OSUpdateSettings.builder().applyMutation(osUpdateSettings).build());
        }

        /**
         * <p>
         * Directory size configuration to apply during the update operation.
         * </p>
         * 
         * @param directorySizeUpdateSettings
         *        Directory size configuration to apply during the update operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directorySizeUpdateSettings(DirectorySizeUpdateSettings directorySizeUpdateSettings);

        /**
         * <p>
         * Directory size configuration to apply during the update operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DirectorySizeUpdateSettings.Builder}
         * avoiding the need to create one manually via {@link DirectorySizeUpdateSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DirectorySizeUpdateSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #directorySizeUpdateSettings(DirectorySizeUpdateSettings)}.
         * 
         * @param directorySizeUpdateSettings
         *        a consumer that will call methods on {@link DirectorySizeUpdateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directorySizeUpdateSettings(DirectorySizeUpdateSettings)
         */
        default Builder directorySizeUpdateSettings(Consumer<DirectorySizeUpdateSettings.Builder> directorySizeUpdateSettings) {
            return directorySizeUpdateSettings(DirectorySizeUpdateSettings.builder().applyMutation(directorySizeUpdateSettings)
                    .build());
        }

        /**
         * <p>
         * Network configuration to apply during the directory update operation.
         * </p>
         * 
         * @param networkUpdateSettings
         *        Network configuration to apply during the directory update operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkUpdateSettings(NetworkUpdateSettings networkUpdateSettings);

        /**
         * <p>
         * Network configuration to apply during the directory update operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link NetworkUpdateSettings.Builder} avoiding
         * the need to create one manually via {@link NetworkUpdateSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkUpdateSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #networkUpdateSettings(NetworkUpdateSettings)}.
         * 
         * @param networkUpdateSettings
         *        a consumer that will call methods on {@link NetworkUpdateSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkUpdateSettings(NetworkUpdateSettings)
         */
        default Builder networkUpdateSettings(Consumer<NetworkUpdateSettings.Builder> networkUpdateSettings) {
            return networkUpdateSettings(NetworkUpdateSettings.builder().applyMutation(networkUpdateSettings).build());
        }

        /**
         * <p>
         * Specifies whether to create a directory snapshot before performing the update.
         * </p>
         * 
         * @param createSnapshotBeforeUpdate
         *        Specifies whether to create a directory snapshot before performing the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private String updateType;

        private OSUpdateSettings osUpdateSettings;

        private DirectorySizeUpdateSettings directorySizeUpdateSettings;

        private NetworkUpdateSettings networkUpdateSettings;

        private Boolean createSnapshotBeforeUpdate;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectorySetupRequest model) {
            super(model);
            directoryId(model.directoryId);
            updateType(model.updateType);
            osUpdateSettings(model.osUpdateSettings);
            directorySizeUpdateSettings(model.directorySizeUpdateSettings);
            networkUpdateSettings(model.networkUpdateSettings);
            createSnapshotBeforeUpdate(model.createSnapshotBeforeUpdate);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(UpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final OSUpdateSettings.Builder getOsUpdateSettings() {
            return osUpdateSettings != null ? osUpdateSettings.toBuilder() : null;
        }

        public final void setOsUpdateSettings(OSUpdateSettings.BuilderImpl osUpdateSettings) {
            this.osUpdateSettings = osUpdateSettings != null ? osUpdateSettings.build() : null;
        }

        @Override
        public final Builder osUpdateSettings(OSUpdateSettings osUpdateSettings) {
            this.osUpdateSettings = osUpdateSettings;
            return this;
        }

        public final DirectorySizeUpdateSettings.Builder getDirectorySizeUpdateSettings() {
            return directorySizeUpdateSettings != null ? directorySizeUpdateSettings.toBuilder() : null;
        }

        public final void setDirectorySizeUpdateSettings(DirectorySizeUpdateSettings.BuilderImpl directorySizeUpdateSettings) {
            this.directorySizeUpdateSettings = directorySizeUpdateSettings != null ? directorySizeUpdateSettings.build() : null;
        }

        @Override
        public final Builder directorySizeUpdateSettings(DirectorySizeUpdateSettings directorySizeUpdateSettings) {
            this.directorySizeUpdateSettings = directorySizeUpdateSettings;
            return this;
        }

        public final NetworkUpdateSettings.Builder getNetworkUpdateSettings() {
            return networkUpdateSettings != null ? networkUpdateSettings.toBuilder() : null;
        }

        public final void setNetworkUpdateSettings(NetworkUpdateSettings.BuilderImpl networkUpdateSettings) {
            this.networkUpdateSettings = networkUpdateSettings != null ? networkUpdateSettings.build() : null;
        }

        @Override
        public final Builder networkUpdateSettings(NetworkUpdateSettings networkUpdateSettings) {
            this.networkUpdateSettings = networkUpdateSettings;
            return this;
        }

        public final Boolean getCreateSnapshotBeforeUpdate() {
            return createSnapshotBeforeUpdate;
        }

        public final void setCreateSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate) {
            this.createSnapshotBeforeUpdate = createSnapshotBeforeUpdate;
        }

        @Override
        public final Builder createSnapshotBeforeUpdate(Boolean createSnapshotBeforeUpdate) {
            this.createSnapshotBeforeUpdate = createSnapshotBeforeUpdate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectorySetupRequest build() {
            return new UpdateDirectorySetupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
