/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.ConditionalForwarder;
import software.amazon.awssdk.services.directory.model.ConditionalForwardersCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConditionalForwardersResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeConditionalForwardersResponse> {
    private static final SdkField<List<ConditionalForwarder>> CONDITIONAL_FORWARDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeConditionalForwardersResponse.getter(DescribeConditionalForwardersResponse::conditionalForwarders)).setter(DescribeConditionalForwardersResponse.setter(Builder::conditionalForwarders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalForwarders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ConditionalForwarder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITIONAL_FORWARDERS_FIELD));
    private final List<ConditionalForwarder> conditionalForwarders;

    private DescribeConditionalForwardersResponse(BuilderImpl builder) {
        super(builder);
        this.conditionalForwarders = builder.conditionalForwarders;
    }

    public List<ConditionalForwarder> conditionalForwarders() {
        return this.conditionalForwarders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalForwarders());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConditionalForwardersResponse)) {
            return false;
        }
        DescribeConditionalForwardersResponse other = (DescribeConditionalForwardersResponse)((Object)obj);
        return Objects.equals(this.conditionalForwarders(), other.conditionalForwarders());
    }

    public String toString() {
        return ToString.builder((String)"DescribeConditionalForwardersResponse").add("ConditionalForwarders", this.conditionalForwarders()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConditionalForwarders": {
                return Optional.ofNullable(clazz.cast(this.conditionalForwarders()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConditionalForwardersResponse, T> g) {
        return obj -> g.apply((DescribeConditionalForwardersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<ConditionalForwarder> conditionalForwarders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConditionalForwardersResponse model) {
            super(model);
            this.conditionalForwarders(model.conditionalForwarders);
        }

        public final Collection<ConditionalForwarder.Builder> getConditionalForwarders() {
            return this.conditionalForwarders != null ? (Collection)this.conditionalForwarders.stream().map(ConditionalForwarder::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder conditionalForwarders(Collection<ConditionalForwarder> conditionalForwarders) {
            this.conditionalForwarders = ConditionalForwardersCopier.copy(conditionalForwarders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalForwarders(ConditionalForwarder ... conditionalForwarders) {
            this.conditionalForwarders(Arrays.asList(conditionalForwarders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalForwarders(Consumer<ConditionalForwarder.Builder> ... conditionalForwarders) {
            this.conditionalForwarders(Stream.of(conditionalForwarders).map(c -> (ConditionalForwarder)((ConditionalForwarder.Builder)ConditionalForwarder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setConditionalForwarders(Collection<ConditionalForwarder.BuilderImpl> conditionalForwarders) {
            this.conditionalForwarders = ConditionalForwardersCopier.copyFromBuilder(conditionalForwarders);
        }

        @Override
        public DescribeConditionalForwardersResponse build() {
            return new DescribeConditionalForwardersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConditionalForwardersResponse> {
        public Builder conditionalForwarders(Collection<ConditionalForwarder> var1);

        public Builder conditionalForwarders(ConditionalForwarder ... var1);

        public Builder conditionalForwarders(Consumer<ConditionalForwarder.Builder> ... var1);
    }
}

